/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.lookup;

import io.skylite.common.CheckedSupplier;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.search.lookup.LeafDocLookup;
import io.skylite.core.search.lookup.LeafSearchLookup;
import io.skylite.core.search.lookup.LeafStoredFieldsLookup;
import io.skylite.core.search.lookup.SourceLookup;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFields;

public class SearchLookup {
    private static final int MAX_FIELD_CHAIN_DEPTH = 5;
    private final Set<String> fieldChain;
    private final SourceLookup sourceLookup;
    private final Function<String, BaseMappedFieldType> fieldTypeLookup;
    private final BiFunction<BaseMappedFieldType, Supplier<SearchLookup>, BaseIndexFieldData<?>> fieldDataLookup;

    public SearchLookup(Function<String, BaseMappedFieldType> fieldTypeLookup, BiFunction<BaseMappedFieldType, Supplier<SearchLookup>, BaseIndexFieldData<?>> fieldDataLookup) {
        this.fieldTypeLookup = fieldTypeLookup;
        this.fieldChain = Collections.emptySet();
        this.sourceLookup = new SourceLookup();
        this.fieldDataLookup = fieldDataLookup;
    }

    private SearchLookup(SearchLookup searchLookup, Set<String> fieldChain) {
        this.fieldChain = Collections.unmodifiableSet(fieldChain);
        this.sourceLookup = searchLookup.sourceLookup;
        this.fieldTypeLookup = searchLookup.fieldTypeLookup;
        this.fieldDataLookup = searchLookup.fieldDataLookup;
    }

    public final SearchLookup forkAndTrackFieldReferences(String field) {
        Objects.requireNonNull(field, "field cannot be null");
        LinkedHashSet<String> newFieldChain = new LinkedHashSet<String>(this.fieldChain);
        if (!newFieldChain.add(field)) {
            String message = String.join((CharSequence)" -> ", newFieldChain) + " -> " + field;
            throw new IllegalArgumentException("Cyclic dependency detected while resolving runtime fields: " + message);
        }
        if (newFieldChain.size() > 5) {
            throw new IllegalArgumentException("Field requires resolving too many dependent fields: " + String.join((CharSequence)" -> ", newFieldChain));
        }
        return new SearchLookup(this, newFieldChain);
    }

    public LeafSearchLookup getLeafSearchLookup(LeafReaderContext context) {
        return new LeafSearchLookup(context, new LeafDocLookup(this.fieldTypeLookup, this::getForField, context), this.sourceLookup, new LeafStoredFieldsLookup(this.fieldTypeLookup, (CheckedSupplier<StoredFields, IOException>)((CheckedSupplier)() -> context.reader().storedFields())));
    }

    public BaseMappedFieldType fieldType(String fieldName) {
        return this.fieldTypeLookup.apply(fieldName);
    }

    public SourceLookup source() {
        return this.sourceLookup;
    }

    public BaseIndexFieldData<?> getForField(BaseMappedFieldType fieldType) {
        return this.fieldDataLookup.apply(fieldType, () -> this.forkAndTrackFieldReferences(fieldType.name()));
    }
}

