/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.lookup;

import io.skylite.SkyliteParseException;
import io.skylite.common.CheckedBiConsumer;
import io.skylite.common.Nullable;
import io.skylite.common.collect.Tuple;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.index.storedfieldloader.StoredFieldsLoader;
import io.skylite.core.lucene.index.SequentialStoredFieldsLeafReader;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFields;

public class SourceLookup
implements Map {
    private LeafReader reader;
    CheckedBiConsumer<Integer, StoredFieldsLoader, IOException> storedFieldReader;
    private int docId = -1;
    private BytesReference sourceAsBytes;
    private Map<String, Object> source;
    private MediaType sourceContentType;

    public Map<String, Object> source() {
        return this.source;
    }

    public MediaType sourceContentType() {
        return this.sourceContentType;
    }

    public int docId() {
        return this.docId;
    }

    public Map<String, Object> loadSourceIfNeeded() {
        if (this.source != null) {
            return this.source;
        }
        if (this.sourceAsBytes != null) {
            Tuple<? extends MediaType, Map<String, Object>> tuple = SourceLookup.sourceAsMapAndType(this.sourceAsBytes);
            this.sourceContentType = (MediaType)tuple.v1();
            this.source = (Map)tuple.v2();
            return this.source;
        }
        try {
            StoredFieldsLoader storedFieldsLoader = new StoredFieldsLoader(true);
            this.storedFieldReader.accept((Object)this.docId, (Object)storedFieldsLoader);
            BytesReference source = storedFieldsLoader.source();
            if (source == null) {
                this.source = Collections.emptyMap();
                this.sourceContentType = null;
            } else {
                Tuple<? extends MediaType, Map<String, Object>> tuple = SourceLookup.sourceAsMapAndType(source);
                this.sourceContentType = (MediaType)tuple.v1();
                this.source = (Map)tuple.v2();
            }
        }
        catch (Exception e) {
            throw new SkyliteParseException("failed to parse / load source", (Throwable)e, new Object[0]);
        }
        return this.source;
    }

    private static Tuple<? extends MediaType, Map<String, Object>> sourceAsMapAndType(BytesReference source) throws SkyliteParseException {
        return XContentHelper.convertToMap(source, false);
    }

    public static Map<String, Object> sourceAsMap(BytesReference source) throws SkyliteParseException {
        return (Map)SourceLookup.sourceAsMapAndType(source).v2();
    }

    public void setSegmentAndDocument(LeafReaderContext context, int docId) {
        if (this.reader == context.reader() && this.docId == docId) {
            return;
        }
        if (this.reader != context.reader()) {
            this.reader = context.reader();
            try {
                if (this.reader instanceof SequentialStoredFieldsLeafReader) {
                    SequentialStoredFieldsLeafReader lf = (SequentialStoredFieldsLeafReader)this.reader;
                    this.storedFieldReader = (arg_0, arg_1) -> ((StoredFieldsReader)lf.getSequentialStoredFieldsReader()).document(arg_0, arg_1);
                } else {
                    this.storedFieldReader = (arg_0, arg_1) -> ((StoredFields)this.reader.storedFields()).document(arg_0, arg_1);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.source = null;
        this.sourceAsBytes = null;
        this.docId = docId;
    }

    public void setSource(BytesReference source) {
        this.sourceAsBytes = source;
    }

    public void setSourceContentType(MediaType sourceContentType) {
        this.sourceContentType = sourceContentType;
    }

    public void setSource(Map<String, Object> source) {
        this.source = source;
    }

    public BytesReference internalSourceRef() {
        return this.sourceAsBytes;
    }

    public List<Object> extractRawValues(String path) {
        return XContentMapValuesUtil.extractRawValues(path, this.loadSourceIfNeeded());
    }

    public Object extractValue(String path, @Nullable Object nullValue) {
        return XContentMapValuesUtil.extractValue(path, this.loadSourceIfNeeded(), nullValue);
    }

    public Object filter(FetchSourceContext context) {
        return context.getFilter().apply(this.loadSourceIfNeeded());
    }

    public Object get(Object key) {
        return this.loadSourceIfNeeded().get(key);
    }

    @Override
    public int size() {
        return this.loadSourceIfNeeded().size();
    }

    @Override
    public boolean isEmpty() {
        return this.loadSourceIfNeeded().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.loadSourceIfNeeded().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.loadSourceIfNeeded().containsValue(value);
    }

    public Set keySet() {
        return this.loadSourceIfNeeded().keySet();
    }

    public Collection values() {
        return this.loadSourceIfNeeded().values();
    }

    public Set entrySet() {
        return this.loadSourceIfNeeded().entrySet();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

