/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.pipeline;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.search.SearchPhaseContext;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.phase.SearchPhaseResults;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.NamedWriteableAwareStreamInput;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.pipeline.PipelinedRequest;
import io.skylite.core.search.pipeline.SearchPhaseResultsProcessor;
import io.skylite.core.search.pipeline.SearchPipelineProcessingException;
import io.skylite.core.search.pipeline.SearchProcessor;
import io.skylite.core.search.pipeline.SearchRequestProcessor;
import io.skylite.core.search.pipeline.SearchResponseProcessor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class Pipeline {
    private static final Logger logger = LogManager.getLogger(Pipeline.class);
    private final String id;
    private final String description;
    private final Integer version;
    private final List<SearchRequestProcessor> searchRequestProcessors;
    private final List<SearchResponseProcessor> searchResponseProcessors;
    private final List<SearchPhaseResultsProcessor> searchPhaseResultsProcessors;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final LongSupplier relativeTimeSupplier;
    static final Pipeline NO_OP_PIPELINE = new Pipeline("_none", "Pipeline that does not transform anything", 0, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, () -> 0L);

    Pipeline(String id, @Nullable String description, @Nullable Integer version, List<SearchRequestProcessor> requestProcessors, List<SearchResponseProcessor> responseProcessors, List<SearchPhaseResultsProcessor> phaseResultsProcessors, NamedWriteableRegistry namedWriteableRegistry, LongSupplier relativeTimeSupplier) {
        this.id = id;
        this.description = description;
        this.version = version;
        this.searchRequestProcessors = Collections.unmodifiableList(requestProcessors);
        this.searchResponseProcessors = Collections.unmodifiableList(responseProcessors);
        this.searchPhaseResultsProcessors = Collections.unmodifiableList(phaseResultsProcessors);
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.relativeTimeSupplier = relativeTimeSupplier;
    }

    String getId() {
        return this.id;
    }

    String getDescription() {
        return this.description;
    }

    Integer getVersion() {
        return this.version;
    }

    List<SearchRequestProcessor> getSearchRequestProcessors() {
        return this.searchRequestProcessors;
    }

    List<SearchResponseProcessor> getSearchResponseProcessors() {
        return this.searchResponseProcessors;
    }

    List<SearchPhaseResultsProcessor> getSearchPhaseResultsProcessors() {
        return this.searchPhaseResultsProcessors;
    }

    protected void beforeTransformRequest() {
    }

    protected void afterTransformRequest(long timeInNanos) {
    }

    protected void onTransformRequestFailure() {
    }

    protected void beforeRequestProcessor(SearchProcessor processor) {
    }

    protected void afterRequestProcessor(SearchProcessor processor, long timeInNanos) {
    }

    protected void onRequestProcessorFailed(SearchProcessor processor) {
    }

    protected void beforeTransformResponse() {
    }

    protected void afterTransformResponse(long timeInNanos) {
    }

    protected void onTransformResponseFailure() {
    }

    protected void beforeResponseProcessor(SearchProcessor processor) {
    }

    protected void afterResponseProcessor(SearchProcessor processor, long timeInNanos) {
    }

    protected void onResponseProcessorFailed(SearchProcessor processor) {
    }

    void transformRequest(SearchRequest request, ActionListener<SearchRequest> requestListener) throws SearchPipelineProcessingException {
        ActionListener<SearchRequest> finalListener;
        if (this.searchRequestProcessors.isEmpty()) {
            requestListener.onResponse((Object)request);
            return;
        }
        try (BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();){
            request.writeTo(bytesStreamOutput);
            try (StreamInput in = bytesStreamOutput.bytes().streamInput();
                 NamedWriteableAwareStreamInput input = new NamedWriteableAwareStreamInput(in, this.namedWriteableRegistry);){
                request = new SearchRequest(input);
            }
        }
        catch (IOException e) {
            requestListener.onFailure((Exception)new SearchPipelineProcessingException(e));
            return;
        }
        Object currentListener = finalListener = this.getTerminalSearchRequestActionListener(requestListener);
        for (int i = this.searchRequestProcessors.size() - 1; i >= 0; --i) {
            ActionListener<SearchRequest> nextListener = currentListener;
            SearchRequestProcessor processor = this.searchRequestProcessors.get(i);
            currentListener = ActionListenerHelper.wrap(r -> {
                long start = this.relativeTimeSupplier.getAsLong();
                this.beforeRequestProcessor(processor);
                processor.processRequestAsync((SearchRequest)r, (ActionListener<SearchRequest>)ActionListenerHelper.wrap(rr -> {
                    long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - start);
                    this.afterRequestProcessor(processor, took);
                    nextListener.onResponse(rr);
                }, e -> {
                    long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - start);
                    this.afterRequestProcessor(processor, took);
                    this.onRequestProcessorFailed(processor);
                    if (processor.isIgnoreFailure()) {
                        logger.warn("The exception from request processor [" + processor.getType() + "] in the search pipeline [" + this.id + "] was ignored", (Throwable)e);
                        nextListener.onResponse(r);
                    } else {
                        nextListener.onFailure((Exception)new SearchPipelineProcessingException((Exception)e));
                    }
                }));
            }, arg_0 -> finalListener.onFailure(arg_0));
        }
        this.beforeTransformRequest();
        currentListener.onResponse((Object)request);
    }

    private ActionListener<SearchRequest> getTerminalSearchRequestActionListener(ActionListener<SearchRequest> requestListener) {
        long pipelineStart = this.relativeTimeSupplier.getAsLong();
        return ActionListenerHelper.wrap(r -> {
            long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - pipelineStart);
            this.afterTransformRequest(took);
            requestListener.onResponse((Object)new PipelinedRequest(this, (SearchRequest)r));
        }, e -> {
            long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - pipelineStart);
            this.afterTransformRequest(took);
            this.onTransformRequestFailure();
            requestListener.onFailure((Exception)new SearchPipelineProcessingException((Exception)e));
        });
    }

    ActionListener<SearchResponse> transformResponseListener(SearchRequest request, ActionListener<SearchResponse> responseListener) {
        if (this.searchResponseProcessors.isEmpty()) {
            return responseListener;
        }
        long[] pipelineStart = new long[1];
        ActionListener<SearchResponse> originalListener = responseListener;
        Object finalListener = responseListener = ActionListenerHelper.wrap(r -> {
            long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - pipelineStart[0]);
            this.afterTransformResponse(took);
            originalListener.onResponse(r);
        }, e -> {
            long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - pipelineStart[0]);
            this.afterTransformResponse(took);
            this.onTransformResponseFailure();
            originalListener.onFailure(e);
        });
        for (int i = this.searchResponseProcessors.size() - 1; i >= 0; --i) {
            Object currentFinalListener = responseListener;
            SearchResponseProcessor processor = this.searchResponseProcessors.get(i);
            responseListener = ActionListenerHelper.wrap(r -> {
                this.beforeResponseProcessor(processor);
                long start = this.relativeTimeSupplier.getAsLong();
                processor.processResponseAsync(request, (SearchResponse)r, (ActionListener<SearchResponse>)ActionListenerHelper.wrap(rr -> {
                    long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - start);
                    this.afterResponseProcessor(processor, took);
                    currentFinalListener.onResponse(rr);
                }, e -> {
                    this.onResponseProcessorFailed(processor);
                    long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - start);
                    this.afterResponseProcessor(processor, took);
                    if (processor.isIgnoreFailure()) {
                        logger.warn("The exception from response processor [" + processor.getType() + "] in the search pipeline [" + this.id + "] was ignored", (Throwable)e);
                        currentFinalListener.onResponse(r);
                    } else {
                        currentFinalListener.onFailure((Exception)new SearchPipelineProcessingException((Exception)e));
                    }
                }));
            }, arg_0 -> finalListener.onFailure(arg_0));
        }
        Object chainListener = responseListener;
        return ActionListenerHelper.wrap(r -> {
            this.beforeTransformResponse();
            pipelineStart[0] = this.relativeTimeSupplier.getAsLong();
            chainListener.onResponse(r);
        }, arg_0 -> originalListener.onFailure(arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    <Result extends SearchPhaseResult> void runSearchPhaseResultsTransformer(SearchPhaseResults<Result> searchPhaseResult, SearchPhaseContext context, String currentPhase, String nextPhase) throws SearchPipelineProcessingException {
        try {
            for (SearchPhaseResultsProcessor searchPhaseResultsProcessor : this.searchPhaseResultsProcessors) {
                if (!currentPhase.equals(searchPhaseResultsProcessor.getBeforePhase().getName()) || !nextPhase.equals(searchPhaseResultsProcessor.getAfterPhase().getName())) continue;
                try {
                    searchPhaseResultsProcessor.process(searchPhaseResult, context);
                }
                catch (Exception e) {
                    if (!searchPhaseResultsProcessor.isIgnoreFailure()) throw e;
                    logger.warn("The exception from search phase results processor [" + searchPhaseResultsProcessor.getType() + "] in the search pipeline [" + this.id + "] was ignored", (Throwable)e);
                    continue;
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            throw new SearchPipelineProcessingException(e);
        }
    }
}

