/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.pipeline;

import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteException;
import io.skylite.SkyliteParseException;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.search.DeleteSearchPipelineRequest;
import io.skylite.core.action.search.PutSearchPipelineRequest;
import io.skylite.core.analysis.AnalysisRegistry;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.AckedRequest;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.AckedClusterStateUpdateTask;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateApplier;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.metrics.OperationMetrics;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.plugins.SearchPipelinePlugin;
import io.skylite.core.script.ScriptService;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.pipeline.Pipeline;
import io.skylite.core.search.pipeline.PipelineConfiguration;
import io.skylite.core.search.pipeline.PipelineWithMetrics;
import io.skylite.core.search.pipeline.PipelinedRequest;
import io.skylite.core.search.pipeline.ProcessorInfo;
import io.skylite.core.search.pipeline.SearchPhaseResultsProcessor;
import io.skylite.core.search.pipeline.SearchPipelineInfo;
import io.skylite.core.search.pipeline.SearchPipelineMetadata;
import io.skylite.core.search.pipeline.SearchPipelineProcessingException;
import io.skylite.core.search.pipeline.SearchPipelineStats;
import io.skylite.core.search.pipeline.SearchProcessor;
import io.skylite.core.search.pipeline.SearchRequestProcessor;
import io.skylite.core.search.pipeline.SearchResponseProcessor;
import io.skylite.core.service.ReportingService;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SearchPipelineService
implements ClusterStateApplier,
ReportingService<SearchPipelineInfo> {
    public static final String SEARCH_PIPELINE_ORIGIN = "search_pipeline";
    public static final String AD_HOC_PIPELINE_ID = "_ad_hoc_pipeline";
    private static final Logger logger = LogManager.getLogger(SearchPipelineService.class);
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final Map<String, SearchProcessor.Factory<SearchRequestProcessor>> requestProcessorFactories;
    private final Map<String, SearchProcessor.Factory<SearchResponseProcessor>> responseProcessorFactories;
    private final Map<String, SearchProcessor.Factory<SearchPhaseResultsProcessor>> phaseInjectorProcessorFactories;
    private volatile Map<String, PipelineHolder> pipelines = Collections.emptyMap();
    private final ThreadPool threadPool;
    private final List<Consumer<ClusterState>> searchPipelineClusterStateListeners = new CopyOnWriteArrayList<Consumer<ClusterState>>();
    private final ClusterManagerTaskThrottler.ThrottlingKey putPipelineTaskKey;
    private final ClusterManagerTaskThrottler.ThrottlingKey deletePipelineTaskKey;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private volatile ClusterState state;
    private final OperationMetrics totalRequestProcessingMetrics = new OperationMetrics();
    private final OperationMetrics totalResponseProcessingMetrics = new OperationMetrics();

    public SearchPipelineService(ClusterService clusterService, ThreadPool threadPool, Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, NamedXContentRegistry namedXContentRegistry, NamedWriteableRegistry namedWriteableRegistry, List<SearchPipelinePlugin> searchPipelinePlugins, Client client) {
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.threadPool = threadPool;
        this.namedWriteableRegistry = namedWriteableRegistry;
        SearchPipelinePlugin.Parameters parameters = new SearchPipelinePlugin.Parameters(env, scriptService, analysisRegistry, threadPool.getThreadContext(), threadPool::relativeTimeInMillis, (delay, command) -> threadPool.schedule((Runnable)command, TimeValue.timeValueMillis((long)delay), "generic"), this, client, threadPool.generic()::execute, namedXContentRegistry);
        this.requestProcessorFactories = SearchPipelineService.processorFactories(searchPipelinePlugins, p -> p.getRequestProcessors(parameters));
        this.responseProcessorFactories = SearchPipelineService.processorFactories(searchPipelinePlugins, p -> p.getResponseProcessors(parameters));
        this.phaseInjectorProcessorFactories = SearchPipelineService.processorFactories(searchPipelinePlugins, p -> p.getSearchPhaseResultsProcessors(parameters));
        this.putPipelineTaskKey = clusterService.registerClusterManagerTask("put-search-pipeline", true);
        this.deletePipelineTaskKey = clusterService.registerClusterManagerTask("delete-search-pipeline", true);
    }

    private static <T extends SearchProcessor> Map<String, SearchProcessor.Factory<T>> processorFactories(List<SearchPipelinePlugin> searchPipelinePlugins, Function<SearchPipelinePlugin, Map<String, SearchProcessor.Factory<T>>> processorLoader) {
        HashMap<String, SearchProcessor.Factory<T>> processorFactories = new HashMap<String, SearchProcessor.Factory<T>>();
        for (SearchPipelinePlugin searchPipelinePlugin : searchPipelinePlugins) {
            Map<String, SearchProcessor.Factory<T>> newProcessors = processorLoader.apply(searchPipelinePlugin);
            for (Map.Entry<String, SearchProcessor.Factory<T>> entry : newProcessors.entrySet()) {
                if (processorFactories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Search processor [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(processorFactories);
    }

    @Override
    public void applyClusterState(ClusterStateChangedEvent event) {
        this.state = event.state();
        if (this.state.blocks().hasGlobalBlock(ClusterBlocks.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        this.searchPipelineClusterStateListeners.forEach(consumer -> consumer.accept(this.state));
        SearchPipelineMetadata newSearchPipelineMetadata = (SearchPipelineMetadata)this.state.getMetadata().custom(SEARCH_PIPELINE_ORIGIN);
        if (newSearchPipelineMetadata == null) {
            return;
        }
        try {
            this.innerUpdatePipelines(newSearchPipelineMetadata);
        }
        catch (SkyliteParseException e) {
            logger.warn("failed to update search pipelines", (Throwable)e);
        }
    }

    void innerUpdatePipelines(SearchPipelineMetadata newSearchPipelineMetadata) {
        Map<String, PipelineHolder> existingPipelines = this.pipelines;
        HashMap<String, PipelineHolder> newPipelines = null;
        ArrayList<SkyliteParseException> exceptions = null;
        for (PipelineConfiguration pipelineConfiguration : newSearchPipelineMetadata.getPipelines().values()) {
            PipelineHolder previous = existingPipelines.get(pipelineConfiguration.getId());
            if (previous != null && previous.configuration.equals(pipelineConfiguration)) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            try {
                PipelineWithMetrics newPipeline = PipelineWithMetrics.create(pipelineConfiguration.getId(), pipelineConfiguration.getConfigAsMap(), this.requestProcessorFactories, this.responseProcessorFactories, this.phaseInjectorProcessorFactories, this.namedWriteableRegistry, this.totalRequestProcessingMetrics, this.totalResponseProcessingMetrics, new SearchProcessor.PipelineContext(SearchProcessor.PipelineSource.UPDATE_PIPELINE));
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, newPipeline));
                if (previous == null) continue;
                newPipeline.copyMetrics(previous.pipeline);
            }
            catch (Exception e) {
                SkyliteParseException parseException = new SkyliteParseException("Error updating pipeline with id [" + pipelineConfiguration.getId() + "]", (Throwable)e, new Object[0]);
                if (exceptions == null) {
                    exceptions = new ArrayList<SkyliteParseException>();
                }
                exceptions.add(parseException);
            }
        }
        for (Map.Entry entry : existingPipelines.entrySet()) {
            if (newSearchPipelineMetadata.getPipelines().get(entry.getKey()) != null) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            newPipelines.remove(entry.getKey());
        }
        if (newPipelines != null) {
            this.pipelines = Collections.unmodifiableMap(newPipelines);
            if (exceptions != null) {
                ExceptionsHelper.rethrowAndSuppress(exceptions);
            }
        }
    }

    public void putPipeline(Map<DiscoveryNode, SearchPipelineInfo> searchPipelineInfos, final PutSearchPipelineRequest request, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.validatePipeline(searchPipelineInfos, request);
        this.clusterService.submitStateUpdateTask("put-search-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            @Override
            public ClusterState execute(ClusterState currentState) {
                return SearchPipelineService.innerPut(request, currentState);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return SearchPipelineService.this.putPipelineTaskKey;
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }
        });
    }

    static ClusterState innerPut(PutSearchPipelineRequest request, ClusterState currentState) {
        SearchPipelineMetadata currentSearchPipelineMetadata = (SearchPipelineMetadata)currentState.metadata().custom(SEARCH_PIPELINE_ORIGIN);
        HashMap<String, PipelineConfiguration> pipelines = currentSearchPipelineMetadata != null ? new HashMap<String, PipelineConfiguration>(currentSearchPipelineMetadata.getPipelines()) : new HashMap<String, PipelineConfiguration>();
        pipelines.put(request.getId(), new PipelineConfiguration(request.getId(), request.getSource(), request.getMediaType()));
        ClusterState.Builder newState = ClusterState.builder(currentState);
        newState.metadata(Metadata.builder(currentState.getMetadata()).putCustom(SEARCH_PIPELINE_ORIGIN, new SearchPipelineMetadata(pipelines)).build());
        return newState.build();
    }

    void validatePipeline(Map<DiscoveryNode, SearchPipelineInfo> searchPipelineInfos, PutSearchPipelineRequest request) throws Exception {
        String message;
        String type;
        if (searchPipelineInfos.isEmpty()) {
            throw new IllegalStateException("Search pipeline info is empty");
        }
        Map pipelineConfig = (Map)XContentHelper.convertToMap(request.getSource(), false, request.getMediaType()).v2();
        PipelineWithMetrics pipeline = PipelineWithMetrics.create(request.getId(), pipelineConfig, this.requestProcessorFactories, this.responseProcessorFactories, this.phaseInjectorProcessorFactories, this.namedWriteableRegistry, new OperationMetrics(), new OperationMetrics(), new SearchProcessor.PipelineContext(SearchProcessor.PipelineSource.VALIDATE_PIPELINE));
        ArrayList<SkyliteException> exceptions = new ArrayList<SkyliteException>();
        for (SearchRequestProcessor searchRequestProcessor : pipeline.getSearchRequestProcessors()) {
            for (Map.Entry<DiscoveryNode, SearchPipelineInfo> entry : searchPipelineInfos.entrySet()) {
                type = searchRequestProcessor.getType();
                if (entry.getValue().containsProcessor("request_processors", type)) continue;
                message = "Processor type [" + searchRequestProcessor.getType() + "] is not installed on node [" + String.valueOf(entry.getKey()) + "]";
                exceptions.add(ConfigurationUtils.newConfigurationException(searchRequestProcessor.getType(), searchRequestProcessor.getTag(), null, message));
            }
        }
        for (SearchResponseProcessor searchResponseProcessor : pipeline.getSearchResponseProcessors()) {
            for (Map.Entry<DiscoveryNode, SearchPipelineInfo> entry : searchPipelineInfos.entrySet()) {
                type = searchResponseProcessor.getType();
                if (entry.getValue().containsProcessor("response_processors", type)) continue;
                message = "Processor type [" + searchResponseProcessor.getType() + "] is not installed on node [" + String.valueOf(entry.getKey()) + "]";
                exceptions.add(ConfigurationUtils.newConfigurationException(searchResponseProcessor.getType(), searchResponseProcessor.getTag(), null, message));
            }
        }
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }

    public void deletePipeline(final DeleteSearchPipelineRequest request, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("delete-search-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            @Override
            public ClusterState execute(ClusterState currentState) {
                return SearchPipelineService.innerDelete(request, currentState);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return SearchPipelineService.this.deletePipelineTaskKey;
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }
        });
    }

    static ClusterState innerDelete(DeleteSearchPipelineRequest request, ClusterState currentState) {
        SearchPipelineMetadata currentMetadata = (SearchPipelineMetadata)currentState.metadata().custom(SEARCH_PIPELINE_ORIGIN);
        if (currentMetadata == null) {
            return currentState;
        }
        Map<String, PipelineConfiguration> pipelines = currentMetadata.getPipelines();
        HashSet<String> toRemove = new HashSet<String>();
        for (String string : pipelines.keySet()) {
            if (!Regex.simpleMatch(request.getId(), string)) continue;
            toRemove.add(string);
        }
        if (toRemove.isEmpty()) {
            if (Regex.isMatchAllPattern(request.getId())) {
                return currentState;
            }
            throw new ResourceNotFoundException("pipeline [{}] is missing", request.getId());
        }
        HashMap<String, PipelineConfiguration> newPipelines = new HashMap<String, PipelineConfiguration>(pipelines);
        for (String key : toRemove) {
            newPipelines.remove(key);
        }
        ClusterState.Builder builder = ClusterState.builder(currentState);
        builder.metadata(Metadata.builder(currentState.getMetadata()).putCustom(SEARCH_PIPELINE_ORIGIN, new SearchPipelineMetadata(newPipelines)));
        return builder.build();
    }

    public PipelinedRequest resolvePipeline(SearchRequest searchRequest) {
        Pipeline pipeline = Pipeline.NO_OP_PIPELINE;
        if (searchRequest.source() != null && searchRequest.source().searchPipelineSource() != null) {
            if (searchRequest.pipeline() != null) {
                throw new IllegalArgumentException("Both named and inline search pipeline were specified. Please only specify one or the other.");
            }
            try {
                pipeline = PipelineWithMetrics.create(AD_HOC_PIPELINE_ID, searchRequest.source().searchPipelineSource(), this.requestProcessorFactories, this.responseProcessorFactories, this.phaseInjectorProcessorFactories, this.namedWriteableRegistry, this.totalRequestProcessingMetrics, this.totalResponseProcessingMetrics, new SearchProcessor.PipelineContext(SearchProcessor.PipelineSource.SEARCH_REQUEST));
            }
            catch (Exception e) {
                throw new SearchPipelineProcessingException(e);
            }
        } else {
            Settings indexSettings;
            IndexMetadata indexMetadata;
            String pipelineId = "_none";
            if (searchRequest.pipeline() != null) {
                pipelineId = searchRequest.pipeline();
            } else if (this.state != null && searchRequest.indices() != null && searchRequest.indices().length == 1 && (indexMetadata = this.state.metadata().index(searchRequest.indices()[0])) != null && IndexSettings.DEFAULT_SEARCH_PIPELINE.exists(indexSettings = indexMetadata.getSettings())) {
                pipelineId = IndexSettings.DEFAULT_SEARCH_PIPELINE.get(indexSettings);
            }
            if (!"_none".equals(pipelineId)) {
                PipelineHolder pipelineHolder = this.pipelines.get(pipelineId);
                if (pipelineHolder == null) {
                    throw new IllegalArgumentException("Pipeline " + pipelineId + " is not defined");
                }
                pipeline = pipelineHolder.pipeline;
            }
        }
        return new PipelinedRequest(pipeline, searchRequest);
    }

    Map<String, SearchProcessor.Factory<SearchRequestProcessor>> getRequestProcessorFactories() {
        return this.requestProcessorFactories;
    }

    Map<String, SearchProcessor.Factory<SearchResponseProcessor>> getResponseProcessorFactories() {
        return this.responseProcessorFactories;
    }

    @Override
    public SearchPipelineInfo info() {
        List requestProcessorInfoList = this.requestProcessorFactories.keySet().stream().map(ProcessorInfo::new).collect(Collectors.toList());
        List responseProcessorInfoList = this.responseProcessorFactories.keySet().stream().map(ProcessorInfo::new).collect(Collectors.toList());
        return new SearchPipelineInfo(Map.of("request_processors", requestProcessorInfoList, "response_processors", responseProcessorInfoList));
    }

    public SearchPipelineStats stats() {
        SearchPipelineStats.Builder builder = new SearchPipelineStats.Builder();
        builder.withTotalStats(this.totalRequestProcessingMetrics, this.totalResponseProcessingMetrics);
        for (PipelineHolder pipelineHolder : this.pipelines.values()) {
            PipelineWithMetrics pipeline = pipelineHolder.pipeline;
            pipeline.populateStats(builder);
        }
        return builder.build();
    }

    public static List<PipelineConfiguration> getPipelines(ClusterState clusterState, String ... ids) {
        SearchPipelineMetadata metadata = (SearchPipelineMetadata)clusterState.getMetadata().custom(SEARCH_PIPELINE_ORIGIN);
        return SearchPipelineService.innerGetPipelines(metadata, ids);
    }

    static List<PipelineConfiguration> innerGetPipelines(SearchPipelineMetadata metadata, String ... ids) {
        if (metadata == null) {
            return Collections.emptyList();
        }
        if (ids.length == 0) {
            return new ArrayList<PipelineConfiguration>(metadata.getPipelines().values());
        }
        ArrayList<PipelineConfiguration> result = new ArrayList<PipelineConfiguration>(ids.length);
        for (String id : ids) {
            if (Regex.isSimpleMatchPattern(id)) {
                for (Map.Entry<String, PipelineConfiguration> entry : metadata.getPipelines().entrySet()) {
                    if (!Regex.simpleMatch(id, entry.getKey())) continue;
                    result.add(entry.getValue());
                }
                continue;
            }
            PipelineConfiguration pipeline = metadata.getPipelines().get(id);
            if (pipeline == null) continue;
            result.add(pipeline);
        }
        return result;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    Map<String, PipelineHolder> getPipelines() {
        return this.pipelines;
    }

    static class PipelineHolder {
        final PipelineConfiguration configuration;
        final PipelineWithMetrics pipeline;

        PipelineHolder(PipelineConfiguration configuration, PipelineWithMetrics pipeline) {
            this.configuration = Objects.requireNonNull(configuration);
            this.pipeline = Objects.requireNonNull(pipeline);
        }
    }
}

