/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.profile.aggregation;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.profile.ProfileResult;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AggregationProfileShardResult
implements Writeable,
ToXContentFragment {
    public static final String AGGREGATIONS = "aggregations";
    private final List<ProfileResult> aggProfileResults;

    public AggregationProfileShardResult(List<ProfileResult> aggProfileResults) {
        this.aggProfileResults = aggProfileResults;
    }

    public AggregationProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        this.aggProfileResults = new ArrayList<ProfileResult>(profileSize);
        for (int j = 0; j < profileSize; ++j) {
            this.aggProfileResults.add(new ProfileResult(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.aggProfileResults.size());
        for (ProfileResult p : this.aggProfileResults) {
            p.writeTo(out);
        }
    }

    public List<ProfileResult> getProfileResults() {
        return Collections.unmodifiableList(this.aggProfileResults);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(AGGREGATIONS);
        for (ProfileResult p : this.aggProfileResults) {
            p.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static AggregationProfileShardResult fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser);
        ArrayList<ProfileResult> aggProfileResults = new ArrayList<ProfileResult>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            aggProfileResults.add(ProfileResult.fromXContent(parser));
        }
        return new AggregationProfileShardResult(aggProfileResults);
    }
}

