/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.profile.aggregation;

import io.skylite.common.profile.Timer;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.profile.AggregationTimingType;
import io.skylite.core.aggregations.support.AggregationPath;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.profile.aggregation.AggregationProfileBreakdown;
import io.skylite.core.search.profile.aggregation.AggregationProfiler;
import io.skylite.core.search.profile.aggregation.ProfilingLeafBucketCollector;
import io.skylite.core.search.sort.SortOrder;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;

public class ProfilingAggregator
extends Aggregator {
    private final Aggregator delegate;
    private final AggregationProfiler profiler;
    private AggregationProfileBreakdown profileBreakdown;

    public ProfilingAggregator(Aggregator delegate, AggregationProfiler profiler) throws IOException {
        this.profiler = profiler;
        this.delegate = delegate;
    }

    public void close() {
        this.delegate.close();
    }

    public ScoreMode scoreMode() {
        return this.delegate.scoreMode();
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public SearchExecutionContext context() {
        return this.delegate.context();
    }

    @Override
    public Aggregator parent() {
        return this.delegate.parent();
    }

    @Override
    public Aggregator subAggregator(String name) {
        return this.delegate.subAggregator(name);
    }

    @Override
    public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        return this.delegate.resolveSortPath(next, path);
    }

    @Override
    public BucketOrder.BucketComparator bucketComparator(String key, SortOrder order) {
        return this.delegate.bucketComparator(key, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.BUILD_AGGREGATION);
        timer.start();
        try {
            InternalAggregation[] internalAggregationArray = this.delegate.buildAggregations(owningBucketOrds);
            return internalAggregationArray;
        }
        finally {
            timer.stop();
            this.delegate.collectDebugInfo(this.profileBreakdown::addDebugInfo);
        }
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.delegate.buildEmptyAggregation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.BUILD_LEAF_COLLECTOR);
        timer.start();
        try {
            ProfilingLeafBucketCollector profilingLeafBucketCollector = new ProfilingLeafBucketCollector(this.delegate.getLeafCollector(ctx), this.profileBreakdown);
            return profilingLeafBucketCollector;
        }
        finally {
            timer.stop();
        }
    }

    @Override
    public void preCollection() throws IOException {
        this.profileBreakdown = this.profiler.getQueryBreakdown(this.delegate);
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.INITIALIZE);
        timer.start();
        try {
            this.delegate.preCollection();
        }
        finally {
            timer.stop();
        }
        this.profiler.pollLastElement();
    }

    @Override
    public void postCollection() throws IOException {
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.POST_COLLECTION);
        timer.start();
        try {
            this.delegate.postCollection();
        }
        finally {
            timer.stop();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Aggregator unwrap() {
        return this.delegate.unwrap();
    }

    public static Aggregator unwrap(Aggregator agg) {
        if (agg instanceof ProfilingAggregator) {
            return ((ProfilingAggregator)agg).delegate;
        }
        return agg;
    }
}

