/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.query;

import io.skylite.core.lucene.search.FilteredCollector;
import io.skylite.core.search.query.ReduceableSearchResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Weight;

class FilteredCollectorManager
implements CollectorManager<FilteredCollector, ReduceableSearchResult> {
    private final CollectorManager<? extends Collector, ReduceableSearchResult> manager;
    private final Weight filter;

    FilteredCollectorManager(CollectorManager<? extends Collector, ReduceableSearchResult> manager, Weight filter) {
        this.manager = manager;
        this.filter = filter;
    }

    public FilteredCollector newCollector() throws IOException {
        return new FilteredCollector(this.manager.newCollector(), this.filter);
    }

    public ReduceableSearchResult reduce(Collection<FilteredCollector> collectors) throws IOException {
        ArrayList<Collector> subCollectors = new ArrayList<Collector>();
        for (FilteredCollector collector : collectors) {
            subCollectors.add(collector.getCollector());
        }
        return (ReduceableSearchResult)this.manager.reduce(subCollectors);
    }
}

