/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.query;

import io.skylite.core.FeatureFlags;
import io.skylite.core.aggregations.AggregationProcessor;
import io.skylite.core.search.internal.ContextIndexSearcher;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.query.ConcurrentQueryPhaseSearcher;
import io.skylite.core.search.query.QueryCollectorContext;
import io.skylite.core.search.query.QueryPhase;
import io.skylite.core.search.query.QueryPhaseSearcher;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;

public class QueryPhaseSearcherWrapper
implements QueryPhaseSearcher {
    private static final Logger LOGGER = LogManager.getLogger(QueryPhaseSearcherWrapper.class);
    private final QueryPhaseSearcher defaultQueryPhaseSearcher = new QueryPhase.DefaultQueryPhaseSearcher();
    private final QueryPhaseSearcher concurrentQueryPhaseSearcher = FeatureFlags.isEnabled("lucenia.experimental.feature.concurrent_segment_search.enabled") ? new ConcurrentQueryPhaseSearcher() : null;

    @Override
    public boolean searchWith(SearchExecutionContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, boolean hasFilterCollector, boolean hasTimeout) throws IOException {
        if (searchContext.shouldUseConcurrentSearch()) {
            LOGGER.debug("Using concurrent search over segments (experimental) for request with context id {}", (Object)searchContext.id());
            return this.concurrentQueryPhaseSearcher.searchWith(searchContext, searcher, query, collectors, hasFilterCollector, hasTimeout);
        }
        LOGGER.debug("Using non-concurrent search over segments for request with context id {}", (Object)searchContext.id());
        return this.defaultQueryPhaseSearcher.searchWith(searchContext, searcher, query, collectors, hasFilterCollector, hasTimeout);
    }

    @Override
    public AggregationProcessor aggregationProcessor(SearchExecutionContext searchContext) {
        if (searchContext.shouldUseConcurrentSearch()) {
            LOGGER.debug("Using concurrent aggregation processor over segments (experimental) for request with context id {}", (Object)searchContext.id());
            return this.concurrentQueryPhaseSearcher.aggregationProcessor(searchContext);
        }
        LOGGER.debug("Using non-concurrent aggregation processor over segments for request with context id {}", (Object)searchContext.id());
        return this.defaultQueryPhaseSearcher.aggregationProcessor(searchContext);
    }
}

