/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.rescore;

import io.skylite.core.search.rescore.QueryRescoreMode;
import io.skylite.core.search.rescore.RescoreContext;
import io.skylite.core.search.rescore.Rescorer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public final class QueryRescorer
implements Rescorer {
    public static final Rescorer INSTANCE = new QueryRescorer();
    private static final Comparator<ScoreDoc> SCORE_DOC_COMPARATOR = new Comparator<ScoreDoc>(){

        @Override
        public int compare(ScoreDoc o1, ScoreDoc o2) {
            int cmp = Float.compare(o2.score, o1.score);
            return cmp == 0 ? Integer.compare(o1.doc, o2.doc) : cmp;
        }
    };

    @Override
    public TopDocs rescore(TopDocs topDocs, IndexSearcher searcher, RescoreContext rescoreContext) throws IOException {
        assert (rescoreContext != null);
        if (topDocs == null || topDocs.scoreDocs.length == 0) {
            return topDocs;
        }
        final QueryRescoreContext rescore = (QueryRescoreContext)rescoreContext;
        org.apache.lucene.search.QueryRescorer rescorer = new org.apache.lucene.search.QueryRescorer(this, rescore.query()){

            protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                if (secondPassMatches) {
                    return rescore.scoreMode.combine(firstPassScore * rescore.queryWeight(), secondPassScore * rescore.rescoreQueryWeight());
                }
                return firstPassScore * rescore.queryWeight();
            }
        };
        TopDocs topNFirstPass = this.topN(topDocs, rescoreContext.getWindowSize());
        Set<Integer> topNDocIDs = Collections.unmodifiableSet(Arrays.stream(topNFirstPass.scoreDocs).map(scoreDoc -> scoreDoc.doc).collect(Collectors.toSet()));
        rescoreContext.setRescoredDocs(topNDocIDs);
        TopDocs rescored = rescorer.rescore(searcher, topNFirstPass, rescoreContext.getWindowSize());
        return this.combine(topDocs, rescored, (QueryRescoreContext)rescoreContext);
    }

    @Override
    public Explanation explain(int topLevelDocId, IndexSearcher searcher, RescoreContext rescoreContext, Explanation sourceExplanation) throws IOException {
        Explanation rescoreExplain;
        if (sourceExplanation == null) {
            return Explanation.noMatch((String)"nothing matched", (Explanation[])new Explanation[0]);
        }
        QueryRescoreContext rescore = (QueryRescoreContext)rescoreContext;
        float primaryWeight = rescore.queryWeight();
        Explanation prim = sourceExplanation.isMatch() ? Explanation.match((Number)Float.valueOf(sourceExplanation.getValue().floatValue() * primaryWeight), (String)"product of:", (Explanation[])new Explanation[]{sourceExplanation, Explanation.match((Number)Float.valueOf(primaryWeight), (String)"primaryWeight", (Explanation[])new Explanation[0])}) : Explanation.noMatch((String)"First pass did not match", (Explanation[])new Explanation[]{sourceExplanation});
        if (rescoreContext.isRescored(topLevelDocId) && (rescoreExplain = searcher.explain(rescore.query(), topLevelDocId)) != null && rescoreExplain.isMatch()) {
            float secondaryWeight = rescore.rescoreQueryWeight();
            Explanation sec = Explanation.match((Number)Float.valueOf(rescoreExplain.getValue().floatValue() * secondaryWeight), (String)"product of:", (Explanation[])new Explanation[]{rescoreExplain, Explanation.match((Number)Float.valueOf(secondaryWeight), (String)"secondaryWeight", (Explanation[])new Explanation[0])});
            QueryRescoreMode scoreMode = rescore.scoreMode();
            return Explanation.match((Number)Float.valueOf(scoreMode.combine(prim.getValue().floatValue(), sec.getValue().floatValue())), (String)(String.valueOf(scoreMode) + " of:"), (Explanation[])new Explanation[]{prim, sec});
        }
        return prim;
    }

    private TopDocs topN(TopDocs in, int topN) {
        if (in.scoreDocs.length < topN) {
            return in;
        }
        ScoreDoc[] subset = new ScoreDoc[topN];
        System.arraycopy(in.scoreDocs, 0, subset, 0, topN);
        return new TopDocs(in.totalHits, subset);
    }

    private TopDocs combine(TopDocs in, TopDocs resorted, QueryRescoreContext ctx) {
        System.arraycopy(resorted.scoreDocs, 0, in.scoreDocs, 0, resorted.scoreDocs.length);
        if (in.scoreDocs.length > resorted.scoreDocs.length) {
            for (int i = resorted.scoreDocs.length; i < in.scoreDocs.length; ++i) {
                in.scoreDocs[i].score *= ctx.queryWeight();
            }
            Arrays.sort(in.scoreDocs, SCORE_DOC_COMPARATOR);
        }
        return in;
    }

    public static class QueryRescoreContext
    extends RescoreContext {
        private Query query;
        private float queryWeight = 1.0f;
        private float rescoreQueryWeight = 1.0f;
        private QueryRescoreMode scoreMode = QueryRescoreMode.Total;

        public QueryRescoreContext(int windowSize) {
            super(windowSize, INSTANCE);
        }

        public void setQuery(Query query) {
            this.query = query;
        }

        @Override
        public List<Query> getQueries() {
            return Collections.singletonList(this.query);
        }

        public Query query() {
            return this.query;
        }

        public float queryWeight() {
            return this.queryWeight;
        }

        public float rescoreQueryWeight() {
            return this.rescoreQueryWeight;
        }

        public QueryRescoreMode scoreMode() {
            return this.scoreMode;
        }

        public void setRescoreQueryWeight(float rescoreQueryWeight) {
            this.rescoreQueryWeight = rescoreQueryWeight;
        }

        public void setQueryWeight(float queryWeight) {
            this.queryWeight = queryWeight;
        }

        public void setScoreMode(QueryRescoreMode scoreMode) {
            this.scoreMode = scoreMode;
        }

        public void setScoreMode(String scoreMode) {
            this.setScoreMode(QueryRescoreMode.fromString(scoreMode));
        }
    }
}

