/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.sort;

import io.skylite.core.ParseField;
import io.skylite.core.common.Strings;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.index.query.Rewriteable;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.FieldSortBuilder;
import io.skylite.core.search.sort.NestedSortBuilder;
import io.skylite.core.search.sort.ScoreSortBuilder;
import io.skylite.core.search.sort.SortAndFormats;
import io.skylite.core.search.sort.SortFieldAndFormat;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedObjectNotFoundException;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;

public abstract class SortBuilder<T extends SortBuilder<T>>
extends BaseSortBuilder
implements ToXContentObject,
Rewriteable<SortBuilder<?>> {
    protected SortOrder order = SortOrder.ASC;
    public static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    public static final ParseField NESTED_PATH_FIELD = new ParseField("nested_path", new String[0]);

    protected abstract SortFieldAndFormat build(QueryShardContext var1) throws IOException;

    protected SortFieldAndFormat build(QueryRewriteContext context) throws IOException {
        return this.build(QueryShardContext.convertFromQueryRewriteContext(context));
    }

    public abstract BucketedSort buildBucketedSort(QueryShardContext var1, int var2, BucketedSort.ExtraData var3) throws IOException;

    public T order(SortOrder order) {
        Objects.requireNonNull(order, "sort order cannot be null.");
        this.order = order;
        return (T)this;
    }

    @Override
    public SortOrder order() {
        return this.order;
    }

    public static List<? extends BaseSortBuilder> fromXContent(XContentParser parser) throws IOException {
        ArrayList<BaseSortBuilder> sortFields = new ArrayList<BaseSortBuilder>(2);
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.START_OBJECT) {
                    SortBuilder.parseCompoundSortField(parser, sortFields);
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    String fieldName = parser.text();
                    sortFields.add(SortBuilder.fieldOrScoreSort(fieldName));
                    continue;
                }
                throw new IllegalArgumentException("malformed sort format, within the sort array, an object, or an actual string are allowed");
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            String fieldName = parser.text();
            sortFields.add(SortBuilder.fieldOrScoreSort(fieldName));
        } else if (token == XContentParser.Token.START_OBJECT) {
            SortBuilder.parseCompoundSortField(parser, sortFields);
        } else {
            throw new IllegalArgumentException("malformed sort format, either start with array, object, or an actual string");
        }
        return sortFields;
    }

    private static SortBuilder<?> fieldOrScoreSort(String fieldName) {
        if (fieldName.equals("_score")) {
            return new ScoreSortBuilder();
        }
        return new FieldSortBuilder(fieldName);
    }

    private static void parseCompoundSortField(XContentParser parser, List<BaseSortBuilder> sortFields) throws IOException {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String fieldName = parser.currentName();
            token = parser.nextToken();
            if (token == XContentParser.Token.VALUE_STRING) {
                SortOrder order = SortOrder.fromString(parser.text());
                sortFields.add((BaseSortBuilder)SortBuilder.fieldOrScoreSort(fieldName).order(order));
                continue;
            }
            try {
                SortBuilder sort = (SortBuilder)parser.namedObject(BaseSortBuilder.class, fieldName, null);
                sortFields.add(sort);
            }
            catch (NamedObjectNotFoundException err) {
                sortFields.add(FieldSortBuilder.fromXContent(parser, fieldName));
            }
        }
    }

    public static Optional<SortAndFormats> buildSort(List<? extends BaseSortBuilder> sortBuilders, QueryShardContext context) throws IOException {
        SortField sortField;
        boolean sort;
        ArrayList<SortField> sortFields = new ArrayList<SortField>(sortBuilders.size());
        ArrayList<DocValueFormat> sortFormats = new ArrayList<DocValueFormat>(sortBuilders.size());
        for (BaseSortBuilder baseSortBuilder : sortBuilders) {
            SortFieldAndFormat sf = ((SortBuilder)baseSortBuilder).build(context);
            sortFields.add(sf.field);
            sortFormats.add(sf.format);
        }
        if (!sortFields.isEmpty() && (sort = sortFields.size() > 1 ? true : (sortField = (SortField)sortFields.get(0)).getType() != SortField.Type.SCORE || sortField.getReverse())) {
            return Optional.of(new SortAndFormats(new Sort(sortFields.toArray(new SortField[0])), sortFormats.toArray(new DocValueFormat[0])));
        }
        return Optional.empty();
    }

    protected static IndexFieldDataFieldComparatorSource.Nested resolveNested(QueryShardContext context, String nestedPath, QueryBuilder nestedFilter) throws IOException {
        NestedSortBuilder nestedSortBuilder = new NestedSortBuilder(nestedPath);
        nestedSortBuilder.setFilter(nestedFilter);
        return SortBuilder.resolveNested(context, nestedSortBuilder);
    }

    protected static IndexFieldDataFieldComparatorSource.Nested resolveNested(QueryShardContext context, NestedSortBuilder nestedSort) throws IOException {
        Query childQuery = SortBuilder.resolveNestedQuery(context, nestedSort, null);
        if (childQuery == null) {
            return null;
        }
        NestedObjectMapper objectMapper = context.nestedScope().getObjectMapper();
        Query parentQuery = objectMapper == null ? Queries.newNonNestedFilter() : objectMapper.nestedTypeFilter();
        return new IndexFieldDataFieldComparatorSource.Nested(context.bitsetFilter(parentQuery), childQuery, nestedSort, context.searcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Query resolveNestedQuery(QueryShardContext context, NestedSortBuilder nestedSort, Query parentQuery) throws IOException {
        Object childQuery;
        if (nestedSort == null || nestedSort.getPath() == null) {
            return null;
        }
        String nestedPath = nestedSort.getPath();
        QueryBuilder nestedFilter = nestedSort.getFilter();
        NestedSortBuilder nestedNestedSort = nestedSort.getNestedSort();
        ObjectMapper objectMapper = context.getObjectMapper(nestedPath);
        if (objectMapper == null) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "[nested] failed to find nested object under path [" + nestedPath + "]", new Object[0]);
        }
        if (!objectMapper.isNested()) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "[nested] nested object under path [" + nestedPath + "] is not of nested type", new Object[0]);
        }
        NestedObjectMapper nestedObjectMapper = (NestedObjectMapper)objectMapper;
        NestedObjectMapper parentMapper = context.nestedScope().getObjectMapper();
        try {
            context.nestedScope().nextLevel(nestedObjectMapper);
            if (nestedFilter != null) {
                assert (nestedFilter == Rewriteable.rewrite(nestedFilter, (QueryRewriteContext)context)) : "nested filter is not rewritten";
                childQuery = parentQuery == null ? nestedFilter.toQuery(context) : Queries.filtered(nestedObjectMapper.nestedTypeFilter(), nestedFilter.toQuery(context));
            } else {
                childQuery = nestedObjectMapper.nestedTypeFilter();
            }
        }
        finally {
            context.nestedScope().previousLevel();
        }
        if (parentQuery != null && parentMapper != null) {
            childQuery = Queries.filtered(childQuery, (Query)new ToChildBlockJoinQuery(parentQuery, context.bitsetFilter(parentMapper.nestedTypeFilter())));
        }
        if (nestedNestedSort != null) {
            try {
                context.nestedScope().nextLevel(nestedObjectMapper);
                Query query = SortBuilder.resolveNestedQuery(context, nestedNestedSort, childQuery);
                return query;
            }
            finally {
                context.nestedScope().previousLevel();
            }
        }
        return childQuery;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }
}

