/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.suggest.completion;

import io.skylite.core.common.unit.Fuzziness;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.CompletionFieldMapper;
import io.skylite.core.search.suggest.SuggestionSearchContext;
import io.skylite.core.search.suggest.completion.CompletionSuggester;
import io.skylite.core.search.suggest.completion.FuzzyOptions;
import io.skylite.core.search.suggest.completion.RegexOptions;
import io.skylite.core.search.suggest.completion.context.ContextMapping;
import io.skylite.core.search.suggest.completion.context.ContextMappings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.util.BytesRef;

public class CompletionSuggestionContext
extends SuggestionSearchContext.SuggestionContext {
    private CompletionFieldMapper.CompletionFieldType fieldType;
    private FuzzyOptions fuzzyOptions;
    private RegexOptions regexOptions;
    private boolean skipDuplicates;
    private Map<String, List<ContextMapping.InternalQueryContext>> queryContexts = Collections.emptyMap();

    protected CompletionSuggestionContext(QueryShardContext shardContext) {
        super(CompletionSuggester.INSTANCE, shardContext);
    }

    CompletionFieldMapper.CompletionFieldType getFieldType() {
        return this.fieldType;
    }

    void setFieldType(CompletionFieldMapper.CompletionFieldType fieldType) {
        this.fieldType = fieldType;
    }

    void setRegexOptions(RegexOptions regexOptions) {
        this.regexOptions = regexOptions;
    }

    void setFuzzyOptions(FuzzyOptions fuzzyOptions) {
        this.fuzzyOptions = fuzzyOptions;
    }

    void setQueryContexts(Map<String, List<ContextMapping.InternalQueryContext>> queryContexts) {
        this.queryContexts = queryContexts;
    }

    void setSkipDuplicates(boolean skipDuplicates) {
        this.skipDuplicates = skipDuplicates;
    }

    public FuzzyOptions getFuzzyOptions() {
        return this.fuzzyOptions;
    }

    public RegexOptions getRegexOptions() {
        return this.regexOptions;
    }

    public Map<String, List<ContextMapping.InternalQueryContext>> getQueryContexts() {
        return this.queryContexts;
    }

    public boolean isSkipDuplicates() {
        return this.skipDuplicates;
    }

    CompletionQuery toQuery() {
        CompletionQuery query;
        CompletionFieldMapper.CompletionFieldType fieldType = this.getFieldType();
        if (this.getPrefix() != null) {
            query = this.createCompletionQuery(this.getPrefix(), fieldType);
        } else if (this.getRegex() != null) {
            if (this.fuzzyOptions != null) {
                throw new IllegalArgumentException("can not use 'fuzzy' options with 'regex");
            }
            if (this.regexOptions == null) {
                this.regexOptions = RegexOptions.builder().build();
            }
            query = fieldType.regexpQuery(this.getRegex(), this.regexOptions.getFlagsValue(), this.regexOptions.getMaxDeterminizedStates());
        } else if (this.getText() != null) {
            query = this.createCompletionQuery(this.getText(), fieldType);
        } else {
            throw new IllegalArgumentException("'prefix/text' or 'regex' must be defined");
        }
        if (fieldType.hasContextMappings()) {
            ContextMappings contextMappings = fieldType.getContextMappings();
            return contextMappings.toContextQuery(query, this.queryContexts);
        }
        return query;
    }

    private CompletionQuery createCompletionQuery(BytesRef prefix, CompletionFieldMapper.CompletionFieldType fieldType) {
        CompletionQuery query = this.fuzzyOptions != null ? fieldType.fuzzyQuery(prefix.utf8ToString(), Fuzziness.fromEdits(this.fuzzyOptions.getEditDistance()), this.fuzzyOptions.getFuzzyPrefixLength(), this.fuzzyOptions.getFuzzyMinLength(), this.fuzzyOptions.getMaxDeterminizedStates(), this.fuzzyOptions.isTranspositions(), this.fuzzyOptions.isUnicodeAware()) : fieldType.prefixQuery(prefix);
        return query;
    }
}

