/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.suggest.phrase;

import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.search.suggest.phrase.Laplace;
import io.skylite.core.search.suggest.phrase.LinearInterpolation;
import io.skylite.core.search.suggest.phrase.StupidBackoff;
import io.skylite.core.search.suggest.phrase.WordScorer;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;

public abstract class SmoothingModel
implements NamedWriteable,
ToXContentFragment {
    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getWriteableName());
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SmoothingModel other = (SmoothingModel)obj;
        return this.doEquals(other);
    }

    public final int hashCode() {
        return this.doHashCode();
    }

    protected abstract int doHashCode();

    public static SmoothingModel fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        SmoothingModel model = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (LinearInterpolation.PARSE_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                    model = LinearInterpolation.fromXContent(parser);
                    continue;
                }
                if (Laplace.PARSE_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                    model = Laplace.fromXContent(parser);
                    continue;
                }
                if (StupidBackoff.PARSE_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                    model = StupidBackoff.fromXContent(parser);
                    continue;
                }
                throw new IllegalArgumentException("suggester[phrase] doesn't support object field [" + fieldName + "]");
            }
            throw new ParsingException(parser.getTokenLocation(), "[smoothing] unknown token [" + String.valueOf((Object)token) + "] after [" + fieldName + "]", new Object[0]);
        }
        return model;
    }

    public abstract WordScorer.WordScorerFactory buildWordScorerFactory();

    protected abstract boolean doEquals(SmoothingModel var1);

    protected abstract XContentBuilder innerToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
}

