/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.security;

import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import java.util.List;
import java.util.StringJoiner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectSecurity
implements AutoCloseable {
    private String id;
    private ThreadContext.StoredContext ctx = null;
    private ThreadContext threadContext;
    private Settings settings;
    private final Logger log = LogManager.getLogger(this.getClass());

    public InjectSecurity(String id, Settings settings, ThreadContext tc) {
        this.id = id;
        this.settings = settings;
        this.threadContext = tc;
        this.ctx = tc.newStoredContext(true);
        this.log.trace("{}, InjectSecurity constructor: {}", (Object)Thread.currentThread().getName(), (Object)id);
    }

    public void inject(String user, List<String> roles) {
        boolean injectUser = this.settings.getAsBoolean("plugins.security_use_injected_user_for_plugins", false);
        if (injectUser) {
            this.injectUser(user);
        } else {
            this.injectRoles(roles);
        }
    }

    public void injectUser(String user) {
        if (Strings.isNullOrEmpty(user)) {
            return;
        }
        if (this.threadContext.getTransient("injected_user") == null) {
            this.threadContext.putTransient("injected_user", user);
            this.log.debug("{}, InjectSecurity - inject roles: {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        } else {
            this.log.error("{}, InjectSecurity - most likely thread context corruption : {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        }
    }

    public void injectUserInfo(User user) {
        if (user == null) {
            return;
        }
        String userObjectAsString = (String)this.threadContext.getTransient("_opendistro_security_user_info");
        if (userObjectAsString != null) {
            this.log.error("{}, InjectSecurity - id: [{}] found existing user_info: {}", (Object)Thread.currentThread().getName(), (Object)this.id, (Object)userObjectAsString);
            return;
        }
        StringJoiner joiner = new StringJoiner("|");
        joiner.add(InjectSecurity.escapePipe(user.getName()));
        joiner.add(InjectSecurity.escapePipe(String.join((CharSequence)",", user.getBackendRoles())));
        joiner.add(InjectSecurity.escapePipe(String.join((CharSequence)",", user.getRoles())));
        String requestedTenant = user.getRequestedTenant();
        if (!Strings.isNullOrEmpty(requestedTenant)) {
            joiner.add(InjectSecurity.escapePipe(requestedTenant));
        }
        this.threadContext.putTransient("_opendistro_security_user_info", joiner.toString());
        if (this.threadContext.getTransient("injected_user_custom_attributes") == null) {
            this.threadContext.putTransient("injected_user_custom_attributes", user.getCustomAttributes());
            this.log.debug("{}, InjectSecurity - inject user custom attributes: {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        } else {
            this.log.error("{}, InjectSecurity - most likely thread context corruption : {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        }
    }

    public void injectRoles(List<String> roles) {
        if (roles == null || roles.size() == 0) {
            return;
        }
        String rolesStr = String.join((CharSequence)",", roles);
        String injectStr = "plugin|" + rolesStr;
        if (this.threadContext.getTransient("opendistro_security_injected_roles") == null) {
            this.threadContext.putTransient("opendistro_security_injected_roles", injectStr);
            this.log.debug("{}, InjectSecurity - inject roles: {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        } else {
            this.log.error("{}, InjectSecurity- most likely thread context corruption : {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        }
    }

    public boolean injectProperty(String property, Object value) {
        if (Strings.isNullOrEmpty(property) || value == null || this.threadContext.getTransient(property) != null) {
            this.log.debug("{}, InjectSecurity - cannot inject property: {}", (Object)Thread.currentThread().getName(), (Object)this.id);
            return false;
        }
        this.threadContext.putTransient(property, value);
        this.log.debug("{}, InjectSecurity - inject property: {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        return true;
    }

    @Override
    public void close() {
        if (this.ctx != null) {
            this.ctx.close();
            this.log.trace("{}, InjectSecurity close : {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        }
    }

    public static String escapePipe(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("|", "\\|");
    }

    public static String unescapePipe(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\|", "|");
    }
}

