/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.security.auth;

import io.skylite.LuceniaVersion;
import io.skylite.common.Nullable;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.internal.ToStringBuilder;
import io.skylite.core.common.io.Base64Helper;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class User
implements Writeable,
ToXContent {
    public static final String NAME_FIELD = "name";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String ROLES_FIELD = "roles";
    public static final String CUSTOM_ATTRIBUTE_NAMES_FIELD = "custom_attribute_names";
    public static final String CUSTOM_ATTRIBUTES_FIELD = "custom_attributes";
    public static final String REQUESTED_TENANT_FIELD = "user_requested_tenant";
    public static final String REQUESTED_TENANT_ACCESS = "user_requested_tenant_access";
    private final String name;
    private final List<String> backendRoles;
    private final List<String> roles;
    private final Map<String, String> customAttributes;
    @Nullable
    private final String requestedTenant;
    @Nullable
    private final String requestedTenantAccess;

    public User() {
        this.name = "";
        this.backendRoles = new ArrayList<String>();
        this.roles = new ArrayList<String>();
        this.customAttributes = new HashMap<String, String>();
        this.requestedTenant = null;
        this.requestedTenantAccess = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, Map<String, String> customAttributes) {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttributes = customAttributes;
        this.requestedTenant = null;
        this.requestedTenantAccess = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, List<String> customAttNames) {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttributes = this.convertCustomAttributeNamesToMap(customAttNames);
        this.requestedTenant = null;
        this.requestedTenantAccess = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, Map<String, String> customAttributes, @Nullable String requestedTenant) {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttributes = customAttributes;
        this.requestedTenant = requestedTenant;
        this.requestedTenantAccess = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, Map<String, String> customAttributes, @Nullable String requestedTenant, @Nullable String requestedTenantAccess) {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttributes = customAttributes;
        this.requestedTenant = requestedTenant;
        this.requestedTenantAccess = requestedTenantAccess;
    }

    public User(String json) {
        if (Strings.isNullOrEmpty(json)) {
            throw new IllegalArgumentException("Response json cannot be null");
        }
        Map<String, Object> mapValue = XContentHelper.convertToMap(MediaTypeRegistry.JSON.xContent(), json, false);
        this.name = (String)mapValue.get("user_name");
        this.backendRoles = (List)mapValue.get(BACKEND_ROLES_FIELD);
        this.roles = (List)mapValue.get(ROLES_FIELD);
        Map<Object, Object> customAttributesFromJson = (Map<Object, Object>)mapValue.get(CUSTOM_ATTRIBUTES_FIELD);
        List customAttNames = (List)mapValue.get(CUSTOM_ATTRIBUTE_NAMES_FIELD);
        this.customAttributes = customAttributesFromJson != null ? customAttributesFromJson : this.convertCustomAttributeNamesToMap(customAttNames);
        this.requestedTenant = mapValue.getOrDefault(REQUESTED_TENANT_FIELD, null);
        this.requestedTenantAccess = mapValue.getOrDefault(REQUESTED_TENANT_ACCESS, null);
    }

    public User(StreamInput in) throws IOException {
        this.name = in.readString();
        this.backendRoles = in.readStringList();
        this.roles = in.readStringList();
        if (in.getVersion().onOrAfter(LuceniaVersion.V_0_9_0)) {
            this.customAttributes = in.readMap(StreamInput::readString, StreamInput::readString);
        } else {
            List<String> customAttNames = in.readStringList();
            this.customAttributes = this.convertCustomAttributeNamesToMap(customAttNames);
        }
        this.requestedTenant = in.readOptionalString();
        this.requestedTenantAccess = in.getVersion().onOrAfter(LuceniaVersion.V_0_9_0) ? in.readOptionalString() : null;
    }

    public static User parse(XContentParser parser) throws IOException {
        String name = "";
        ArrayList<String> backendRoles = new ArrayList<String>();
        ArrayList<String> roles = new ArrayList<String>();
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        String requestedTenant = null;
        String requestedTenantAccess = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    break;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    break;
                }
                case "roles": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        roles.add(parser.text());
                    }
                    break;
                }
                case "custom_attributes": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String attrName = parser.currentName();
                        parser.nextToken();
                        String attrValue = parser.text();
                        customAttributes.put(attrName, attrValue);
                    }
                    break;
                }
                case "custom_attribute_names": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        customAttributes.put(parser.text(), null);
                    }
                    break;
                }
                case "user_requested_tenant": {
                    requestedTenant = parser.textOrNull();
                    break;
                }
                case "user_requested_tenant_access": {
                    requestedTenantAccess = parser.textOrNull();
                    break;
                }
            }
        }
        return new User(name, backendRoles, roles, customAttributes, requestedTenant, requestedTenantAccess);
    }

    public static User parse(String userString) {
        if (Strings.isNullOrEmpty(userString)) {
            return null;
        }
        String[] strs = userString.split("(?<!\\\\)\\|");
        if (strs.length == 0 || Strings.isNullOrEmpty(strs[0])) {
            return null;
        }
        String userName = User.unescapePipe(strs[0].trim());
        ArrayList<String> backendRoles = new ArrayList<String>();
        ArrayList<String> roles = new ArrayList<String>();
        String requestedTenant = null;
        String requestedTenantAccess = null;
        Map<String, String> customAttributes = new HashMap<String, String>();
        if (strs.length > 1 && !Strings.isNullOrEmpty(strs[1])) {
            backendRoles.addAll(Arrays.asList(strs[1].split(",")).stream().map(User::unescapePipe).collect(Collectors.toList()));
        }
        if (strs.length > 2 && !Strings.isNullOrEmpty(strs[2])) {
            roles.addAll(Arrays.asList(strs[2].split(",")).stream().map(User::unescapePipe).collect(Collectors.toList()));
        }
        if (strs.length > 3 && !Strings.isNullOrEmpty(strs[3])) {
            requestedTenant = User.unescapePipe(strs[3].trim());
        }
        if (strs.length > 4 && !Strings.isNullOrEmpty(strs[4])) {
            requestedTenantAccess = User.unescapePipe(strs[4].trim());
        }
        if (strs.length > 5 && !Strings.isNullOrEmpty(strs[5])) {
            customAttributes = (Map)((Object)Base64Helper.deserializeObject(strs[5]));
        }
        return new User(userName, backendRoles, roles, customAttributes, requestedTenant, requestedTenantAccess);
    }

    private static String unescapePipe(String s) {
        return s.replace("\\|", "|");
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(NAME_FIELD, this.name).field(BACKEND_ROLES_FIELD, this.backendRoles).field(ROLES_FIELD, this.roles).field(REQUESTED_TENANT_FIELD, this.requestedTenant).field(REQUESTED_TENANT_ACCESS, this.requestedTenantAccess);
        if (this.customAttributes.size() > 0) {
            builder.field(CUSTOM_ATTRIBUTES_FIELD, (Object)this.customAttributes);
        } else {
            builder.field(CUSTOM_ATTRIBUTE_NAMES_FIELD, new ArrayList());
        }
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.backendRoles);
        out.writeStringCollection(this.roles);
        if (out.getVersion().onOrAfter(LuceniaVersion.V_0_9_0)) {
            out.writeMap(this.customAttributes, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            ArrayList<String> customAttributeNames = new ArrayList<String>(this.customAttributes.keySet());
            out.writeStringCollection(customAttributeNames);
        }
        out.writeOptionalString(this.requestedTenant);
        if (out.getVersion().onOrAfter(LuceniaVersion.V_0_9_0)) {
            out.writeOptionalString(this.requestedTenantAccess);
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        builder.add(NAME_FIELD, this.name);
        builder.add(BACKEND_ROLES_FIELD, this.backendRoles);
        builder.add(ROLES_FIELD, this.roles);
        TreeMap<String, String> sortedCustomAttributes = new TreeMap<String, String>();
        sortedCustomAttributes.putAll(this.customAttributes);
        builder.add(CUSTOM_ATTRIBUTES_FIELD, sortedCustomAttributes);
        builder.add(REQUESTED_TENANT_FIELD, this.requestedTenant);
        builder.add(REQUESTED_TENANT_ACCESS, this.requestedTenantAccess);
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        User that = (User)obj;
        return this.name.equals(that.name) && this.getBackendRoles().equals(that.backendRoles) && this.getRoles().equals(that.roles) && this.getCustomAttributes().equals(that.customAttributes) && Objects.equals(this.requestedTenant, that.requestedTenant) && Objects.equals(this.requestedTenantAccess, that.requestedTenantAccess);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.backendRoles, this.roles, this.customAttributes, this.requestedTenant, this.requestedTenantAccess);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public List<String> getCustomAttNames() {
        return this.getCustomAttributeNamesFromMap(this.customAttributes);
    }

    @Nullable
    public String getRequestedTenant() {
        return this.requestedTenant;
    }

    @Nullable
    public String getRequestedTenantAccess() {
        return this.requestedTenantAccess;
    }

    public boolean isAdminDn(Settings settings) {
        if (settings == null) {
            return false;
        }
        List<String> adminDns = settings.getAsList("plugins.security.authcz.admin_dn", Collections.emptyList());
        return adminDns.contains(this.name);
    }

    private Map<String, String> convertCustomAttributeNamesToMap(List<String> customAttNames) {
        return customAttNames.stream().collect(Collectors.toMap(key -> key, key -> "null"));
    }

    private List<String> getCustomAttributeNamesFromMap(Map<String, String> customAttributes) {
        ArrayList<String> customAttNames = new ArrayList<String>(this.customAttributes.keySet());
        return customAttNames;
    }
}

