/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.settings;

import io.skylite.common.annotation.PublicApi;
import io.skylite.core.common.logging.Loggers;
import io.skylite.core.settings.AbstractScopedSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.SettingUpgrader;
import io.skylite.core.settings.Settings;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;

@PublicApi(since="1.0.0")
public final class ClusterSettings
extends AbstractScopedSettings {
    public static Set<Setting<?>> BUILT_IN_CLUSTER_SETTINGS = SETTINGS_REGISTRY.stream().filter(s -> s.getProperties().contains((Object)Setting.Property.NodeScope)).collect(Collectors.toUnmodifiableSet());
    public static List<SettingUpgrader<?>> BUILT_IN_SETTING_UPGRADERS = Collections.emptyList();

    public ClusterSettings(Settings nodeSettings, Set<Setting<?>> settingsSet) {
        this(nodeSettings, settingsSet, Collections.emptySet());
    }

    public ClusterSettings(Settings nodeSettings, Set<Setting<?>> settingsSet, Set<SettingUpgrader<?>> settingUpgraders) {
        super(nodeSettings, settingsSet, settingUpgraders, Setting.Property.NodeScope);
        this.addSettingsUpdater(new LoggingSettingUpdater(nodeSettings));
    }

    private static final class LoggingSettingUpdater
    implements AbstractScopedSettings.SettingUpdater<Settings> {
        final Predicate<String> loggerPredicate = Loggers.LOG_LEVEL_SETTING::match;
        private final Settings settings;

        LoggingSettingUpdater(Settings settings) {
            this.settings = settings;
        }

        @Override
        public boolean hasChanged(Settings current, Settings previous) {
            return !current.filter(this.loggerPredicate).equals(previous.filter(this.loggerPredicate));
        }

        @Override
        public Settings getValue(Settings current, Settings previous) {
            Settings.Builder builder = Settings.builder();
            builder.put(current.filter(this.loggerPredicate));
            for (String key : previous.keySet()) {
                if (!this.loggerPredicate.test(key) || builder.keys().contains(key)) continue;
                if (!Loggers.LOG_LEVEL_SETTING.getConcreteSetting(key).exists(this.settings)) {
                    builder.putNull(key);
                    continue;
                }
                builder.put(key, Loggers.LOG_LEVEL_SETTING.getConcreteSetting(key).get(this.settings).toString());
            }
            return builder.build();
        }

        @Override
        public void apply(Settings value, Settings current, Settings previous) {
            for (String key : value.keySet()) {
                assert (this.loggerPredicate.test(key));
                String component = key.substring("logger.".length());
                if ("level".equals(component)) continue;
                if ("_root".equals(component)) {
                    String rootLevel = value.get(key);
                    if (rootLevel == null) {
                        Loggers.setLevel(LogManager.getRootLogger(), Loggers.LOG_DEFAULT_LEVEL_SETTING.get(this.settings));
                        continue;
                    }
                    Loggers.setLevel(LogManager.getRootLogger(), rootLevel);
                    continue;
                }
                Loggers.setLevel(LogManager.getLogger((String)component), value.get(key));
            }
        }
    }
}

