/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.snapshots;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.common.Nullable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.snapshots.Snapshot;
import io.skylite.core.snapshots.SnapshotId;
import java.io.IOException;

public class SnapshotException
extends SkyliteException {
    @Nullable
    private final String repositoryName;
    @Nullable
    private final String snapshotName;

    public SnapshotException(Snapshot snapshot, String msg) {
        this(snapshot, msg, null);
    }

    public SnapshotException(Snapshot snapshot, String msg, Throwable cause) {
        super("[" + String.valueOf(snapshot == null ? "_na" : snapshot) + "] " + msg, cause, new Object[0]);
        if (snapshot != null) {
            this.repositoryName = snapshot.getRepository();
            this.snapshotName = snapshot.getSnapshotId().getName();
        } else {
            this.repositoryName = null;
            this.snapshotName = null;
        }
    }

    public SnapshotException(String repositoryName, SnapshotId snapshotId, String msg, Throwable cause) {
        super("[" + repositoryName + ":" + String.valueOf(snapshotId) + "] " + msg, cause, new Object[0]);
        this.repositoryName = repositoryName;
        this.snapshotName = snapshotId.getName();
    }

    public SnapshotException(String repositoryName, String snapshotName, String msg) {
        this(repositoryName, snapshotName, msg, null);
    }

    public SnapshotException(String repositoryName, String snapshotName, String msg, Throwable cause) {
        super("[" + repositoryName + ":" + snapshotName + "] " + msg, cause, new Object[0]);
        this.repositoryName = repositoryName;
        this.snapshotName = snapshotName;
    }

    public SnapshotException(StreamInput in) throws IOException {
        super(in);
        this.repositoryName = in.readOptionalString();
        this.snapshotName = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.repositoryName);
        out.writeOptionalString(this.snapshotName);
    }

    @Nullable
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Nullable
    public String getSnapshotName() {
        return this.snapshotName;
    }

    public static class Registration
    implements SkyliteExceptionProvider<SnapshotException> {
        @Override
        public Class<SnapshotException> getExceptionClass() {
            return SnapshotException.class;
        }

        @Override
        public CheckedFunction<StreamInput, SnapshotException, IOException> getConstructor() {
            return SnapshotException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 30;
        }
    }
}

