/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.snapshots;

import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.snapshots.SnapshotShard;
import java.util.Collections;
import java.util.Map;

public class SnapshotShardSizeInfo {
    public static final SnapshotShardSizeInfo EMPTY = new SnapshotShardSizeInfo(Map.of());
    private final Map<SnapshotShard, Long> snapshotShardSizes;

    public SnapshotShardSizeInfo(Map<SnapshotShard, Long> snapshotShardSizes) {
        this.snapshotShardSizes = Collections.unmodifiableMap(snapshotShardSizes);
    }

    public Long getShardSize(ShardRouting shardRouting) {
        if (shardRouting.primary() && !shardRouting.active() && shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) {
            RecoverySource.SnapshotRecoverySource snapshotRecoverySource = (RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource();
            return this.snapshotShardSizes.get(new SnapshotShard(snapshotRecoverySource.snapshot(), snapshotRecoverySource.index(), shardRouting.shardId()));
        }
        assert (false) : "Expected shard with snapshot recovery source but was " + String.valueOf(shardRouting);
        return null;
    }

    public long getShardSize(ShardRouting shardRouting, long fallback) {
        Long shardSize = this.getShardSize(shardRouting);
        if (shardSize == null || shardSize == -1L) {
            return fallback;
        }
        return shardSize;
    }
}

