/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.snapshots;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.Version;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.collect.Tuple;
import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.GroupedActionListener;
import io.skylite.core.action.StepListener;
import io.skylite.core.action.admin.cluster.snapshots.clone.CloneSnapshotRequest;
import io.skylite.core.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import io.skylite.core.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.NotClusterManagerException;
import io.skylite.core.cluster.RepositoryCleanupInProgress;
import io.skylite.core.cluster.RestoreInProgress;
import io.skylite.core.cluster.SnapshotDeletionsInProgress;
import io.skylite.core.cluster.SnapshotsInProgress;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.RepositoriesMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.IndexRoutingTable;
import io.skylite.core.cluster.routing.IndexShardRoutingTable;
import io.skylite.core.cluster.routing.RoutingTable;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateApplier;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateTaskExecutor;
import io.skylite.core.cluster.state.ClusterStateTaskListener;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.cluster.state.FailedToCommitClusterStateException;
import io.skylite.core.common.Priority;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.index.Index;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.store.remote.lockmanager.RemoteStoreLockManagerFactory;
import io.skylite.core.repositories.IndexId;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.RepositoryData;
import io.skylite.core.repositories.RepositoryException;
import io.skylite.core.repositories.RepositoryMissingException;
import io.skylite.core.repositories.RepositoryShardId;
import io.skylite.core.repositories.ShardGenerations;
import io.skylite.core.repositories.blobstore.BlobStoreRepositorySettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.snapshots.BaseRestoreService;
import io.skylite.core.snapshots.ConcurrentSnapshotExecutionException;
import io.skylite.core.snapshots.InFlightShardSnapshotStates;
import io.skylite.core.snapshots.InvalidSnapshotNameException;
import io.skylite.core.snapshots.Snapshot;
import io.skylite.core.snapshots.SnapshotException;
import io.skylite.core.snapshots.SnapshotId;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.snapshots.SnapshotMissingException;
import io.skylite.core.snapshots.SnapshotShardFailure;
import io.skylite.core.snapshots.SnapshotUtils;
import io.skylite.core.snapshots.UpdateIndexShardSnapshotStatusRequest;
import io.skylite.core.snapshots.UpdateIndexShardSnapshotStatusResponse;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class SnapshotsService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(SnapshotsService.class);
    public static final String UPDATE_SNAPSHOT_STATUS_ACTION_NAME = "internal:cluster/snapshot/update_snapshot_status";
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final RepositoriesService repositoriesService;
    private final RemoteStoreLockManagerFactory remoteStoreLockManagerFactory;
    private final ThreadPool threadPool;
    private final Map<Snapshot, List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>>> snapshotCompletionListeners = new ConcurrentHashMap<Snapshot, List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>>>();
    private final Map<String, List<ActionListener<Void>>> snapshotDeletionListeners = new HashMap<String, List<ActionListener<Void>>>();
    private final Set<String> currentlyFinalizing = Collections.synchronizedSet(new HashSet());
    private final Set<Snapshot> endingSnapshots = Collections.synchronizedSet(new HashSet());
    private final Set<Snapshot> initializingClones = Collections.synchronizedSet(new HashSet());
    private final UpdateSnapshotStatusAction updateSnapshotStatusHandler;
    private final TransportService transportService;
    private final OngoingRepositoryOperations repositoryOperations = new OngoingRepositoryOperations();
    private final ClusterManagerTaskThrottler.ThrottlingKey createSnapshotTaskKey;
    private final ClusterManagerTaskThrottler.ThrottlingKey deleteSnapshotTaskKey;
    private static ClusterManagerTaskThrottler.ThrottlingKey updateSnapshotStateTaskKey;
    public static final Setting<Integer> MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING;
    private volatile int maxConcurrentOperations;
    private final Set<RepositoryShardId> currentlyCloning = Collections.synchronizedSet(new HashSet());
    static final ClusterStateTaskExecutor<ShardSnapshotUpdate> SHARD_STATE_EXECUTOR;
    static final ClusterStateTaskExecutor<ShardSnapshotUpdate> shardStateExecutor;

    public SnapshotsService(Settings settings, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, RepositoriesService repositoriesService, TransportService transportService, ActionFilters actionFilters) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.repositoriesService = repositoriesService;
        this.remoteStoreLockManagerFactory = new RemoteStoreLockManagerFactory(() -> repositoriesService);
        this.threadPool = transportService.getThreadPool();
        this.transportService = transportService;
        this.updateSnapshotStatusHandler = new UpdateSnapshotStatusAction(transportService, clusterService, this.threadPool, actionFilters, indexNameExpressionResolver);
        if (DiscoveryNode.isClusterManagerNode(settings)) {
            clusterService.addLowPriorityApplier(this);
            this.maxConcurrentOperations = MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING, i -> {
                this.maxConcurrentOperations = i;
            });
        }
        this.createSnapshotTaskKey = clusterService.registerClusterManagerTask("create-snapshot", true);
        this.deleteSnapshotTaskKey = clusterService.registerClusterManagerTask("delete-snapshot", true);
        updateSnapshotStateTaskKey = clusterService.registerClusterManagerTask("update-snapshot-state", true);
    }

    public void executeSnapshot(CreateSnapshotRequest request, ActionListener<SnapshotInfo> listener) {
        this.createSnapshot(request, ActionListenerHelper.wrap(snapshot -> this.addListener((Snapshot)snapshot, (ActionListener<Tuple<RepositoryData, SnapshotInfo>>)ActionListenerHelper.map(listener, Tuple::v2)), arg_0 -> listener.onFailure(arg_0)));
    }

    public void createSnapshot(CreateSnapshotRequest request, ActionListener<Snapshot> listener) {
        String repositoryName = request.repository();
        String snapshotName = this.indexNameExpressionResolver.resolveDateMathExpression(request.snapshot());
        SnapshotsService.validate(repositoryName, snapshotName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID());
        Repository repository = this.repositoriesService.repository(request.repository());
        if (repository.isReadOnly()) {
            listener.onFailure((Exception)new RepositoryException(repository.getMetadata().name(), "cannot create snapshot in a readonly repository"));
            return;
        }
        Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
        Map<String, Object> userMeta = repository.adaptUserMetadata(request.userMetadata());
        repository.executeConsistentStateUpdate(repositoryData -> new ClusterStateUpdateTask((RepositoryData)repositoryData, snapshotName, repository, repositoryName, request, snapshotId, userMeta, (ActionListener)listener, snapshot){
            private SnapshotsInProgress.Entry newEntry;
            final /* synthetic */ RepositoryData val$repositoryData;
            final /* synthetic */ String val$snapshotName;
            final /* synthetic */ Repository val$repository;
            final /* synthetic */ String val$repositoryName;
            final /* synthetic */ CreateSnapshotRequest val$request;
            final /* synthetic */ SnapshotId val$snapshotId;
            final /* synthetic */ Map val$userMeta;
            final /* synthetic */ ActionListener val$listener;
            final /* synthetic */ Snapshot val$snapshot;
            {
                this.val$repositoryData = repositoryData;
                this.val$snapshotName = string;
                this.val$repository = repository;
                this.val$repositoryName = string2;
                this.val$request = createSnapshotRequest;
                this.val$snapshotId = snapshotId;
                this.val$userMeta = map;
                this.val$listener = actionListener;
                this.val$snapshot = snapshot;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsService.ensureSnapshotNameAvailableInRepo(this.val$repositoryData, this.val$snapshotName, this.val$repository);
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                List<SnapshotsInProgress.Entry> runningSnapshots = snapshots.entries();
                SnapshotsService.ensureSnapshotNameNotRunning(runningSnapshots, this.val$repositoryName, this.val$snapshotName);
                SnapshotsService.validate(this.val$repositoryName, this.val$snapshotName, currentState);
                SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                RepositoryCleanupInProgress repositoryCleanupInProgress = currentState.custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY);
                if (repositoryCleanupInProgress.hasCleanupInProgress()) {
                    throw new ConcurrentSnapshotExecutionException(this.val$repositoryName, this.val$snapshotName, "cannot snapshot while a repository cleanup is in-progress in [" + String.valueOf(repositoryCleanupInProgress) + "]");
                }
                SnapshotsService.ensureNoCleanupInProgress(currentState, this.val$repositoryName, this.val$snapshotName);
                SnapshotsService.this.ensureBelowConcurrencyLimit(this.val$repositoryName, this.val$snapshotName, snapshots, deletionsInProgress);
                List<String> indices = Arrays.asList(SnapshotsService.this.indexNameExpressionResolver.concreteIndexNames(currentState, this.val$request));
                List<String> dataStreams = SnapshotsService.this.indexNameExpressionResolver.dataStreamNames(currentState, this.val$request.indicesOptions(), this.val$request.indices());
                logger.trace("[{}][{}] creating snapshot for indices [{}]", (Object)this.val$repositoryName, (Object)this.val$snapshotName, indices);
                List<IndexId> indexIds = this.val$repositoryData.resolveNewIndices(indices, SnapshotsService.getInFlightIndexIds(runningSnapshots, this.val$repositoryName));
                Version version = SnapshotsService.this.minCompatibleVersion(currentState.nodes().getMinNodeVersion(), this.val$repositoryData, null);
                Map<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = SnapshotsService.shards(snapshots, deletionsInProgress, currentState.metadata(), currentState.routingTable(), indexIds, this.val$repositoryData, this.val$repositoryName);
                if (!this.val$request.partial()) {
                    HashSet<String> missing = new HashSet<String>();
                    for (Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> entry : shards.entrySet()) {
                        if (entry.getValue().state() != SnapshotsInProgress.ShardState.MISSING) continue;
                        missing.add(entry.getKey().getIndex().getName());
                    }
                    if (!missing.isEmpty()) {
                        throw new SnapshotException(new Snapshot(this.val$repositoryName, this.val$snapshotId), "Indices don't have primary shards " + String.valueOf(missing));
                    }
                }
                boolean remoteStoreIndexShallowCopy = BlobStoreRepositorySettings.REMOTE_STORE_INDEX_SHALLOW_COPY.get(this.val$repository.getMetadata().settings());
                this.newEntry = SnapshotsInProgress.startedEntry(new Snapshot(this.val$repositoryName, this.val$snapshotId), this.val$request.includeGlobalState(), this.val$request.partial(), indexIds, dataStreams, SnapshotsService.this.threadPool.absoluteTimeInMillis(), this.val$repositoryData.getGenId(), shards, this.val$userMeta, version, remoteStoreIndexShallowCopy);
                ArrayList<SnapshotsInProgress.Entry> newEntries = new ArrayList<SnapshotsInProgress.Entry>(runningSnapshots);
                newEntries.add(this.newEntry);
                return ClusterState.builder(currentState).putCustom("snapshots", SnapshotsInProgress.of(new ArrayList<SnapshotsInProgress.Entry>(newEntries))).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to create snapshot", (Object)this.val$repositoryName, (Object)this.val$snapshotName), (Throwable)e);
                this.val$listener.onFailure(e);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return SnapshotsService.this.createSnapshotTaskKey;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                try {
                    logger.info("snapshot [{}] started", (Object)this.val$snapshot);
                    this.val$listener.onResponse((Object)this.val$snapshot);
                }
                finally {
                    if (this.newEntry.state().completed()) {
                        SnapshotsService.this.endSnapshot(this.newEntry, newState.metadata(), this.val$repositoryData);
                    }
                }
            }

            @Override
            public TimeValue timeout() {
                return this.val$request.clusterManagerNodeTimeout();
            }
        }, "create_snapshot [" + snapshotName + "]", arg_0 -> listener.onFailure(arg_0));
    }

    private static void ensureSnapshotNameNotRunning(List<SnapshotsInProgress.Entry> runningSnapshots, String repositoryName, String snapshotName) {
        if (runningSnapshots.stream().anyMatch(s -> {
            Snapshot running = s.snapshot();
            return running.getRepository().equals(repositoryName) && running.getSnapshotId().getName().equals(snapshotName);
        })) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "snapshot with the same name is already in-progress");
        }
    }

    private static Map<String, IndexId> getInFlightIndexIds(List<SnapshotsInProgress.Entry> runningSnapshots, String repositoryName) {
        return runningSnapshots.stream().filter(entry -> entry.repository().equals(repositoryName)).flatMap(entry -> entry.indices().stream()).distinct().collect(Collectors.toMap(IndexId::getName, Function.identity()));
    }

    public void cloneSnapshot(CloneSnapshotRequest request, ActionListener<Void> listener) {
        String repositoryName = request.repository();
        Repository repository = this.repositoriesService.repository(repositoryName);
        if (repository.isReadOnly()) {
            listener.onFailure((Exception)new RepositoryException(repositoryName, "cannot create snapshot in a readonly repository"));
            return;
        }
        String snapshotName = this.indexNameExpressionResolver.resolveDateMathExpression(request.target());
        SnapshotsService.validate(repositoryName, snapshotName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID());
        Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
        this.initializingClones.add(snapshot);
        repository.executeConsistentStateUpdate(repositoryData -> new ClusterStateUpdateTask((RepositoryData)repositoryData, snapshotName, repository, repositoryName, request, snapshot, (ActionListener)listener){
            private SnapshotsInProgress.Entry newEntry;
            final /* synthetic */ RepositoryData val$repositoryData;
            final /* synthetic */ String val$snapshotName;
            final /* synthetic */ Repository val$repository;
            final /* synthetic */ String val$repositoryName;
            final /* synthetic */ CloneSnapshotRequest val$request;
            final /* synthetic */ Snapshot val$snapshot;
            final /* synthetic */ ActionListener val$listener;
            {
                this.val$repositoryData = repositoryData;
                this.val$snapshotName = string;
                this.val$repository = repository;
                this.val$repositoryName = string2;
                this.val$request = cloneSnapshotRequest;
                this.val$snapshot = snapshot;
                this.val$listener = actionListener;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsService.ensureSnapshotNameAvailableInRepo(this.val$repositoryData, this.val$snapshotName, this.val$repository);
                SnapshotsService.ensureNoCleanupInProgress(currentState, this.val$repositoryName, this.val$snapshotName);
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                List<SnapshotsInProgress.Entry> runningSnapshots = snapshots.entries();
                SnapshotsService.ensureSnapshotNameNotRunning(runningSnapshots, this.val$repositoryName, this.val$snapshotName);
                SnapshotsService.validate(this.val$repositoryName, this.val$snapshotName, currentState);
                SnapshotId sourceSnapshotId = this.val$repositoryData.getSnapshotIds().stream().filter(src -> src.getName().equals(this.val$request.source())).findAny().orElseThrow(() -> new SnapshotMissingException(this.val$repositoryName, this.val$request.source()));
                SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                if (deletionsInProgress.getEntries().stream().anyMatch(entry -> entry.getSnapshots().contains(sourceSnapshotId))) {
                    throw new ConcurrentSnapshotExecutionException(this.val$repositoryName, sourceSnapshotId.getName(), "cannot clone from snapshot that is being deleted");
                }
                SnapshotsService.this.ensureBelowConcurrencyLimit(this.val$repositoryName, this.val$snapshotName, snapshots, deletionsInProgress);
                ArrayList<String> indicesForSnapshot = new ArrayList<String>();
                for (IndexId indexId : this.val$repositoryData.getIndices().values()) {
                    if (!this.val$repositoryData.getSnapshots(indexId).contains(sourceSnapshotId)) continue;
                    indicesForSnapshot.add(indexId.getName());
                }
                List<String> matchingIndices = SnapshotUtils.filterIndices(indicesForSnapshot, this.val$request.indices(), this.val$request.indicesOptions());
                if (matchingIndices.isEmpty()) {
                    throw new SnapshotException(new Snapshot(this.val$repositoryName, sourceSnapshotId), "No indices in the source snapshot [" + String.valueOf(sourceSnapshotId) + "] matched requested pattern [" + Strings.arrayToCommaDelimitedString(this.val$request.indices()) + "]");
                }
                this.newEntry = SnapshotsInProgress.startClone(this.val$snapshot, sourceSnapshotId, this.val$repositoryData.resolveIndices(matchingIndices), SnapshotsService.this.threadPool.absoluteTimeInMillis(), this.val$repositoryData.getGenId(), SnapshotsService.this.minCompatibleVersion(currentState.nodes().getMinNodeVersion(), this.val$repositoryData, null));
                ArrayList<SnapshotsInProgress.Entry> newEntries = new ArrayList<SnapshotsInProgress.Entry>(runningSnapshots);
                newEntries.add(this.newEntry);
                return ClusterState.builder(currentState).putCustom("snapshots", SnapshotsInProgress.of(newEntries)).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                SnapshotsService.this.initializingClones.remove(this.val$snapshot);
                logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to clone snapshot", (Object)this.val$repositoryName, (Object)this.val$snapshotName), (Throwable)e);
                this.val$listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                logger.info("snapshot clone [{}] started", (Object)this.val$snapshot);
                SnapshotsService.this.addListener(this.val$snapshot, ActionListenerHelper.wrap(r -> this.val$listener.onResponse(null), arg_0 -> ((ActionListener)this.val$listener).onFailure(arg_0)));
                SnapshotsService.this.startCloning(this.val$repository, this.newEntry);
            }

            @Override
            public TimeValue timeout() {
                return this.val$request.clusterManagerNodeTimeout();
            }
        }, "clone_snapshot [" + request.source() + "][" + snapshotName + "]", arg_0 -> listener.onFailure(arg_0));
    }

    private static void ensureNoCleanupInProgress(ClusterState currentState, String repositoryName, String snapshotName) {
        RepositoryCleanupInProgress repositoryCleanupInProgress = currentState.custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY);
        if (repositoryCleanupInProgress.hasCleanupInProgress()) {
            throw new ConcurrentSnapshotExecutionException(repositoryName, snapshotName, "cannot snapshot while a repository cleanup is in-progress in [" + String.valueOf(repositoryCleanupInProgress) + "]");
        }
    }

    private static void ensureSnapshotNameAvailableInRepo(RepositoryData repositoryData, String snapshotName, Repository repository) {
        if (repositoryData.getSnapshotIds().stream().anyMatch(s -> s.getName().equals(snapshotName))) {
            throw new InvalidSnapshotNameException(repository.getMetadata().name(), snapshotName, "snapshot with the same name already exists");
        }
    }

    private void startCloning(Repository repository, final SnapshotsInProgress.Entry cloneEntry) {
        List<IndexId> indices = cloneEntry.indices();
        SnapshotId sourceSnapshot = cloneEntry.source();
        Snapshot targetSnapshot = cloneEntry.snapshot();
        ExecutorService executor = this.threadPool.executor("snapshot");
        Consumer<Exception> onFailure = e -> {
            this.initializingClones.remove(targetSnapshot);
            logger.info(() -> new ParameterizedMessage("Failed to start snapshot clone [{}]", (Object)cloneEntry), (Throwable)e);
            this.removeFailedSnapshotFromClusterState(targetSnapshot, (Exception)e, null, null);
        };
        StepListener snapshotInfoListener = new StepListener();
        executor.execute((Runnable)ActionRunnable.supply(snapshotInfoListener, () -> repository.getSnapshotInfo(sourceSnapshot)));
        StepListener allShardCountsListener = new StepListener();
        GroupedActionListener shardCountListener = new GroupedActionListener(allShardCountsListener, indices.size());
        snapshotInfoListener.whenComplete(snapshotInfo -> {
            for (IndexId indexId : indices) {
                if (!BaseRestoreService.failed(snapshotInfo, indexId.getName())) continue;
                throw new SnapshotException(targetSnapshot, "Can't clone index [" + String.valueOf(indexId) + "] because its snapshot was not successful.");
            }
            repository.getRepositoryData(ActionListenerHelper.wrap(repositoryData -> {
                for (IndexId index : indices) {
                    executor.execute((Runnable)ActionRunnable.supply((ActionListener)shardCountListener, () -> {
                        IndexMetadata metadata = repository.getSnapshotIndexMetaData((RepositoryData)repositoryData, sourceSnapshot, index);
                        return Tuple.tuple((Object)index, (Object)metadata.getNumberOfShards());
                    }));
                }
            }, onFailure));
        }, onFailure);
        allShardCountsListener.whenComplete(counts -> repository.executeConsistentStateUpdate(repoData -> new ClusterStateUpdateTask((RepositoryData)repoData, (Collection)counts, snapshotInfoListener, targetSnapshot, repository){
            private SnapshotsInProgress.Entry updatedEntry;
            final /* synthetic */ RepositoryData val$repoData;
            final /* synthetic */ Collection val$counts;
            final /* synthetic */ StepListener val$snapshotInfoListener;
            final /* synthetic */ Snapshot val$targetSnapshot;
            final /* synthetic */ Repository val$repository;
            {
                this.val$repoData = repositoryData;
                this.val$counts = collection;
                this.val$snapshotInfoListener = stepListener;
                this.val$targetSnapshot = snapshot;
                this.val$repository = repository;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsInProgress snapshotsInProgress = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                ArrayList<SnapshotsInProgress.Entry> updatedEntries = new ArrayList<SnapshotsInProgress.Entry>(snapshotsInProgress.entries());
                boolean changed = false;
                String localNodeId = currentState.nodes().getLocalNodeId();
                String repoName = cloneEntry.repository();
                ShardGenerations shardGenerations = this.val$repoData.shardGenerations();
                for (int i = 0; i < updatedEntries.size(); ++i) {
                    if (!cloneEntry.snapshot().equals(((SnapshotsInProgress.Entry)updatedEntries.get(i)).snapshot())) continue;
                    HashMap<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clonesBuilder = new HashMap<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus>();
                    InFlightShardSnapshotStates inFlightShardStates = InFlightShardSnapshotStates.forRepo(repoName, snapshotsInProgress.entries());
                    for (Tuple count : this.val$counts) {
                        for (int shardId = 0; shardId < (Integer)count.v2(); ++shardId) {
                            RepositoryShardId repoShardId = new RepositoryShardId((IndexId)count.v1(), shardId);
                            String indexName = repoShardId.indexName();
                            if (inFlightShardStates.isActive(indexName, shardId)) {
                                clonesBuilder.put(repoShardId, SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED);
                                continue;
                            }
                            clonesBuilder.put(repoShardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, inFlightShardStates.generationForShard(repoShardId.index(), shardId, shardGenerations)));
                        }
                    }
                    this.updatedEntry = cloneEntry.withClones(clonesBuilder).withRemoteStoreIndexShallowCopy(Boolean.TRUE.equals(((SnapshotInfo)this.val$snapshotInfoListener.result()).isRemoteStoreIndexShallowCopyEnabled()));
                    updatedEntries.set(i, this.updatedEntry);
                    changed = true;
                    break;
                }
                return SnapshotsService.updateWithSnapshots(currentState, changed ? SnapshotsInProgress.of(updatedEntries) : null, null);
            }

            @Override
            public void onFailure(String source, Exception e) {
                SnapshotsService.this.initializingClones.remove(this.val$targetSnapshot);
                logger.info(() -> new ParameterizedMessage("Failed to start snapshot clone [{}]", (Object)cloneEntry), (Throwable)e);
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                SnapshotsService.this.initializingClones.remove(this.val$targetSnapshot);
                if (this.updatedEntry != null) {
                    Snapshot target = this.updatedEntry.snapshot();
                    SnapshotId sourceSnapshot = this.updatedEntry.source();
                    for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> indexClone : this.updatedEntry.clones().entrySet()) {
                        SnapshotsInProgress.ShardSnapshotStatus shardStatusBefore = indexClone.getValue();
                        if (shardStatusBefore.state() != SnapshotsInProgress.ShardState.INIT) continue;
                        RepositoryShardId repoShardId = indexClone.getKey();
                        boolean remoteStoreIndexShallowCopy = Boolean.TRUE.equals(this.updatedEntry.remoteStoreIndexShallowCopy());
                        SnapshotsService.this.runReadyClone(target, sourceSnapshot, shardStatusBefore, repoShardId, this.val$repository, remoteStoreIndexShallowCopy);
                    }
                } else {
                    logger.warn("Did not find expected entry [{}] in the cluster state", (Object)cloneEntry);
                }
            }
        }, "start snapshot clone", onFailure), onFailure);
    }

    private void runReadyClone(final Snapshot target, final SnapshotId sourceSnapshot, final SnapshotsInProgress.ShardSnapshotStatus shardStatusBefore, final RepositoryShardId repoShardId, final Repository repository, final boolean remoteStoreIndexShallowCopy) {
        ExecutorService executor = this.threadPool.executor("snapshot");
        executor.execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                logger.warn("Failed to get repository data while cloning shard [{}] from [{}] to [{}]", (Object)repoShardId, (Object)sourceSnapshot, (Object)target.getSnapshotId());
                SnapshotsService.this.failCloneShardAndUpdateClusterState(target, sourceSnapshot, repoShardId);
            }

            public void doRun() {
                String localNodeId = SnapshotsService.this.clusterService.localNode().getId();
                repository.getRepositoryData(ActionListenerHelper.wrap(repositoryData -> {
                    try {
                        IndexMetadata indexMetadata = repository.getSnapshotIndexMetaData((RepositoryData)repositoryData, sourceSnapshot, repoShardId.index());
                        boolean cloneRemoteStoreIndexShardSnapshot = remoteStoreIndexShallowCopy && indexMetadata.getSettings().getAsBoolean("index.remote_store.enabled", false) != false;
                        SnapshotId targetSnapshot = target.getSnapshotId();
                        ActionListener listener = ActionListenerHelper.wrap(generation -> SnapshotsService.this.innerUpdateSnapshotState(new ShardSnapshotUpdate(target, repoShardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.ShardState.SUCCESS, (String)generation)), ActionListenerHelper.runBefore(ActionListenerHelper.wrap(v -> logger.trace("Marked [{}] as successfully cloned from [{}] to [{}]", (Object)repoShardId, (Object)sourceSnapshot, (Object)targetSnapshot), e -> {
                            logger.warn("Cluster state update after successful shard clone [{}] failed", (Object)repoShardId);
                            SnapshotsService.this.failAllListenersOnMasterFailOver((Exception)e);
                        }), () -> SnapshotsService.this.currentlyCloning.remove(repoShardId))), e -> {
                            logger.warn("Exception [{}] while trying to clone shard [{}]", e, (Object)repoShardId);
                            SnapshotsService.this.failCloneShardAndUpdateClusterState(target, sourceSnapshot, repoShardId);
                        });
                        if (SnapshotsService.this.currentlyCloning.add(repoShardId)) {
                            if (cloneRemoteStoreIndexShardSnapshot) {
                                repository.cloneRemoteStoreIndexShardSnapshot(sourceSnapshot, targetSnapshot, repoShardId, shardStatusBefore.generation(), SnapshotsService.this.remoteStoreLockManagerFactory, listener);
                            } else {
                                repository.cloneShardSnapshot(sourceSnapshot, targetSnapshot, repoShardId, shardStatusBefore.generation(), listener);
                            }
                        }
                    }
                    catch (IOException e2) {
                        logger.warn("Failed to get index-metadata from repository data for index [{}]", (Object)repoShardId.index().getName());
                        SnapshotsService.this.failCloneShardAndUpdateClusterState(target, sourceSnapshot, repoShardId);
                    }
                }, this::onFailure));
            }
        });
    }

    private void failCloneShardAndUpdateClusterState(Snapshot target, SnapshotId sourceSnapshot, RepositoryShardId repoShardId) {
        String localNodeId = this.clusterService.localNode().getId();
        this.innerUpdateSnapshotState(new ShardSnapshotUpdate(target, repoShardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.ShardState.FAILED, "failed to clone shard snapshot", null)), ActionListenerHelper.runBefore(ActionListenerHelper.wrap(v -> logger.trace("Marked [{}] as failed clone from [{}] to [{}]", (Object)repoShardId, (Object)sourceSnapshot, (Object)target.getSnapshotId()), ex -> {
            logger.warn("Cluster state update after failed shard clone [{}] failed", (Object)repoShardId);
            this.failAllListenersOnMasterFailOver((Exception)ex);
        }), () -> this.currentlyCloning.remove(repoShardId)));
    }

    private void ensureBelowConcurrencyLimit(String repository, String name, SnapshotsInProgress snapshotsInProgress, SnapshotDeletionsInProgress deletionsInProgress) {
        int maxOps;
        int inProgressOperations = snapshotsInProgress.entries().size() + deletionsInProgress.getEntries().size();
        if (inProgressOperations >= (maxOps = this.maxConcurrentOperations)) {
            throw new ConcurrentSnapshotExecutionException(repository, name, "Cannot start another operation, already running [" + inProgressOperations + "] operations and the current limit for concurrent snapshot operations is set to [" + maxOps + "]");
        }
    }

    private static void validate(String repositoryName, String snapshotName, ClusterState state) {
        RepositoriesMetadata repositoriesMetadata = (RepositoriesMetadata)state.getMetadata().custom("repositories");
        if (repositoriesMetadata == null || repositoriesMetadata.repository(repositoryName) == null) {
            throw new RepositoryMissingException(repositoryName);
        }
        SnapshotsService.validate(repositoryName, snapshotName);
    }

    private static void validate(String repositoryName, String snapshotName) {
        if (!Strings.hasLength(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "cannot be empty");
        }
        if (snapshotName.contains(" ")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain whitespace");
        }
        if (snapshotName.contains(",")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain ','");
        }
        if (snapshotName.contains("#")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain '#'");
        }
        if (snapshotName.charAt(0) == '_') {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not start with '_'");
        }
        if (!snapshotName.toLowerCase(Locale.ROOT).equals(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must be lowercase");
        }
        if (!Strings.validFileName(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain the following characters " + String.valueOf(Strings.INVALID_FILENAME_CHARS));
        }
    }

    private static ShardGenerations buildGenerations(SnapshotsInProgress.Entry snapshot, Metadata metadata) {
        ShardGenerations.Builder builder = ShardGenerations.builder();
        HashMap indexLookup = new HashMap();
        snapshot.indices().forEach(idx -> indexLookup.put(idx.getName(), idx));
        if (snapshot.isClone()) {
            snapshot.clones().forEach((id, status) -> {
                IndexId indexId = (IndexId)indexLookup.get(id.indexName());
                builder.put(indexId, id.shardId(), status.generation());
            });
        } else {
            snapshot.shards().forEach((id, status) -> {
                if (metadata.index(id.getIndex()) == null) {
                    assert (snapshot.partial()) : "Index [" + String.valueOf(id.getIndex()) + "] was deleted during a snapshot but snapshot was not partial.";
                    return;
                }
                IndexId indexId = (IndexId)indexLookup.get(id.getIndexName());
                if (indexId != null) {
                    builder.put(indexId, id.id(), status.generation());
                }
            });
        }
        return builder.build();
    }

    private static Metadata metadataForSnapshot(SnapshotsInProgress.Entry snapshot, Metadata metadata) {
        Metadata.Builder builder;
        if (!snapshot.includeGlobalState()) {
            builder = Metadata.builder();
            for (IndexId index : snapshot.indices()) {
                IndexMetadata indexMetadata = metadata.index(index.getName());
                if (indexMetadata == null) {
                    assert (snapshot.partial()) : "Index [" + String.valueOf(index) + "] was deleted during a snapshot but snapshot was not partial.";
                    continue;
                }
                builder.put(indexMetadata, false);
            }
        } else {
            builder = Metadata.builder(metadata);
        }
        HashMap<String, DataStream> dataStreams = new HashMap<String, DataStream>();
        for (String dataStreamName : snapshot.dataStreams()) {
            DataStream dataStream = metadata.dataStreams().get(dataStreamName);
            if (dataStream == null) {
                assert (snapshot.partial()) : "Data stream [" + dataStreamName + "] was deleted during a snapshot but snapshot was not partial.";
                continue;
            }
            dataStreams.put(dataStreamName, dataStream);
        }
        return builder.dataStreams(dataStreams).build();
    }

    public static List<SnapshotsInProgress.Entry> currentSnapshots(@Nullable SnapshotsInProgress snapshotsInProgress, String repository, List<String> snapshots) {
        if (snapshotsInProgress == null || snapshotsInProgress.entries().isEmpty()) {
            return Collections.emptyList();
        }
        if ("_all".equals(repository)) {
            return snapshotsInProgress.entries();
        }
        if (snapshotsInProgress.entries().size() == 1) {
            SnapshotsInProgress.Entry entry = snapshotsInProgress.entries().get(0);
            if (!entry.snapshot().getRepository().equals(repository)) {
                return Collections.emptyList();
            }
            if (!snapshots.isEmpty()) {
                for (String snapshot : snapshots) {
                    if (!entry.snapshot().getSnapshotId().getName().equals(snapshot)) continue;
                    return snapshotsInProgress.entries();
                }
                return Collections.emptyList();
            }
            return snapshotsInProgress.entries();
        }
        ArrayList<SnapshotsInProgress.Entry> builder = new ArrayList<SnapshotsInProgress.Entry>();
        block1: for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
            if (!entry.snapshot().getRepository().equals(repository)) continue;
            if (!snapshots.isEmpty()) {
                for (String snapshot : snapshots) {
                    if (!entry.snapshot().getSnapshotId().getName().equals(snapshot)) continue;
                    builder.add(entry);
                    continue block1;
                }
                continue;
            }
            builder.add(entry);
        }
        return Collections.unmodifiableList(builder);
    }

    @Override
    public void applyClusterState(ClusterStateChangedEvent event) {
        try {
            if (event.localNodeClusterManager()) {
                SnapshotsInProgress snapshotsInProgress = event.state().custom("snapshots", SnapshotsInProgress.EMPTY);
                boolean newClusterManager = !event.previousState().nodes().isLocalNodeElectedClusterManager();
                this.processExternalChanges(newClusterManager || SnapshotsService.removedNodesCleanupNeeded(snapshotsInProgress, event.nodesDelta().removedNodes()), event.routingTableChanged() && SnapshotsService.waitingShardsStartedOrUnassigned(snapshotsInProgress, event));
            } else if (!this.snapshotCompletionListeners.isEmpty()) {
                for (Snapshot snapshot : new HashSet<Snapshot>(this.snapshotCompletionListeners.keySet())) {
                    if (!this.endingSnapshots.add(snapshot)) continue;
                    this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "no longer cluster-manager"));
                }
            }
        }
        catch (Exception e) {
            assert (false) : new AssertionError((Object)e);
            logger.warn("Failed to update snapshot state ", (Throwable)e);
        }
        assert (this.assertConsistentWithClusterState(event.state()));
        assert (SnapshotsService.assertNoDanglingSnapshots(event.state()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assertConsistentWithClusterState(ClusterState state) {
        SnapshotDeletionsInProgress snapshotDeletionsInProgress;
        SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        if (!snapshotsInProgress.entries().isEmpty()) {
            Set<Snapshot> set = this.endingSnapshots;
            synchronized (set) {
                Set runningSnapshots = Stream.concat(snapshotsInProgress.entries().stream().map(SnapshotsInProgress.Entry::snapshot), this.endingSnapshots.stream()).collect(Collectors.toSet());
                Set<Snapshot> snapshotListenerKeys = this.snapshotCompletionListeners.keySet();
                assert (runningSnapshots.containsAll(snapshotListenerKeys)) : "Saw completion listeners for unknown snapshots in " + String.valueOf(snapshotListenerKeys) + " but running snapshots are " + String.valueOf(runningSnapshots);
            }
        }
        if ((snapshotDeletionsInProgress = state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY)).hasDeletionsInProgress()) {
            Set<String> set = this.repositoryOperations.runningDeletions;
            synchronized (set) {
                Set runningDeletes = Stream.concat(snapshotDeletionsInProgress.getEntries().stream().map(SnapshotDeletionsInProgress.Entry::uuid), this.repositoryOperations.runningDeletions.stream()).collect(Collectors.toSet());
                Set<String> deleteListenerKeys = this.snapshotDeletionListeners.keySet();
                assert (runningDeletes.containsAll(deleteListenerKeys)) : "Saw deletions listeners for unknown uuids in " + String.valueOf(deleteListenerKeys) + " but running deletes are " + String.valueOf(runningDeletes);
            }
        }
        return true;
    }

    private static boolean assertNoDanglingSnapshots(ClusterState state) {
        SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        SnapshotDeletionsInProgress snapshotDeletionsInProgress = state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
        Set reposWithRunningDelete = snapshotDeletionsInProgress.getEntries().stream().filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.STARTED).map(SnapshotDeletionsInProgress.Entry::repository).collect(Collectors.toSet());
        HashSet<String> reposSeen = new HashSet<String>();
        for (SnapshotsInProgress.Entry entry2 : snapshotsInProgress.entries()) {
            if (!reposSeen.add(entry2.repository())) continue;
            for (SnapshotsInProgress.ShardSnapshotStatus status : entry2.shards().values()) {
                if (status.equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED)) assert (reposWithRunningDelete.contains(entry2.repository())) : "Found shard snapshot waiting to be assigned in [" + String.valueOf(entry2) + "] but it is not blocked by any running delete";
            }
        }
        return true;
    }

    private void processExternalChanges(final boolean changedNodes, boolean startShards) {
        if (!changedNodes && !startShards) {
            return;
        }
        this.clusterService.submitStateUpdateTask("update snapshot after shards started [" + startShards + "] or node configuration changed [" + changedNodes + "]", new ClusterStateUpdateTask(){
            private final Collection<SnapshotsInProgress.Entry> finishedSnapshots = new ArrayList<SnapshotsInProgress.Entry>();
            private final Collection<SnapshotDeletionsInProgress.Entry> deletionsToExecute = new ArrayList<SnapshotDeletionsInProgress.Entry>();

            @Override
            public ClusterState execute(ClusterState currentState) {
                RoutingTable routingTable = currentState.routingTable();
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                DiscoveryNodes nodes = currentState.nodes();
                boolean changed = false;
                EnumSet<SnapshotsInProgress.State> statesToUpdate = changedNodes ? EnumSet.of(SnapshotsInProgress.State.STARTED, SnapshotsInProgress.State.ABORTED) : EnumSet.of(SnapshotsInProgress.State.STARTED);
                ArrayList<SnapshotsInProgress.Entry> updatedSnapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
                HashMap<String, Map> knownFailures = new HashMap<String, Map>();
                for (SnapshotsInProgress.Entry snapshot : snapshots.entries()) {
                    if (statesToUpdate.contains((Object)snapshot.state())) {
                        if (snapshot.isClone() && snapshot.clones().isEmpty()) {
                            if (SnapshotsService.this.initializingClones.contains(snapshot.snapshot())) {
                                updatedSnapshotEntries.add(snapshot);
                                continue;
                            }
                            logger.debug("removing not yet start clone operation [{}]", (Object)snapshot);
                            changed = true;
                            continue;
                        }
                        Map<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = SnapshotsService.processWaitingShardsAndRemovedNodes(snapshot.shards(), routingTable, nodes, knownFailures.computeIfAbsent(snapshot.repository(), k -> new HashMap()));
                        if (shards != null) {
                            SnapshotsInProgress.Entry updatedSnapshot = snapshot.withShardStates(shards);
                            changed = true;
                            if (updatedSnapshot.state().completed()) {
                                this.finishedSnapshots.add(updatedSnapshot);
                            }
                            updatedSnapshotEntries.add(updatedSnapshot);
                            continue;
                        }
                        updatedSnapshotEntries.add(snapshot);
                        continue;
                    }
                    if (snapshot.repositoryStateId() == -2L) {
                        changed = true;
                        logger.debug("[{}] was found in dangling INIT or ABORTED state", (Object)snapshot);
                        continue;
                    }
                    if (snapshot.state().completed() || SnapshotsInProgress.completed(snapshot.shards().values())) {
                        this.finishedSnapshots.add(snapshot);
                    }
                    updatedSnapshotEntries.add(snapshot);
                }
                ClusterState res = (ClusterState)SnapshotsService.readyDeletions(changed ? ClusterState.builder(currentState).putCustom("snapshots", SnapshotsInProgress.of(Collections.unmodifiableList(updatedSnapshotEntries))).build() : currentState).v1();
                for (SnapshotDeletionsInProgress.Entry delete : res.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries()) {
                    if (delete.state() != SnapshotDeletionsInProgress.State.STARTED) continue;
                    this.deletionsToExecute.add(delete);
                }
                return res;
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to update snapshot state after shards started or nodes removed from [{}] ", (Object)source), (Throwable)e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                SnapshotDeletionsInProgress snapshotDeletionsInProgress = newState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                if (!this.finishedSnapshots.isEmpty()) {
                    Set reposWithRunningDeletes = snapshotDeletionsInProgress.getEntries().stream().filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.STARTED).map(SnapshotDeletionsInProgress.Entry::repository).collect(Collectors.toSet());
                    for (SnapshotsInProgress.Entry entry2 : this.finishedSnapshots) {
                        if (reposWithRunningDeletes.contains(entry2.repository())) continue;
                        SnapshotsService.this.endSnapshot(entry2, newState.metadata(), null);
                    }
                }
                SnapshotsService.this.startExecutableClones(newState.custom("snapshots", SnapshotsInProgress.EMPTY), null);
                for (SnapshotDeletionsInProgress.Entry entry3 : this.deletionsToExecute) {
                    if (!SnapshotsService.this.tryEnterRepoLoop(entry3.repository())) continue;
                    SnapshotsService.this.deleteSnapshotsFromRepository(entry3, newState.nodes().getMinNodeVersion());
                }
            }
        });
    }

    private static Map<ShardId, SnapshotsInProgress.ShardSnapshotStatus> processWaitingShardsAndRemovedNodes(Map<ShardId, SnapshotsInProgress.ShardSnapshotStatus> snapshotShards, RoutingTable routingTable, DiscoveryNodes nodes, Map<ShardId, SnapshotsInProgress.ShardSnapshotStatus> knownFailures) {
        boolean snapshotChanged = false;
        HashMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = new HashMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus>();
        for (Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardEntry : snapshotShards.entrySet()) {
            SnapshotsInProgress.ShardSnapshotStatus shardStatus = shardEntry.getValue();
            ShardId shardId = shardEntry.getKey();
            if (shardStatus.equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED)) {
                SnapshotsInProgress.ShardSnapshotStatus knownFailure = knownFailures.get(shardId);
                if (knownFailure == null) {
                    shards.put(shardId, shardStatus);
                    continue;
                }
                snapshotChanged = true;
                shards.put(shardId, knownFailure);
                continue;
            }
            if (shardStatus.state() == SnapshotsInProgress.ShardState.WAITING) {
                IndexShardRoutingTable shardRouting;
                IndexRoutingTable indexShardRoutingTable = routingTable.index(shardId.getIndex());
                if (indexShardRoutingTable != null && (shardRouting = indexShardRoutingTable.shard(shardId.id())) != null && shardRouting.primaryShard() != null) {
                    if (shardRouting.primaryShard().started()) {
                        snapshotChanged = true;
                        logger.trace("starting shard that we were waiting for [{}] on node [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                        shards.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(shardRouting.primaryShard().currentNodeId(), shardStatus.generation()));
                        continue;
                    }
                    if (shardRouting.primaryShard().initializing() || shardRouting.primaryShard().relocating()) {
                        shards.put(shardId, shardStatus);
                        continue;
                    }
                }
                snapshotChanged = true;
                logger.warn("failing snapshot of shard [{}] on unassigned shard [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                SnapshotsInProgress.ShardSnapshotStatus failedState = new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, "shard is unassigned", shardStatus.generation());
                shards.put(shardId, failedState);
                knownFailures.put(shardId, failedState);
                continue;
            }
            if (!shardStatus.state().completed() && shardStatus.nodeId() != null) {
                if (nodes.nodeExists(shardStatus.nodeId())) {
                    shards.put(shardId, shardStatus);
                    continue;
                }
                snapshotChanged = true;
                logger.warn("failing snapshot of shard [{}] on closed node [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                SnapshotsInProgress.ShardSnapshotStatus failedState = new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, "node shutdown", shardStatus.generation());
                shards.put(shardId, failedState);
                knownFailures.put(shardId, failedState);
                continue;
            }
            shards.put(shardId, shardStatus);
        }
        if (snapshotChanged) {
            return Collections.unmodifiableMap(shards);
        }
        return null;
    }

    private static boolean waitingShardsStartedOrUnassigned(SnapshotsInProgress snapshotsInProgress, ClusterStateChangedEvent event) {
        for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
            if (entry.state() != SnapshotsInProgress.State.STARTED) continue;
            for (Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardStatus : entry.shards().entrySet()) {
                ShardId shardId;
                if (shardStatus.getValue().state() != SnapshotsInProgress.ShardState.WAITING || !event.indexRoutingTableChanged((shardId = shardStatus.getKey()).getIndexName())) continue;
                IndexRoutingTable indexShardRoutingTable = event.state().getRoutingTable().index(shardId.getIndex());
                if (indexShardRoutingTable == null) {
                    return true;
                }
                ShardRouting shardRouting = indexShardRoutingTable.shard(shardId.id()).primaryShard();
                if (shardRouting == null || !shardRouting.started() && !shardRouting.unassigned()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean removedNodesCleanupNeeded(SnapshotsInProgress snapshotsInProgress, List<DiscoveryNode> removedNodes) {
        if (removedNodes.isEmpty()) {
            return false;
        }
        Set removedNodeIds = removedNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
        return snapshotsInProgress.entries().stream().anyMatch(snapshot -> {
            if (snapshot.state().completed()) {
                return false;
            }
            for (SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus : snapshot.shards().values()) {
                if (shardSnapshotStatus.state().completed() || !removedNodeIds.contains(shardSnapshotStatus.nodeId())) continue;
                return true;
            }
            return false;
        });
    }

    private void endSnapshot(final SnapshotsInProgress.Entry entry, final Metadata metadata, @Nullable RepositoryData repositoryData) {
        Snapshot snapshot = entry.snapshot();
        boolean newFinalization = this.endingSnapshots.add(snapshot);
        if (entry.repositoryStateId() == -2L) {
            logger.debug("[{}] was aborted before starting", (Object)snapshot);
            this.removeFailedSnapshotFromClusterState(entry.snapshot(), new SnapshotException(snapshot, "Aborted on initialization"), repositoryData, null);
            return;
        }
        if (entry.isClone() && entry.state() == SnapshotsInProgress.State.FAILED) {
            logger.debug("Removing failed snapshot clone [{}] from cluster state", (Object)entry);
            this.removeFailedSnapshotFromClusterState(entry.snapshot(), new SnapshotException(entry.snapshot(), entry.failure()), null, null);
            return;
        }
        final String repoName = entry.repository();
        if (this.tryEnterRepoLoop(repoName)) {
            if (repositoryData == null) {
                this.repositoriesService.repository(repoName).getRepositoryData(new ActionListener<RepositoryData>(){

                    public void onResponse(RepositoryData repositoryData) {
                        SnapshotsService.this.finalizeSnapshotEntry(entry, metadata, repositoryData);
                    }

                    public void onFailure(Exception e) {
                        SnapshotsService.this.clusterService.submitStateUpdateTask("fail repo tasks for [" + repoName + "]", new FailPendingRepoTasksTask(repoName, e));
                    }
                });
            } else {
                this.finalizeSnapshotEntry(entry, metadata, repositoryData);
            }
        } else if (newFinalization) {
            this.repositoryOperations.addFinalization(entry, metadata);
        }
    }

    private boolean tryEnterRepoLoop(String repository) {
        return this.currentlyFinalizing.add(repository);
    }

    private void leaveRepoLoop(String repository) {
        boolean removed = this.currentlyFinalizing.remove(repository);
        assert (removed);
    }

    private void finalizeSnapshotEntry(SnapshotsInProgress.Entry entry, Metadata metadata, RepositoryData repositoryData) {
        assert (this.currentlyFinalizing.contains(entry.repository()));
        try {
            String failure = entry.failure();
            Snapshot snapshot = entry.snapshot();
            logger.trace("[{}] finalizing snapshot in repository, state: [{}], failure[{}]", (Object)snapshot, (Object)entry.state(), (Object)failure);
            ArrayList<SnapshotShardFailure> shardFailures = new ArrayList<SnapshotShardFailure>();
            for (Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardStatus : entry.shards().entrySet()) {
                ShardId shardId = shardStatus.getKey();
                SnapshotsInProgress.ShardSnapshotStatus status = shardStatus.getValue();
                SnapshotsInProgress.ShardState state = status.state();
                if (state.failed()) {
                    shardFailures.add(new SnapshotShardFailure(status.nodeId(), shardId, status.reason()));
                    continue;
                }
                if (!state.completed()) {
                    shardFailures.add(new SnapshotShardFailure(status.nodeId(), shardId, "skipped"));
                    continue;
                }
                assert (state == SnapshotsInProgress.ShardState.SUCCESS);
            }
            ShardGenerations shardGenerations = SnapshotsService.buildGenerations(entry, metadata);
            String repository = snapshot.getRepository();
            SnapshotInfo snapshotInfo = new SnapshotInfo(snapshot.getSnapshotId(), shardGenerations.indices().stream().map(IndexId::getName).collect(Collectors.toList()), entry.dataStreams(), entry.startTime(), failure, this.threadPool.absoluteTimeInMillis(), entry.partial() ? shardGenerations.totalShards() : entry.shards().size(), shardFailures, entry.includeGlobalState(), entry.userMetadata(), entry.remoteStoreIndexShallowCopy());
            StepListener metadataListener = new StepListener();
            Repository repo = this.repositoriesService.repository(snapshot.getRepository());
            if (entry.isClone()) {
                this.threadPool.executor("snapshot").execute((Runnable)ActionRunnable.supply(metadataListener, () -> {
                    Metadata.Builder metaBuilder = Metadata.builder(repo.getSnapshotGlobalMetadata(entry.source()));
                    for (IndexId index : entry.indices()) {
                        metaBuilder.put(repo.getSnapshotIndexMetaData(repositoryData, entry.source(), index), false);
                    }
                    return metaBuilder.build();
                }));
            } else {
                metadataListener.onResponse(metadata);
            }
            metadataListener.whenComplete(meta -> repo.finalizeSnapshot(shardGenerations, repositoryData.getGenId(), SnapshotsService.metadataForSnapshot(entry, meta), snapshotInfo, entry.version(), state -> SnapshotsService.stateWithoutSnapshot(state, snapshot), ActionListenerHelper.wrap(newRepoData -> {
                SnapshotsService.completeListenersIgnoringException(this.endAndGetListenersToResolve(snapshot), Tuple.tuple((Object)newRepoData, (Object)snapshotInfo));
                logger.info("snapshot [{}] completed with state [{}]", (Object)snapshot, (Object)snapshotInfo.state());
                this.runNextQueuedOperation((RepositoryData)newRepoData, repository, true);
            }, e -> this.handleFinalizationFailure((Exception)e, entry, repositoryData))), e -> this.handleFinalizationFailure((Exception)e, entry, repositoryData));
        }
        catch (Exception e2) {
            assert (false) : new AssertionError((Object)e2);
            this.handleFinalizationFailure(e2, entry, repositoryData);
        }
    }

    private List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>> endAndGetListenersToResolve(Snapshot snapshot) {
        List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>> listenersToComplete = this.snapshotCompletionListeners.remove(snapshot);
        this.endingSnapshots.remove(snapshot);
        return listenersToComplete;
    }

    private void handleFinalizationFailure(Exception e, SnapshotsInProgress.Entry entry, RepositoryData repositoryData) {
        Snapshot snapshot = entry.snapshot();
        if (SkyliteExceptionsHelper.unwrap(e, NotClusterManagerException.class, FailedToCommitClusterStateException.class) != null) {
            logger.debug(() -> new ParameterizedMessage("[{}] failed to update cluster state during snapshot finalization", (Object)snapshot), (Throwable)e);
            this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Failed to update cluster state during snapshot finalization", e));
            this.failAllListenersOnMasterFailOver(e);
        } else {
            logger.warn(() -> new ParameterizedMessage("[{}] failed to finalize snapshot", (Object)snapshot), (Throwable)e);
            this.removeFailedSnapshotFromClusterState(snapshot, e, repositoryData, null);
        }
    }

    private void runNextQueuedOperation(RepositoryData repositoryData, String repository, boolean attemptDelete) {
        assert (this.currentlyFinalizing.contains(repository));
        Tuple<SnapshotsInProgress.Entry, Metadata> nextFinalization = this.repositoryOperations.pollFinalization(repository);
        if (nextFinalization == null) {
            if (attemptDelete) {
                this.runReadyDeletions(repositoryData, repository);
            } else {
                this.leaveRepoLoop(repository);
            }
        } else {
            logger.trace("Moving on to finalizing next snapshot [{}]", nextFinalization);
            this.finalizeSnapshotEntry((SnapshotsInProgress.Entry)nextFinalization.v1(), (Metadata)nextFinalization.v2(), repositoryData);
        }
    }

    private void runReadyDeletions(final RepositoryData repositoryData, final String repository) {
        this.clusterService.submitStateUpdateTask("Run ready deletions", new ClusterStateUpdateTask(){
            private SnapshotDeletionsInProgress.Entry deletionToRun;

            @Override
            public ClusterState execute(ClusterState currentState) {
                assert (SnapshotsService.readyDeletions(currentState).v1() == currentState) : "Deletes should have been set to ready by finished snapshot deletes and finalizations";
                for (SnapshotDeletionsInProgress.Entry entry : currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries()) {
                    if (!entry.repository().equals(repository) || entry.state() != SnapshotDeletionsInProgress.State.STARTED) continue;
                    this.deletionToRun = entry;
                    break;
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn("Failed to run ready delete operations", (Throwable)e);
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.deletionToRun == null) {
                    SnapshotsService.this.runNextQueuedOperation(repositoryData, repository, false);
                } else {
                    SnapshotsService.this.deleteSnapshotsFromRepository(this.deletionToRun, repositoryData, newState.nodes().getMinNodeVersion());
                }
            }
        });
    }

    private static Tuple<ClusterState, List<SnapshotDeletionsInProgress.Entry>> readyDeletions(ClusterState currentState) {
        SnapshotDeletionsInProgress deletions = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
        if (!deletions.hasDeletionsInProgress()) {
            return Tuple.tuple((Object)currentState, Collections.emptyList());
        }
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)currentState.custom("snapshots");
        assert (snapshotsInProgress != null);
        HashSet<String> repositoriesSeen = new HashSet<String>();
        boolean changed = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> readyDeletions = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        ArrayList<SnapshotDeletionsInProgress.Entry> newDeletes = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        for (SnapshotDeletionsInProgress.Entry entry : deletions.getEntries()) {
            String repo = entry.repository();
            if (repositoriesSeen.add(entry.repository()) && entry.state() == SnapshotDeletionsInProgress.State.WAITING && snapshotsInProgress.entries().stream().filter(se -> se.repository().equals(repo)).noneMatch(SnapshotsService::isWritingToRepository)) {
                changed = true;
                SnapshotDeletionsInProgress.Entry newEntry = entry.started();
                readyDeletions.add(newEntry);
                newDeletes.add(newEntry);
                continue;
            }
            newDeletes.add(entry);
        }
        return Tuple.tuple((Object)(changed ? ClusterState.builder(currentState).putCustom("snapshot_deletions", SnapshotDeletionsInProgress.of(newDeletes)).build() : currentState), readyDeletions);
    }

    private static ClusterState stateWithoutSnapshot(ClusterState state, Snapshot snapshot) {
        SnapshotsInProgress snapshots = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        ClusterState result = state;
        boolean changed = false;
        ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
        for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
            if (entry.snapshot().equals(snapshot)) {
                changed = true;
                continue;
            }
            entries.add(entry);
        }
        if (changed) {
            result = ClusterState.builder(state).putCustom("snapshots", SnapshotsInProgress.of(Collections.unmodifiableList(entries))).build();
        }
        return (ClusterState)SnapshotsService.readyDeletions(result).v1();
    }

    private void removeFailedSnapshotFromClusterState(final Snapshot snapshot, final Exception failure, final @Nullable RepositoryData repositoryData, final @Nullable CleanupAfterErrorListener listener) {
        assert (failure != null) : "Failure must be supplied";
        this.clusterService.submitStateUpdateTask("remove snapshot metadata", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                ClusterState updatedState = SnapshotsService.stateWithoutSnapshot(currentState, snapshot);
                return SnapshotsService.updateWithSnapshots(updatedState, null, SnapshotsService.deletionsWithoutSnapshots(updatedState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY), Collections.singletonList(snapshot.getSnapshotId()), snapshot.getRepository()));
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] failed to remove snapshot metadata", (Object)snapshot), (Throwable)e);
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Failed to remove snapshot from cluster state", e));
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
                if (listener != null) {
                    listener.onFailure(e);
                }
            }

            @Override
            public void onNoLongerClusterManager(String source) {
                failure.addSuppressed(new SnapshotException(snapshot, "no longer cluster-manager"));
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, failure);
                SnapshotsService.this.failAllListenersOnMasterFailOver(new NotClusterManagerException(source));
                if (listener != null) {
                    listener.onNoLongerClusterManager();
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, failure);
                if (listener == null) {
                    if (repositoryData != null) {
                        SnapshotsService.this.runNextQueuedOperation(repositoryData, snapshot.getRepository(), true);
                    }
                } else {
                    listener.onFailure(null);
                }
            }
        });
    }

    @Nullable
    private static SnapshotDeletionsInProgress deletionsWithoutSnapshots(SnapshotDeletionsInProgress deletions, Collection<SnapshotId> snapshotIds, String repository) {
        boolean changed = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> updatedEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>(deletions.getEntries().size());
        for (SnapshotDeletionsInProgress.Entry entry : deletions.getEntries()) {
            if (entry.repository().equals(repository)) {
                ArrayList<SnapshotId> updatedSnapshotIds = new ArrayList<SnapshotId>(entry.getSnapshots());
                if (updatedSnapshotIds.removeAll(snapshotIds)) {
                    changed = true;
                    updatedEntries.add(entry.withSnapshots(updatedSnapshotIds));
                    continue;
                }
                updatedEntries.add(entry);
                continue;
            }
            updatedEntries.add(entry);
        }
        return changed ? SnapshotDeletionsInProgress.of(updatedEntries) : null;
    }

    private void failSnapshotCompletionListeners(Snapshot snapshot, Exception e) {
        SnapshotsService.failListenersIgnoringException(this.endAndGetListenersToResolve(snapshot), e);
        assert (this.repositoryOperations.assertNotQueued(snapshot));
    }

    public void deleteSnapshots(DeleteSnapshotRequest request, ActionListener<Void> listener) {
        final String[] snapshotNames = request.snapshots();
        final String repoName = request.repository();
        logger.info(() -> new ParameterizedMessage("deleting snapshots [{}] from repository [{}]", (Object)Strings.arrayToCommaDelimitedString(snapshotNames), (Object)repoName));
        Repository repository = this.repositoriesService.repository(repoName);
        repository.executeConsistentStateUpdate(repositoryData -> new ClusterStateUpdateTask(Priority.NORMAL, (RepositoryData)repositoryData, (ActionListener)listener, request){
            private Snapshot runningSnapshot;
            private ClusterStateUpdateTask deleteFromRepoTask;
            private boolean abortedDuringInit;
            private List<SnapshotId> outstandingDeletes;
            final /* synthetic */ RepositoryData val$repositoryData;
            final /* synthetic */ ActionListener val$listener;
            final /* synthetic */ DeleteSnapshotRequest val$request;
            {
                this.val$repositoryData = repositoryData;
                this.val$listener = actionListener;
                this.val$request = deleteSnapshotRequest;
                super(priority);
                this.abortedDuringInit = false;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                List<SnapshotsInProgress.Entry> snapshotEntries = SnapshotsService.findInProgressSnapshots(snapshots, snapshotNames, repoName);
                List<SnapshotId> snapshotIds = SnapshotsService.matchingSnapshotIds(snapshotEntries.stream().map(e -> e.snapshot().getSnapshotId()).collect(Collectors.toList()), this.val$repositoryData, snapshotNames, repoName);
                SnapshotUtils.validateSnapshotsBackingAnyIndex(currentState.getMetadata().getIndices(), snapshotIds, repoName);
                this.deleteFromRepoTask = SnapshotsService.this.createDeleteStateUpdate(snapshotIds, repoName, this.val$repositoryData, Priority.NORMAL, (ActionListener<Void>)this.val$listener);
                return this.deleteFromRepoTask.execute(currentState);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return SnapshotsService.this.deleteSnapshotTaskKey;
            }

            @Override
            public void onFailure(String source, Exception e) {
                this.val$listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.deleteFromRepoTask != null) {
                    assert (this.outstandingDeletes == null) : "Shouldn't have outstanding deletes after already starting delete task";
                    this.deleteFromRepoTask.clusterStateProcessed(source, oldState, newState);
                    return;
                }
                if (this.abortedDuringInit) {
                    logger.info("Successfully aborted snapshot [{}]", (Object)this.runningSnapshot);
                    if (this.outstandingDeletes.isEmpty()) {
                        this.val$listener.onResponse(null);
                    } else {
                        SnapshotsService.this.clusterService.submitStateUpdateTask("delete snapshot", SnapshotsService.this.createDeleteStateUpdate(this.outstandingDeletes, repoName, this.val$repositoryData, Priority.IMMEDIATE, (ActionListener<Void>)this.val$listener));
                    }
                    return;
                }
                logger.trace("adding snapshot completion listener to wait for deleted snapshot to finish");
                SnapshotsService.this.addListener(this.runningSnapshot, ActionListenerHelper.wrap(result -> {
                    logger.debug("deleted snapshot completed - deleting files");
                    SnapshotsService.this.clusterService.submitStateUpdateTask("delete snapshot", SnapshotsService.this.createDeleteStateUpdate(this.outstandingDeletes, repoName, (RepositoryData)result.v1(), Priority.IMMEDIATE, (ActionListener<Void>)this.val$listener));
                }, e -> {
                    if (SkyliteExceptionsHelper.unwrap(e, NotClusterManagerException.class, FailedToCommitClusterStateException.class) != null) {
                        logger.warn("cluster-manager failover before deleted snapshot could complete", (Throwable)e);
                        this.val$listener.onFailure(e);
                    } else {
                        logger.warn("deleted snapshot failed", (Throwable)e);
                        this.val$listener.onFailure((Exception)new SnapshotMissingException(this.runningSnapshot.getRepository(), this.runningSnapshot.getSnapshotId(), (Throwable)e));
                    }
                }));
            }

            @Override
            public TimeValue timeout() {
                return this.val$request.clusterManagerNodeTimeout();
            }
        }, "delete snapshot", arg_0 -> listener.onFailure(arg_0));
    }

    private static List<SnapshotId> matchingSnapshotIds(List<SnapshotId> inProgress, RepositoryData repositoryData, String[] snapshotsOrPatterns, String repositoryName) {
        Map allSnapshotIds = repositoryData.getSnapshotIds().stream().collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
        HashSet<SnapshotId> foundSnapshots = new HashSet<SnapshotId>(inProgress);
        for (String snapshotOrPattern : snapshotsOrPatterns) {
            if (Regex.isSimpleMatchPattern(snapshotOrPattern)) {
                for (Map.Entry entry : allSnapshotIds.entrySet()) {
                    if (!Regex.simpleMatch(snapshotOrPattern, entry.getKey())) continue;
                    foundSnapshots.add((SnapshotId)entry.getValue());
                }
                continue;
            }
            SnapshotId foundId = (SnapshotId)allSnapshotIds.get(snapshotOrPattern);
            if (foundId == null) {
                if (!inProgress.stream().noneMatch(snapshotId -> snapshotId.getName().equals(snapshotOrPattern))) continue;
                throw new SnapshotMissingException(repositoryName, snapshotOrPattern);
            }
            foundSnapshots.add((SnapshotId)allSnapshotIds.get(snapshotOrPattern));
        }
        return Collections.unmodifiableList(new ArrayList<SnapshotId>(foundSnapshots));
    }

    private static List<SnapshotsInProgress.Entry> findInProgressSnapshots(SnapshotsInProgress snapshots, String[] snapshotNames, String repositoryName) {
        ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
        for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
            if (!entry.repository().equals(repositoryName) || !Regex.simpleMatch(snapshotNames, entry.snapshot().getSnapshotId().getName())) continue;
            entries.add(entry);
        }
        return entries;
    }

    private ClusterStateUpdateTask createDeleteStateUpdate(final List<SnapshotId> snapshotIds, final String repoName, final RepositoryData repositoryData, Priority priority, final ActionListener<Void> listener) {
        if (snapshotIds.isEmpty()) {
            return new ClusterStateUpdateTask(this){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return currentState;
                }

                @Override
                public void onFailure(String source, Exception e) {
                    listener.onFailure(e);
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse(null);
                }
            };
        }
        return new ClusterStateUpdateTask(priority){
            private SnapshotDeletionsInProgress.Entry newDelete;
            private boolean reusedExistingDelete;
            private final Collection<Snapshot> completedNoCleanup;
            private final Collection<SnapshotsInProgress.Entry> completedWithCleanup;
            {
                super(priority);
                this.reusedExistingDelete = false;
                this.completedNoCleanup = new ArrayList<Snapshot>();
                this.completedWithCleanup = new ArrayList<SnapshotsInProgress.Entry>();
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                Version minNodeVersion = currentState.nodes().getMinNodeVersion();
                RepositoryCleanupInProgress repositoryCleanupInProgress = currentState.custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY);
                if (repositoryCleanupInProgress.hasCleanupInProgress()) {
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repoName, (SnapshotId)snapshotIds.get(0)), "cannot delete snapshots while a repository cleanup is in-progress in [" + String.valueOf(repositoryCleanupInProgress) + "]");
                }
                RestoreInProgress restoreInProgress = currentState.custom("restore", RestoreInProgress.EMPTY);
                for (RestoreInProgress.Entry entry2 : restoreInProgress) {
                    if (!repoName.equals(entry2.snapshot().getRepository()) || !snapshotIds.contains(entry2.snapshot().getSnapshotId())) continue;
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repoName, (SnapshotId)snapshotIds.get(0)), "cannot delete snapshot during a restore in progress in [" + String.valueOf(restoreInProgress) + "]");
                }
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                Set activeCloneSources = snapshots.entries().stream().filter(SnapshotsInProgress.Entry::isClone).map(SnapshotsInProgress.Entry::source).collect(Collectors.toSet());
                for (SnapshotId snapshotId : snapshotIds) {
                    if (!activeCloneSources.contains(snapshotId)) continue;
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repoName, snapshotId), "cannot delete snapshot while it is being cloned");
                }
                HashSet<SnapshotId> snapshotIdsRequiringCleanup = new HashSet<SnapshotId>(snapshotIds);
                SnapshotsInProgress updatedSnapshots = SnapshotsInProgress.of(snapshots.entries().stream().map(existing -> {
                    if (existing.state() == SnapshotsInProgress.State.STARTED && snapshotIdsRequiringCleanup.contains(existing.snapshot().getSnapshotId())) {
                        SnapshotsInProgress.Entry abortedEntry = existing.abort();
                        if (abortedEntry == null) {
                            Snapshot existingNotYetStartedSnapshot = existing.snapshot();
                            if (SnapshotsService.this.endingSnapshots.add(existingNotYetStartedSnapshot)) {
                                this.completedNoCleanup.add(existingNotYetStartedSnapshot);
                            }
                            snapshotIdsRequiringCleanup.remove(existingNotYetStartedSnapshot.getSnapshotId());
                        } else if (abortedEntry.state().completed()) {
                            this.completedWithCleanup.add(abortedEntry);
                        }
                        return abortedEntry;
                    }
                    return existing;
                }).filter(Objects::nonNull).collect(Collectors.toList()));
                if (snapshotIdsRequiringCleanup.isEmpty()) {
                    return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshots, null);
                }
                SnapshotDeletionsInProgress.Entry replacedEntry = deletionsInProgress.getEntries().stream().filter(entry -> entry.repository().equals(repoName) && entry.state() == SnapshotDeletionsInProgress.State.WAITING).findFirst().orElse(null);
                if (replacedEntry == null) {
                    Optional<SnapshotDeletionsInProgress.Entry> foundDuplicate = deletionsInProgress.getEntries().stream().filter(entry -> entry.repository().equals(repoName) && entry.state() == SnapshotDeletionsInProgress.State.STARTED && entry.getSnapshots().containsAll(snapshotIds)).findFirst();
                    if (foundDuplicate.isPresent()) {
                        this.newDelete = foundDuplicate.get();
                        this.reusedExistingDelete = true;
                        return currentState;
                    }
                    List<SnapshotId> toDelete = Collections.unmodifiableList(new ArrayList<SnapshotId>(snapshotIdsRequiringCleanup));
                    SnapshotsService.this.ensureBelowConcurrencyLimit(repoName, toDelete.get(0).getName(), snapshots, deletionsInProgress);
                    this.newDelete = new SnapshotDeletionsInProgress.Entry(toDelete, repoName, SnapshotsService.this.threadPool.absoluteTimeInMillis(), repositoryData.getGenId(), updatedSnapshots.entries().stream().filter(entry -> repoName.equals(entry.repository())).noneMatch(SnapshotsService::isWritingToRepository) && deletionsInProgress.getEntries().stream().noneMatch(entry -> repoName.equals(entry.repository()) && entry.state() == SnapshotDeletionsInProgress.State.STARTED) ? SnapshotDeletionsInProgress.State.STARTED : SnapshotDeletionsInProgress.State.WAITING);
                } else {
                    this.newDelete = replacedEntry.withAddedSnapshots(snapshotIdsRequiringCleanup);
                }
                return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshots, (replacedEntry == null ? deletionsInProgress : deletionsInProgress.withRemovedEntry(replacedEntry.uuid())).withAddedEntry(this.newDelete));
            }

            @Override
            public void onFailure(String source, Exception e) {
                SnapshotsService.this.endingSnapshots.removeAll(this.completedNoCleanup);
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (!this.completedNoCleanup.isEmpty()) {
                    logger.info("snapshots {} aborted", this.completedNoCleanup);
                }
                for (Snapshot snapshot : this.completedNoCleanup) {
                    SnapshotsService.this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Snapshot was aborted by deletion"));
                }
                if (this.newDelete == null) {
                    listener.onResponse(null);
                } else {
                    SnapshotsService.this.addDeleteListener(this.newDelete.uuid(), (ActionListener<Void>)listener);
                    if (this.reusedExistingDelete) {
                        return;
                    }
                    if (this.newDelete.state() == SnapshotDeletionsInProgress.State.STARTED) {
                        if (SnapshotsService.this.tryEnterRepoLoop(repoName)) {
                            SnapshotsService.this.deleteSnapshotsFromRepository(this.newDelete, repositoryData, newState.nodes().getMinNodeVersion());
                        } else {
                            logger.trace("Delete [{}] could not execute directly and was queued", (Object)this.newDelete);
                        }
                    } else {
                        for (SnapshotsInProgress.Entry completedSnapshot : this.completedWithCleanup) {
                            SnapshotsService.this.endSnapshot(completedSnapshot, newState.metadata(), repositoryData);
                        }
                    }
                }
            }
        };
    }

    private static boolean isWritingToRepository(SnapshotsInProgress.Entry entry) {
        if (entry.state().completed()) {
            return true;
        }
        for (SnapshotsInProgress.ShardSnapshotStatus value : entry.shards().values()) {
            if (!value.isActive()) continue;
            return true;
        }
        return false;
    }

    private void addDeleteListener(String deleteUUID, ActionListener<Void> listener) {
        this.snapshotDeletionListeners.computeIfAbsent(deleteUUID, k -> new CopyOnWriteArrayList()).add(listener);
    }

    public Version minCompatibleVersion(Version minNodeVersion, RepositoryData repositoryData, @Nullable Collection<SnapshotId> excluded) {
        Version minCompatVersion = minNodeVersion;
        Collection<SnapshotId> snapshotIds = repositoryData.getSnapshotIds();
        for (SnapshotId snapshotId : snapshotIds.stream().filter(excluded == null ? sn -> true : sn -> !excluded.contains(sn)).collect(Collectors.toList())) {
            Version known = repositoryData.getVersion(snapshotId);
            minCompatVersion = minCompatVersion.before(known) ? minCompatVersion : known;
        }
        return minCompatVersion;
    }

    private void deleteSnapshotsFromRepository(final SnapshotDeletionsInProgress.Entry deleteEntry, final Version minNodeVersion) {
        final long expectedRepoGen = deleteEntry.repositoryStateId();
        this.repositoriesService.getRepositoryData(deleteEntry.repository(), new ActionListener<RepositoryData>(){

            public void onResponse(RepositoryData repositoryData) {
                assert (repositoryData.getGenId() == expectedRepoGen) : "Repository generation should not change as long as a ready delete is found in the cluster state but found [" + expectedRepoGen + "] in cluster state and [" + repositoryData.getGenId() + "] in the repository";
                SnapshotsService.this.deleteSnapshotsFromRepository(deleteEntry, repositoryData, minNodeVersion);
            }

            public void onFailure(Exception e) {
                SnapshotsService.this.clusterService.submitStateUpdateTask("fail repo tasks for [" + deleteEntry.repository() + "]", new FailPendingRepoTasksTask(deleteEntry.repository(), e));
            }
        });
    }

    private void deleteSnapshotsFromRepository(SnapshotDeletionsInProgress.Entry deleteEntry, RepositoryData repositoryData, Version minNodeVersion) {
        if (this.repositoryOperations.startDeletion(deleteEntry.uuid())) {
            assert (this.currentlyFinalizing.contains(deleteEntry.repository()));
            List<SnapshotId> snapshotIds = deleteEntry.getSnapshots();
            assert (deleteEntry.state() == SnapshotDeletionsInProgress.State.STARTED) : "incorrect state for entry [" + String.valueOf(deleteEntry) + "]";
            Repository repository = this.repositoriesService.repository(deleteEntry.repository());
            boolean cleanupRemoteStoreLockFiles = BlobStoreRepositorySettings.REMOTE_STORE_INDEX_SHALLOW_COPY.get(repository.getMetadata().settings());
            if (cleanupRemoteStoreLockFiles) {
                repository.deleteSnapshotsAndReleaseLockFiles(snapshotIds, repositoryData.getGenId(), this.minCompatibleVersion(minNodeVersion, repositoryData, snapshotIds), this.remoteStoreLockManagerFactory, ActionListenerHelper.wrap(updatedRepoData -> {
                    logger.info("snapshots {} deleted", (Object)snapshotIds);
                    this.removeSnapshotDeletionFromClusterState(deleteEntry, null, (RepositoryData)updatedRepoData);
                }, ex -> this.removeSnapshotDeletionFromClusterState(deleteEntry, (Exception)ex, repositoryData)));
            } else {
                repository.deleteSnapshots(snapshotIds, repositoryData.getGenId(), this.minCompatibleVersion(minNodeVersion, repositoryData, snapshotIds), ActionListenerHelper.wrap(updatedRepoData -> {
                    logger.info("snapshots {} deleted", (Object)snapshotIds);
                    this.removeSnapshotDeletionFromClusterState(deleteEntry, null, (RepositoryData)updatedRepoData);
                }, ex -> this.removeSnapshotDeletionFromClusterState(deleteEntry, (Exception)ex, repositoryData)));
            }
        }
    }

    private void removeSnapshotDeletionFromClusterState(SnapshotDeletionsInProgress.Entry deleteEntry, final @Nullable Exception failure, final RepositoryData repositoryData) {
        RemoveSnapshotDeletionAndContinueTask clusterStateUpdateTask = failure == null ? new RemoveSnapshotDeletionAndContinueTask(this, deleteEntry, repositoryData){

            @Override
            protected SnapshotDeletionsInProgress filterDeletions(SnapshotDeletionsInProgress deletions) {
                SnapshotDeletionsInProgress updatedDeletions = SnapshotsService.deletionsWithoutSnapshots(deletions, this.deleteEntry.getSnapshots(), this.deleteEntry.repository());
                return updatedDeletions == null ? deletions : updatedDeletions;
            }

            @Override
            protected void handleListeners(List<ActionListener<Void>> deleteListeners) {
                assert (repositoryData.getSnapshotIds().stream().noneMatch(this.deleteEntry.getSnapshots()::contains)) : "Repository data contained snapshot ids " + String.valueOf(repositoryData.getSnapshotIds()) + " that should should been deleted by [" + String.valueOf(this.deleteEntry) + "]";
                SnapshotsService.completeListenersIgnoringException(deleteListeners, null);
            }
        } : new RemoveSnapshotDeletionAndContinueTask(this, deleteEntry, repositoryData){

            @Override
            protected void handleListeners(List<ActionListener<Void>> deleteListeners) {
                SnapshotsService.failListenersIgnoringException(deleteListeners, failure);
            }
        };
        this.clusterService.submitStateUpdateTask("remove snapshot deletion metadata", clusterStateUpdateTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failAllListenersOnMasterFailOver(Exception e) {
        logger.debug("Failing all snapshot operation listeners because this node is not cluster-manager any longer", (Throwable)e);
        Set<String> set = this.currentlyFinalizing;
        synchronized (set) {
            if (SkyliteExceptionsHelper.unwrap(e, NotClusterManagerException.class, FailedToCommitClusterStateException.class) != null) {
                this.repositoryOperations.clear();
                for (Snapshot snapshot : new HashSet<Snapshot>(this.snapshotCompletionListeners.keySet())) {
                    this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "no longer cluster-manager"));
                }
                RepositoryException wrapped = new RepositoryException("_all", "Failed to update cluster state during repository operation", e);
                Iterator<List<ActionListener<Void>>> iterator = this.snapshotDeletionListeners.values().iterator();
                while (iterator.hasNext()) {
                    List listeners = iterator.next();
                    iterator.remove();
                    SnapshotsService.failListenersIgnoringException(listeners, wrapped);
                }
                assert (this.snapshotDeletionListeners.isEmpty()) : "No new listeners should have been added but saw " + String.valueOf(this.snapshotDeletionListeners);
            } else {
                assert (false) : new AssertionError("Modifying snapshot state should only ever fail because we failed to publish new state", e);
                logger.error("Unexpected failure during cluster state update", (Throwable)e);
            }
            this.currentlyFinalizing.clear();
        }
    }

    public static ClusterState updateWithSnapshots(ClusterState state, @Nullable SnapshotsInProgress snapshotsInProgress, @Nullable SnapshotDeletionsInProgress snapshotDeletionsInProgress) {
        if (snapshotsInProgress == null && snapshotDeletionsInProgress == null) {
            return state;
        }
        ClusterState.Builder builder = ClusterState.builder(state);
        if (snapshotsInProgress != null) {
            builder.putCustom("snapshots", snapshotsInProgress);
        }
        if (snapshotDeletionsInProgress != null) {
            builder.putCustom("snapshot_deletions", snapshotDeletionsInProgress);
        }
        return builder.build();
    }

    private static <T> void failListenersIgnoringException(@Nullable List<ActionListener<T>> listeners, Exception failure) {
        if (listeners != null) {
            try {
                ActionListenerHelper.onFailure(listeners, failure);
            }
            catch (Exception ex) {
                assert (false) : new AssertionError((Object)ex);
                logger.warn("Failed to notify listeners", (Throwable)ex);
            }
        }
    }

    private static <T> void completeListenersIgnoringException(@Nullable List<ActionListener<T>> listeners, T result) {
        if (listeners != null) {
            try {
                ActionListenerHelper.onResponse(listeners, result);
            }
            catch (Exception ex) {
                assert (false) : new AssertionError((Object)ex);
                logger.warn("Failed to notify listeners", (Throwable)ex);
            }
        }
    }

    private static Map<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards(SnapshotsInProgress snapshotsInProgress, @Nullable SnapshotDeletionsInProgress deletionsInProgress, Metadata metadata, RoutingTable routingTable, List<IndexId> indices, RepositoryData repositoryData, String repoName) {
        HashMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> builder = new HashMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus>();
        ShardGenerations shardGenerations = repositoryData.shardGenerations();
        InFlightShardSnapshotStates inFlightShardStates = InFlightShardSnapshotStates.forRepo(repoName, snapshotsInProgress.entries());
        boolean readyToExecute = deletionsInProgress == null || deletionsInProgress.getEntries().stream().noneMatch(entry -> entry.repository().equals(repoName) && entry.state() == SnapshotDeletionsInProgress.State.STARTED);
        for (IndexId index : indices) {
            String indexName = index.getName();
            boolean isNewIndex = !repositoryData.getIndices().containsKey(indexName);
            IndexMetadata indexMetadata = metadata.index(indexName);
            if (indexMetadata == null) {
                builder.put(new ShardId(indexName, "_na_", 0), SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                continue;
            }
            IndexRoutingTable indexRoutingTable = routingTable.index(indexName);
            for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus;
                String shardRepoGeneration;
                ShardId shardId = indexRoutingTable.shard(i).shardId();
                String inFlightGeneration = inFlightShardStates.generationForShard(index, shardId.id(), shardGenerations);
                if (inFlightGeneration == null && isNewIndex) {
                    assert (shardGenerations.getShardGen(index, shardId.getId()) == null) : "Found shard generation for new index [" + String.valueOf(index) + "]";
                    shardRepoGeneration = "_new";
                } else {
                    shardRepoGeneration = inFlightGeneration;
                }
                if (indexRoutingTable == null) {
                    shardSnapshotStatus = new SnapshotsInProgress.ShardSnapshotStatus(null, SnapshotsInProgress.ShardState.MISSING, "missing routing table", shardRepoGeneration);
                } else {
                    ShardRouting primary = indexRoutingTable.shard(i).primaryShard();
                    shardSnapshotStatus = !readyToExecute || inFlightShardStates.isActive(indexName, i) ? SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED : (primary == null || !primary.assignedToNode() ? new SnapshotsInProgress.ShardSnapshotStatus(null, SnapshotsInProgress.ShardState.MISSING, "primary shard is not allocated", shardRepoGeneration) : (primary.relocating() || primary.initializing() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.WAITING, shardRepoGeneration) : (!primary.started() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.MISSING, "primary shard hasn't been started yet", shardRepoGeneration) : new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), shardRepoGeneration))));
                }
                builder.put(shardId, shardSnapshotStatus);
            }
        }
        return Collections.unmodifiableMap(builder);
    }

    public static Set<String> snapshottingDataStreams(ClusterState currentState, Set<String> dataStreamsToCheck) {
        SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
        if (snapshots == null) {
            return Collections.emptySet();
        }
        Map<String, DataStream> dataStreams = currentState.metadata().dataStreams();
        return snapshots.entries().stream().filter(e -> !e.partial()).flatMap(e -> e.dataStreams().stream()).filter(ds -> dataStreams.containsKey(ds) && dataStreamsToCheck.contains(ds)).collect(Collectors.toSet());
    }

    public static Set<Index> snapshottingIndices(ClusterState currentState, Set<Index> indicesToCheck) {
        SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
        if (snapshots == null) {
            return Collections.emptySet();
        }
        HashSet<Index> indices = new HashSet<Index>();
        for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
            if (entry.partial()) continue;
            for (IndexId index : entry.indices()) {
                IndexMetadata indexMetadata = currentState.metadata().index(index.getName());
                if (indexMetadata == null || !indicesToCheck.contains(indexMetadata.getIndex())) continue;
                indices.add(indexMetadata.getIndex());
            }
        }
        return indices;
    }

    private void addListener(Snapshot snapshot, ActionListener<Tuple<RepositoryData, SnapshotInfo>> listener) {
        this.snapshotCompletionListeners.computeIfAbsent(snapshot, k -> new CopyOnWriteArrayList()).add(listener);
    }

    protected void doStart() {
        assert (this.updateSnapshotStatusHandler != null);
        assert (this.transportService.getRequestHandler(UPDATE_SNAPSHOT_STATUS_ACTION_NAME) != null);
    }

    protected void doStop() {
    }

    protected void doClose() {
        this.clusterService.removeApplier(this);
    }

    public boolean assertAllListenersResolved() {
        DiscoveryNode localNode = this.clusterService.localNode();
        assert (this.endingSnapshots.isEmpty()) : "Found leaked ending snapshots " + String.valueOf(this.endingSnapshots) + " on [" + String.valueOf(localNode) + "]";
        assert (this.snapshotCompletionListeners.isEmpty()) : "Found leaked snapshot completion listeners " + String.valueOf(this.snapshotCompletionListeners) + " on [" + String.valueOf(localNode) + "]";
        assert (this.currentlyFinalizing.isEmpty()) : "Found leaked finalizations " + String.valueOf(this.currentlyFinalizing) + " on [" + String.valueOf(localNode) + "]";
        assert (this.snapshotDeletionListeners.isEmpty()) : "Found leaked snapshot delete listeners " + String.valueOf(this.snapshotDeletionListeners) + " on [" + String.valueOf(localNode) + "]";
        assert (this.repositoryOperations.isEmpty()) : "Found leaked snapshots to finalize " + String.valueOf(this.repositoryOperations) + " on [" + String.valueOf(localNode) + "]";
        return true;
    }

    private static SnapshotsInProgress.ShardSnapshotStatus startShardSnapshotAfterClone(ClusterState currentState, String shardGeneration, ShardId shardId) {
        ShardRouting primary = currentState.routingTable().index(shardId.getIndex()).shard(shardId.id()).primaryShard();
        SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = primary == null || !primary.assignedToNode() ? new SnapshotsInProgress.ShardSnapshotStatus(null, SnapshotsInProgress.ShardState.MISSING, "primary shard is not allocated", shardGeneration) : (primary.relocating() || primary.initializing() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.WAITING, shardGeneration) : (!primary.started() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.MISSING, "primary shard hasn't been started yet", shardGeneration) : new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), shardGeneration)));
        return shardSnapshotStatus;
    }

    private void innerUpdateSnapshotState(final ShardSnapshotUpdate update, final ActionListener<Void> listener) {
        logger.trace("received updated snapshot restore state [{}]", (Object)update);
        this.clusterService.submitStateUpdateTask("update snapshot state", update, ClusterStateTaskConfig.build(Priority.NORMAL), SHARD_STATE_EXECUTOR, new ClusterStateTaskListener(){

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                try {
                    listener.onResponse(null);
                }
                finally {
                    SnapshotsInProgress.Entry updatedEntry;
                    SnapshotsInProgress snapshotsInProgress = newState.custom("snapshots", SnapshotsInProgress.EMPTY);
                    if (!SnapshotsService.this.endingSnapshots.contains(update.snapshot) && (updatedEntry = snapshotsInProgress.snapshot(update.snapshot)) != null && updatedEntry.state().completed()) {
                        SnapshotsService.this.endSnapshot(updatedEntry, newState.metadata(), null);
                    }
                    SnapshotsService.this.startExecutableClones(snapshotsInProgress, update.snapshot.getRepository());
                }
            }
        });
    }

    private void startExecutableClones(SnapshotsInProgress snapshotsInProgress, @Nullable String repoName) {
        for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
            if (!entry.isClone() || entry.state() != SnapshotsInProgress.State.STARTED || repoName != null && !entry.repository().equals(repoName)) continue;
            for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clone : entry.clones().entrySet()) {
                if (clone.getValue().state() != SnapshotsInProgress.ShardState.INIT) continue;
                boolean remoteStoreIndexShallowCopy = Boolean.TRUE.equals(entry.remoteStoreIndexShallowCopy());
                this.runReadyClone(entry.snapshot(), entry.source(), clone.getValue(), clone.getKey(), this.repositoriesService.repository(entry.repository()), remoteStoreIndexShallowCopy);
            }
        }
    }

    static {
        MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING = Setting.intSetting("snapshot.max_concurrent_operations", 1000, 1, Setting.Property.NodeScope, Setting.Property.Dynamic);
        SHARD_STATE_EXECUTOR = new ClusterStateTaskExecutor<ShardSnapshotUpdate>(){

            @Override
            public ClusterStateTaskExecutor.ClusterStateTasksResult<ShardSnapshotUpdate> execute(ClusterState currentState, List<ShardSnapshotUpdate> tasks) throws Exception {
                return shardStateExecutor.execute(currentState, tasks);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return updateSnapshotStateTaskKey;
            }
        };
        shardStateExecutor = (currentState, tasks) -> {
            int changedCount = 0;
            int startedCount = 0;
            ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
            String localNodeId = currentState.nodes().getLocalNodeId();
            ArrayList unconsumedTasks = new ArrayList(tasks);
            HashSet<ShardSnapshotUpdate> executedTasks = new HashSet<ShardSnapshotUpdate>();
            for (SnapshotsInProgress.Entry entry : currentState.custom("snapshots", SnapshotsInProgress.EMPTY).entries()) {
                SnapshotsInProgress.Entry updatedEntry;
                if (entry.state().completed()) {
                    entries.add(entry);
                    continue;
                }
                HashMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = null;
                HashMap<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clones = null;
                Map indicesLookup = null;
                Iterator iterator = unconsumedTasks.iterator();
                while (iterator.hasNext()) {
                    SnapshotsInProgress.ShardSnapshotStatus finishedStatus;
                    SnapshotsInProgress.ShardSnapshotStatus existingStatus;
                    SnapshotsInProgress.ShardSnapshotStatus finishedStatus2;
                    SnapshotsInProgress.ShardSnapshotStatus existingStatus2;
                    SnapshotsInProgress.ShardSnapshotStatus existing;
                    Writeable finishedShardId;
                    ShardSnapshotUpdate updateSnapshotState = (ShardSnapshotUpdate)iterator.next();
                    Snapshot updatedSnapshot = updateSnapshotState.snapshot;
                    String updatedRepository = updatedSnapshot.getRepository();
                    if (!entry.repository().equals(updatedRepository)) continue;
                    if (updateSnapshotState.isClone()) {
                        finishedShardId = updateSnapshotState.repoShardId;
                        if (entry.snapshot().getSnapshotId().equals(updatedSnapshot.getSnapshotId())) {
                            assert (entry.isClone()) : "Non-clone snapshot [" + String.valueOf(entry) + "] received update for clone [" + String.valueOf(updateSnapshotState) + "]";
                            existing = entry.clones().get(finishedShardId);
                            if (existing == null) {
                                logger.warn("Received clone shard snapshot status update [{}] but this shard is not tracked in [{}]", (Object)updateSnapshotState, (Object)entry);
                                assert (false) : "This should never happen, cluster-manager will not submit a state update for a non-existing clone";
                                continue;
                            }
                            if (existing.state().completed()) {
                                iterator.remove();
                                continue;
                            }
                            logger.trace("[{}] Updating shard clone [{}] with status [{}]", (Object)updatedSnapshot, (Object)finishedShardId, (Object)updateSnapshotState.updatedState.state());
                            if (clones == null) {
                                clones = new HashMap<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus>(entry.clones());
                            }
                            ++changedCount;
                            clones.put((RepositoryShardId)finishedShardId, updateSnapshotState.updatedState);
                            executedTasks.add(updateSnapshotState);
                            continue;
                        }
                        if (!executedTasks.contains(updateSnapshotState)) continue;
                        if (entry.isClone()) {
                            existingStatus2 = entry.clones().get(finishedShardId);
                            if (existingStatus2 == null || existingStatus2.state() != SnapshotsInProgress.ShardState.QUEUED) continue;
                            if (clones == null) {
                                clones = new HashMap<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus>(entry.clones());
                            }
                            finishedStatus2 = updateSnapshotState.updatedState;
                            logger.trace("Starting clone [{}] on [{}] with generation [{}]", (Object)finishedShardId, (Object)finishedStatus2.nodeId(), (Object)finishedStatus2.generation());
                            assert (finishedStatus2.nodeId().equals(localNodeId)) : "Clone updated with node id [" + finishedStatus2.nodeId() + "] but local node id is [" + localNodeId + "]";
                            clones.put((RepositoryShardId)finishedShardId, new SnapshotsInProgress.ShardSnapshotStatus(finishedStatus2.nodeId(), finishedStatus2.generation()));
                            iterator.remove();
                            continue;
                        }
                        IndexMetadata indexMeta = currentState.metadata().index(((RepositoryShardId)finishedShardId).indexName());
                        if (indexMeta == null) continue;
                        ShardId finishedRoutingShardId = new ShardId(indexMeta.getIndex(), ((RepositoryShardId)finishedShardId).shardId());
                        existingStatus = entry.shards().get(finishedRoutingShardId);
                        if (existingStatus == null || existingStatus.state() != SnapshotsInProgress.ShardState.QUEUED) continue;
                        if (shards == null) {
                            shards = new HashMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus>(entry.shards());
                        }
                        finishedStatus = updateSnapshotState.updatedState;
                        logger.trace("Starting [{}] on [{}] with generation [{}]", (Object)finishedShardId, (Object)finishedStatus.nodeId(), (Object)finishedStatus.generation());
                        SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = SnapshotsService.startShardSnapshotAfterClone(currentState, updateSnapshotState.updatedState.generation(), finishedRoutingShardId);
                        shards.put(finishedRoutingShardId, shardSnapshotStatus);
                        if (!shardSnapshotStatus.isActive()) continue;
                        iterator.remove();
                        continue;
                    }
                    finishedShardId = updateSnapshotState.shardId;
                    if (entry.snapshot().getSnapshotId().equals(updatedSnapshot.getSnapshotId())) {
                        existing = entry.shards().get(finishedShardId);
                        if (existing == null) {
                            logger.warn("Received shard snapshot status update [{}] but this shard is not tracked in [{}]", (Object)updateSnapshotState, (Object)entry);
                            assert (false) : "This should never happen, data nodes should only send updates for expected shards";
                            continue;
                        }
                        if (existing.state().completed()) {
                            iterator.remove();
                            continue;
                        }
                        logger.trace("[{}] Updating shard [{}] with status [{}]", (Object)updatedSnapshot, (Object)finishedShardId, (Object)updateSnapshotState.updatedState.state());
                        if (shards == null) {
                            shards = new HashMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus>(entry.shards());
                        }
                        shards.put((ShardId)finishedShardId, updateSnapshotState.updatedState);
                        executedTasks.add(updateSnapshotState);
                        ++changedCount;
                        continue;
                    }
                    if (!executedTasks.contains(updateSnapshotState)) continue;
                    if (entry.isClone()) {
                        IndexId indexId;
                        if (indicesLookup == null) {
                            indicesLookup = entry.indices().stream().collect(Collectors.toMap(IndexId::getName, Function.identity()));
                        }
                        if ((indexId = (IndexId)indicesLookup.get(((ShardId)finishedShardId).getIndexName())) == null) continue;
                        RepositoryShardId repoShardId = new RepositoryShardId(indexId, ((ShardId)finishedShardId).getId());
                        existingStatus = entry.clones().get(repoShardId);
                        if (existingStatus == null || existingStatus.state() != SnapshotsInProgress.ShardState.QUEUED) continue;
                        if (clones == null) {
                            clones = new HashMap<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus>(entry.clones());
                        }
                        finishedStatus = updateSnapshotState.updatedState;
                        logger.trace("Starting clone [{}] on [{}] with generation [{}]", (Object)finishedShardId, (Object)finishedStatus.nodeId(), (Object)finishedStatus.generation());
                        clones.put(repoShardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, finishedStatus.generation()));
                        iterator.remove();
                        ++startedCount;
                        continue;
                    }
                    existingStatus2 = entry.shards().get(finishedShardId);
                    if (existingStatus2 == null || existingStatus2.state() != SnapshotsInProgress.ShardState.QUEUED) continue;
                    if (shards == null) {
                        shards = new HashMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus>(entry.shards());
                    }
                    finishedStatus2 = updateSnapshotState.updatedState;
                    logger.trace("Starting [{}] on [{}] with generation [{}]", (Object)finishedShardId, (Object)finishedStatus2.nodeId(), (Object)finishedStatus2.generation());
                    shards.put((ShardId)finishedShardId, new SnapshotsInProgress.ShardSnapshotStatus(finishedStatus2.nodeId(), finishedStatus2.generation()));
                    iterator.remove();
                }
                if (shards != null) {
                    assert (clones == null) : "Should not have updated clones when updating shard snapshots but saw " + String.valueOf(clones) + " as well as " + String.valueOf(shards);
                    updatedEntry = entry.withShardStates(shards);
                } else {
                    updatedEntry = clones != null ? entry.withClones(clones) : entry;
                }
                entries.add(updatedEntry);
            }
            if (changedCount > 0) {
                logger.trace("changed cluster state triggered by [{}] snapshot state updates and resulted in starting [{}] shard snapshots", (Object)changedCount, (Object)startedCount);
                return ClusterStateTaskExecutor.ClusterStateTasksResult.builder().successes(tasks).build(ClusterState.builder(currentState).putCustom("snapshots", SnapshotsInProgress.of(entries)).build());
            }
            return ClusterStateTaskExecutor.ClusterStateTasksResult.builder().successes(tasks).build(currentState);
        };
    }

    private static final class OngoingRepositoryOperations {
        private final Map<String, Deque<SnapshotsInProgress.Entry>> snapshotsToFinalize = new HashMap<String, Deque<SnapshotsInProgress.Entry>>();
        private final Set<String> runningDeletions = Collections.synchronizedSet(new HashSet());
        @Nullable
        private Metadata latestKnownMetaData;

        private OngoingRepositoryOperations() {
        }

        @Nullable
        synchronized Tuple<SnapshotsInProgress.Entry, Metadata> pollFinalization(String repository) {
            this.assertConsistent();
            Deque<SnapshotsInProgress.Entry> queued = this.snapshotsToFinalize.get(repository);
            if (queued == null) {
                return null;
            }
            SnapshotsInProgress.Entry nextEntry = queued.pollFirst();
            assert (nextEntry != null);
            Tuple res = Tuple.tuple((Object)nextEntry, (Object)this.latestKnownMetaData);
            if (queued.isEmpty()) {
                this.snapshotsToFinalize.remove(repository);
            }
            if (this.snapshotsToFinalize.isEmpty()) {
                this.latestKnownMetaData = null;
            }
            assert (this.assertConsistent());
            return res;
        }

        boolean startDeletion(String deleteUUID) {
            return this.runningDeletions.add(deleteUUID);
        }

        void finishDeletion(String deleteUUID) {
            this.runningDeletions.remove(deleteUUID);
        }

        synchronized void addFinalization(SnapshotsInProgress.Entry entry, Metadata metadata) {
            this.snapshotsToFinalize.computeIfAbsent(entry.repository(), k -> new LinkedList()).add(entry);
            this.latestKnownMetaData = metadata;
            this.assertConsistent();
        }

        synchronized void clear() {
            this.snapshotsToFinalize.clear();
            this.runningDeletions.clear();
            this.latestKnownMetaData = null;
        }

        synchronized boolean isEmpty() {
            return this.snapshotsToFinalize.isEmpty();
        }

        synchronized boolean assertNotQueued(Snapshot snapshot) {
            assert (((Deque)this.snapshotsToFinalize.getOrDefault(snapshot.getRepository(), new LinkedList())).stream().noneMatch(entry -> entry.snapshot().equals(snapshot))) : "Snapshot [" + String.valueOf(snapshot) + "] is still in finalization queue";
            return true;
        }

        synchronized boolean assertConsistent() {
            assert (this.latestKnownMetaData == null && this.snapshotsToFinalize.isEmpty() || this.latestKnownMetaData != null && !this.snapshotsToFinalize.isEmpty()) : "Should not hold on to metadata if there are no more queued snapshots";
            assert (this.snapshotsToFinalize.values().stream().noneMatch(Collection::isEmpty)) : "Found empty queue in " + String.valueOf(this.snapshotsToFinalize);
            return true;
        }
    }

    private class UpdateSnapshotStatusAction
    extends TransportClusterManagerNodeAction<UpdateIndexShardSnapshotStatusRequest, UpdateIndexShardSnapshotStatusResponse> {
        UpdateSnapshotStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(SnapshotsService.UPDATE_SNAPSHOT_STATUS_ACTION_NAME, false, transportService, clusterService, threadPool, actionFilters, UpdateIndexShardSnapshotStatusRequest::new, indexNameExpressionResolver);
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected UpdateIndexShardSnapshotStatusResponse read(StreamInput in) throws IOException {
            return UpdateIndexShardSnapshotStatusResponse.INSTANCE;
        }

        @Override
        protected void clusterManagerOperation(UpdateIndexShardSnapshotStatusRequest request, ClusterState state, ActionListener<UpdateIndexShardSnapshotStatusResponse> listener) throws Exception {
            SnapshotsService.this.innerUpdateSnapshotState(new ShardSnapshotUpdate(request.snapshot(), request.shardId(), request.status()), ActionListenerHelper.delegateFailure(listener, (l, v) -> l.onResponse((Object)UpdateIndexShardSnapshotStatusResponse.INSTANCE)));
        }

        @Override
        protected ClusterBlockException checkBlock(UpdateIndexShardSnapshotStatusRequest request, ClusterState state) {
            return null;
        }
    }

    static final class ShardSnapshotUpdate {
        private final Snapshot snapshot;
        private final ShardId shardId;
        private final RepositoryShardId repoShardId;
        private final SnapshotsInProgress.ShardSnapshotStatus updatedState;

        ShardSnapshotUpdate(Snapshot snapshot, RepositoryShardId repositoryShardId, SnapshotsInProgress.ShardSnapshotStatus updatedState) {
            this.snapshot = snapshot;
            this.shardId = null;
            this.updatedState = updatedState;
            this.repoShardId = repositoryShardId;
        }

        ShardSnapshotUpdate(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus updatedState) {
            this.snapshot = snapshot;
            this.shardId = shardId;
            this.updatedState = updatedState;
            this.repoShardId = null;
        }

        public boolean isClone() {
            return this.repoShardId != null;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShardSnapshotUpdate)) {
                return false;
            }
            ShardSnapshotUpdate that = (ShardSnapshotUpdate)other;
            return this.snapshot.equals(that.snapshot) && Objects.equals(this.shardId, that.shardId) && Objects.equals(this.repoShardId, that.repoShardId) && this.updatedState == that.updatedState;
        }

        public int hashCode() {
            return Objects.hash(this.snapshot, this.shardId, this.updatedState, this.repoShardId);
        }
    }

    private static class CleanupAfterErrorListener {
        private final ActionListener<Snapshot> userCreateSnapshotListener;
        private final Exception e;

        CleanupAfterErrorListener(ActionListener<Snapshot> userCreateSnapshotListener, Exception e) {
            this.userCreateSnapshotListener = userCreateSnapshotListener;
            this.e = e;
        }

        public void onFailure(@Nullable Exception e) {
            this.userCreateSnapshotListener.onFailure((Exception)ExceptionsHelper.useOrSuppress((Throwable)e, (Throwable)this.e));
        }

        public void onNoLongerClusterManager() {
            this.userCreateSnapshotListener.onFailure(this.e);
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING);
        }
    }

    private final class FailPendingRepoTasksTask
    extends ClusterStateUpdateTask {
        private final List<Snapshot> snapshotsToFail = new ArrayList<Snapshot>();
        private final List<String> deletionsToFail = new ArrayList<String>();
        private final Exception failure;
        private final String repository;

        FailPendingRepoTasksTask(String repository, Exception failure) {
            this.repository = repository;
            this.failure = failure;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
            boolean changed = false;
            List<SnapshotDeletionsInProgress.Entry> remainingEntries = deletionsInProgress.getEntries();
            ArrayList<SnapshotDeletionsInProgress.Entry> updatedEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>(remainingEntries.size());
            for (SnapshotDeletionsInProgress.Entry entry : remainingEntries) {
                if (entry.repository().equals(this.repository)) {
                    changed = true;
                    this.deletionsToFail.add(entry.uuid());
                    continue;
                }
                updatedEntries.add(entry);
            }
            SnapshotDeletionsInProgress updatedDeletions = changed ? SnapshotDeletionsInProgress.of(updatedEntries) : null;
            SnapshotsInProgress snapshotsInProgress = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
            ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
            boolean changedSnapshots = false;
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
                if (entry.repository().equals(this.repository)) {
                    this.snapshotsToFail.add(entry.snapshot());
                    changedSnapshots = true;
                    continue;
                }
                snapshotEntries.add(entry);
            }
            SnapshotsInProgress updatedSnapshotsInProgress = changedSnapshots ? SnapshotsInProgress.of(snapshotEntries) : null;
            return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshotsInProgress, updatedDeletions);
        }

        @Override
        public void onFailure(String source, Exception e) {
            logger.info(() -> new ParameterizedMessage("Failed to remove all snapshot tasks for repo [{}] from cluster state", (Object)this.repository), (Throwable)e);
            SnapshotsService.this.failAllListenersOnMasterFailOver(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            logger.warn(() -> new ParameterizedMessage("Removed all snapshot tasks for repository [{}] from cluster state, now failing listeners", (Object)this.repository), (Throwable)this.failure);
            Set<String> set = SnapshotsService.this.currentlyFinalizing;
            synchronized (set) {
                Tuple<SnapshotsInProgress.Entry, Metadata> finalization;
                while ((finalization = SnapshotsService.this.repositoryOperations.pollFinalization(this.repository)) != null) {
                    assert (this.snapshotsToFail.contains(((SnapshotsInProgress.Entry)finalization.v1()).snapshot())) : "[" + String.valueOf(finalization.v1()) + "] not found in snapshots to fail " + String.valueOf(this.snapshotsToFail);
                }
                SnapshotsService.this.leaveRepoLoop(this.repository);
                for (Snapshot snapshot : this.snapshotsToFail) {
                    SnapshotsService.this.failSnapshotCompletionListeners(snapshot, this.failure);
                }
                for (String delete : this.deletionsToFail) {
                    SnapshotsService.failListenersIgnoringException(SnapshotsService.this.snapshotDeletionListeners.remove(delete), this.failure);
                    SnapshotsService.this.repositoryOperations.finishDeletion(delete);
                }
            }
        }
    }

    private abstract class RemoveSnapshotDeletionAndContinueTask
    extends ClusterStateUpdateTask {
        protected final List<SnapshotsInProgress.Entry> newFinalizations = new ArrayList<SnapshotsInProgress.Entry>();
        private List<SnapshotDeletionsInProgress.Entry> readyDeletions = Collections.emptyList();
        protected final SnapshotDeletionsInProgress.Entry deleteEntry;
        private final RepositoryData repositoryData;

        RemoveSnapshotDeletionAndContinueTask(SnapshotDeletionsInProgress.Entry deleteEntry, RepositoryData repositoryData) {
            this.deleteEntry = deleteEntry;
            this.repositoryData = repositoryData;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            SnapshotDeletionsInProgress deletions = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
            assert (deletions != null) : "We only run this if there were deletions in the cluster state before";
            SnapshotDeletionsInProgress updatedDeletions = deletions.withRemovedEntry(this.deleteEntry.uuid());
            if (updatedDeletions == deletions) {
                return currentState;
            }
            SnapshotDeletionsInProgress newDeletions = this.filterDeletions(updatedDeletions);
            Tuple<ClusterState, List<SnapshotDeletionsInProgress.Entry>> res = SnapshotsService.readyDeletions(SnapshotsService.updateWithSnapshots(currentState, this.updatedSnapshotsInProgress(currentState, newDeletions), newDeletions));
            this.readyDeletions = (List)res.v2();
            return (ClusterState)res.v1();
        }

        @Override
        public void onFailure(String source, Exception e) {
            logger.warn(() -> new ParameterizedMessage("{} failed to remove snapshot deletion metadata", (Object)this.deleteEntry), (Throwable)e);
            SnapshotsService.this.repositoryOperations.finishDeletion(this.deleteEntry.uuid());
            SnapshotsService.this.failAllListenersOnMasterFailOver(e);
        }

        protected SnapshotDeletionsInProgress filterDeletions(SnapshotDeletionsInProgress deletions) {
            return deletions;
        }

        @Override
        public final void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            SnapshotsService.this.repositoryOperations.finishDeletion(this.deleteEntry.uuid());
            List<ActionListener<Void>> deleteListeners = SnapshotsService.this.snapshotDeletionListeners.remove(this.deleteEntry.uuid());
            this.handleListeners(deleteListeners);
            if (this.newFinalizations.isEmpty()) {
                if (this.readyDeletions.isEmpty()) {
                    SnapshotsService.this.leaveRepoLoop(this.deleteEntry.repository());
                } else {
                    for (SnapshotDeletionsInProgress.Entry readyDeletion : this.readyDeletions) {
                        SnapshotsService.this.deleteSnapshotsFromRepository(readyDeletion, this.repositoryData, newState.nodes().getMinNodeVersion());
                    }
                }
            } else {
                SnapshotsService.this.leaveRepoLoop(this.deleteEntry.repository());
                assert (this.readyDeletions.stream().noneMatch(entry -> entry.repository().equals(this.deleteEntry.repository()))) : "New finalizations " + String.valueOf(this.newFinalizations) + " added even though deletes " + String.valueOf(this.readyDeletions) + " are ready";
                for (SnapshotsInProgress.Entry entry2 : this.newFinalizations) {
                    SnapshotsService.this.endSnapshot(entry2, newState.metadata(), this.repositoryData);
                }
            }
        }

        protected abstract void handleListeners(@Nullable List<ActionListener<Void>> var1);

        @Nullable
        private SnapshotsInProgress updatedSnapshotsInProgress(ClusterState currentState, SnapshotDeletionsInProgress updatedDeletions) {
            SnapshotsInProgress snapshotsInProgress = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
            ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
            HashSet<ShardId> reassignedShardIds = new HashSet<ShardId>();
            boolean changed = false;
            String repoName = this.deleteEntry.repository();
            Map<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardAssignments = null;
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
                if (entry.repository().equals(repoName)) {
                    if (!entry.state().completed()) {
                        Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> value2;
                        ArrayList<ShardId> canBeUpdated = new ArrayList<ShardId>();
                        for (Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> value2 : entry.shards().entrySet()) {
                            if (!value2.getValue().equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED) || reassignedShardIds.contains(value2.getKey())) continue;
                            canBeUpdated.add((ShardId)value2.getKey());
                        }
                        if (canBeUpdated.isEmpty()) {
                            snapshotEntries.add(entry);
                            continue;
                        }
                        if (shardAssignments == null) {
                            shardAssignments = SnapshotsService.shards(snapshotsInProgress, updatedDeletions, currentState.metadata(), currentState.routingTable(), entry.indices(), this.repositoryData, repoName);
                        }
                        HashMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedAssignmentsBuilder = new HashMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus>(entry.shards());
                        value2 = canBeUpdated.iterator();
                        while (value2.hasNext()) {
                            ShardId shardId = (ShardId)value2.next();
                            SnapshotsInProgress.ShardSnapshotStatus updated = shardAssignments.get(shardId);
                            if (updated == null) {
                                assert (!currentState.routingTable().hasIndex(shardId.getIndex())) : "Missing assignment for [" + String.valueOf(shardId) + "]";
                                updatedAssignmentsBuilder.put(shardId, SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                                continue;
                            }
                            boolean added = reassignedShardIds.add(shardId);
                            assert (added);
                            updatedAssignmentsBuilder.put(shardId, updated);
                        }
                        SnapshotsInProgress.Entry updatedEntry = entry.withShardStates(updatedAssignmentsBuilder);
                        snapshotEntries.add(updatedEntry);
                        changed = true;
                        if (!updatedEntry.state().completed()) continue;
                        this.newFinalizations.add(entry);
                        continue;
                    }
                    this.newFinalizations.add(entry);
                    snapshotEntries.add(entry);
                    continue;
                }
                snapshotEntries.add(entry);
            }
            return changed ? SnapshotsInProgress.of(snapshotEntries) : null;
        }
    }
}

