/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.tasks;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public class SearchShardTaskCancellationStats
implements ToXContentObject,
Writeable {
    private final long currentLongRunningCancelledTaskCount;
    private final long totalLongRunningCancelledTaskCount;

    public SearchShardTaskCancellationStats(long currentTaskCount, long totalTaskCount) {
        this.currentLongRunningCancelledTaskCount = currentTaskCount;
        this.totalLongRunningCancelledTaskCount = totalTaskCount;
    }

    public SearchShardTaskCancellationStats(StreamInput in) throws IOException {
        this.currentLongRunningCancelledTaskCount = in.readVLong();
        this.totalLongRunningCancelledTaskCount = in.readVLong();
    }

    protected long getCurrentLongRunningCancelledTaskCount() {
        return this.currentLongRunningCancelledTaskCount;
    }

    protected long getTotalLongRunningCancelledTaskCount() {
        return this.totalLongRunningCancelledTaskCount;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("current_count_post_cancel", this.currentLongRunningCancelledTaskCount);
        builder.field("total_count_post_cancel", this.totalLongRunningCancelledTaskCount);
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.currentLongRunningCancelledTaskCount);
        out.writeVLong(this.totalLongRunningCancelledTaskCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardTaskCancellationStats that = (SearchShardTaskCancellationStats)o;
        return this.currentLongRunningCancelledTaskCount == that.currentLongRunningCancelledTaskCount && this.totalLongRunningCancelledTaskCount == that.totalLongRunningCancelledTaskCount;
    }

    public int hashCode() {
        return Objects.hash(this.currentLongRunningCancelledTaskCount, this.totalLongRunningCancelledTaskCount);
    }
}

