/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.tasks.resourcetracker;

import io.skylite.core.tasks.resourcetracker.ResourceStats;
import io.skylite.core.tasks.resourcetracker.ResourceUsageMetric;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceUsageInfo {
    private static final Logger logger = LogManager.getLogger(ResourceUsageInfo.class);
    private final EnumMap<ResourceStats, ResourceStatsInfo> statsInfo = new EnumMap(ResourceStats.class);

    public ResourceUsageInfo(ResourceUsageMetric ... resourceUsageMetrics) {
        for (ResourceUsageMetric resourceUsageMetric : resourceUsageMetrics) {
            this.statsInfo.put(resourceUsageMetric.getStats(), new ResourceStatsInfo(resourceUsageMetric.getValue()));
        }
    }

    public void recordResourceUsageMetrics(ResourceUsageMetric ... resourceUsageMetrics) {
        for (ResourceUsageMetric resourceUsageMetric : resourceUsageMetrics) {
            ResourceStatsInfo resourceStatsInfo = this.statsInfo.get((Object)resourceUsageMetric.getStats());
            if (resourceStatsInfo == null) {
                throw new IllegalStateException("cannot update [" + resourceUsageMetric.getStats().toString() + "] entry as its not present current_stats_info:" + String.valueOf(this.statsInfo));
            }
            this.updateResourceUsageInfo(resourceStatsInfo, resourceUsageMetric);
        }
    }

    private void updateResourceUsageInfo(ResourceStatsInfo resourceStatsInfo, ResourceUsageMetric resourceUsageMetric) {
        long newEndValue;
        long currentEndValue;
        do {
            if ((currentEndValue = resourceStatsInfo.endValue.get()) <= (newEndValue = resourceUsageMetric.getValue())) continue;
            logger.debug("dropping resource usage update as the new value is lower than current value [resource_stats=[{}], current_end_value={}, new_end_value={}]", (Object)resourceUsageMetric.getStats(), (Object)currentEndValue, (Object)newEndValue);
            return;
        } while (!resourceStatsInfo.endValue.compareAndSet(currentEndValue, newEndValue));
        logger.debug("updated resource usage info [resource_stats=[{}], old_end_value={}, new_end_value={}]", (Object)resourceUsageMetric.getStats(), (Object)currentEndValue, (Object)newEndValue);
    }

    public Map<ResourceStats, ResourceStatsInfo> getStatsInfo() {
        return Collections.unmodifiableMap(this.statsInfo);
    }

    public String toString() {
        return this.statsInfo.toString();
    }

    public static class ResourceStatsInfo {
        private final long startValue;
        private final AtomicLong endValue;

        private ResourceStatsInfo(long startValue) {
            this.startValue = startValue;
            this.endValue = new AtomicLong(startValue);
        }

        public long getTotalValue() {
            return this.endValue.get() - this.startValue;
        }

        public String toString() {
            return String.valueOf(this.getTotalValue());
        }
    }
}

