/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.telemetry.tracing.listener;

import io.skylite.common.action.ActionListener;
import io.skylite.common.telemetry.tracing.Span;
import io.skylite.common.telemetry.tracing.SpanScope;
import io.skylite.common.telemetry.tracing.Tracer;
import java.util.Objects;

public class TraceableActionListener<Response>
implements ActionListener<Response> {
    private final ActionListener<Response> delegate;
    private final Span span;
    private final Tracer tracer;

    private TraceableActionListener(ActionListener<Response> delegate, Span span, Tracer tracer) {
        this.delegate = Objects.requireNonNull(delegate);
        this.span = Objects.requireNonNull(span);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public static <Response> ActionListener<Response> create(ActionListener<Response> delegate, Span span, Tracer tracer) {
        if (tracer.isRecording()) {
            return new TraceableActionListener<Response>(delegate, span, tracer);
        }
        return delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Response response) {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.onResponse(response);
        }
        finally {
            this.span.endSpan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(Exception e) {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.onFailure(e);
        }
        finally {
            this.span.setError(e);
            this.span.endSpan();
        }
    }
}

