/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.threadpool;

import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.util.List;

public abstract class ExecutorBuilder<U extends ExecutorSettings> {
    private final String name;

    public ExecutorBuilder(String name) {
        this.name = name;
    }

    protected String name() {
        return this.name;
    }

    protected static String settingsKey(String prefix, String key) {
        return String.join((CharSequence)".", prefix, key);
    }

    protected int applyHardSizeLimit(Settings settings, String name) {
        if (name.equals("bulk") || name.equals("write") || name.equals("system_write")) {
            return 1 + SkyliteExecutors.allocatedProcessors(settings);
        }
        return Integer.MAX_VALUE;
    }

    public abstract List<Setting<?>> getRegisteredSettings();

    abstract U getSettings(Settings var1);

    abstract ThreadPool.ExecutorHolder build(U var1, ThreadContext var2);

    abstract String formatInfo(ThreadPool.Info var1);

    static abstract class ExecutorSettings {
        protected final String nodeName;

        ExecutorSettings(String nodeName) {
            this.nodeName = nodeName;
        }
    }
}

