/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.threadpool;

import io.skylite.common.ExceptionsHelper;
import io.skylite.common.SuppressForbidden;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.common.util.concurrent.SkyliteAbortPolicy;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.CancellableAdapter;
import io.skylite.core.threadpool.ScheduledCancellableAdapter;
import java.util.concurrent.Delayed;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public interface Scheduler {
    public static ScheduledThreadPoolExecutor initScheduler(Settings settings) {
        SafeScheduledThreadPoolExecutor scheduler = new SafeScheduledThreadPoolExecutor(1, SkyliteExecutors.daemonThreadFactory(settings, "scheduler"), (RejectedExecutionHandler)new SkyliteAbortPolicy());
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        scheduler.setRemoveOnCancelPolicy(true);
        return scheduler;
    }

    public static boolean terminate(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long timeout, TimeUnit timeUnit) {
        scheduledThreadPoolExecutor.shutdown();
        if (Scheduler.awaitTermination(scheduledThreadPoolExecutor, timeout, timeUnit)) {
            return true;
        }
        scheduledThreadPoolExecutor.shutdownNow();
        return Scheduler.awaitTermination(scheduledThreadPoolExecutor, timeout, timeUnit);
    }

    public static boolean awaitTermination(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long timeout, TimeUnit timeUnit) {
        try {
            if (scheduledThreadPoolExecutor.awaitTermination(timeout, timeUnit)) {
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public ScheduledCancellable schedule(Runnable var1, TimeValue var2, String var3);

    default public Cancellable scheduleWithFixedDelay(Runnable command, TimeValue interval, String executor) {
        return new ReschedulingRunnable(command, interval, executor, this, e -> {}, e -> {});
    }

    public static Cancellable wrapAsCancellable(Future<?> future) {
        return new CancellableAdapter(future);
    }

    public static ScheduledCancellable wrapAsScheduledCancellable(ScheduledFuture<?> scheduledFuture) {
        return new ScheduledCancellableAdapter(scheduledFuture);
    }

    public static class SafeScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        @SuppressForbidden(reason="properly rethrowing errors, see OpenSearchExecutors.rethrowErrors")
        public SafeScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, threadFactory, handler);
        }

        @SuppressForbidden(reason="properly rethrowing errors, see OpenSearchExecutors.rethrowErrors")
        public SafeScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        @SuppressForbidden(reason="properly rethrowing errors, see OpenSearchExecutors.rethrowErrors")
        public SafeScheduledThreadPoolExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t != null) {
                return;
            }
            if (r instanceof RunnableFuture && ((RunnableFuture)r).isDone()) {
                ExceptionsHelper.reThrowIfNotNull((Throwable)SkyliteExecutors.rethrowErrors(r));
            }
        }
    }

    public static final class ReschedulingRunnable
    extends AbstractRunnable
    implements Cancellable {
        private final Runnable runnable;
        private final TimeValue interval;
        private final String executor;
        private final Scheduler scheduler;
        private final Consumer<Exception> rejectionConsumer;
        private final Consumer<Exception> failureConsumer;
        private volatile boolean run = true;

        ReschedulingRunnable(Runnable runnable, TimeValue interval, String executor, Scheduler scheduler, Consumer<Exception> rejectionConsumer, Consumer<Exception> failureConsumer) {
            this.runnable = runnable;
            this.interval = interval;
            this.executor = executor;
            this.scheduler = scheduler;
            this.rejectionConsumer = rejectionConsumer;
            this.failureConsumer = failureConsumer;
            scheduler.schedule((Runnable)((Object)this), interval, executor);
        }

        @Override
        public boolean cancel() {
            boolean result = this.run;
            this.run = false;
            return result;
        }

        @Override
        public boolean isCancelled() {
            return !this.run;
        }

        public void doRun() {
            if (this.run) {
                this.runnable.run();
            }
        }

        public void onFailure(Exception e) {
            this.failureConsumer.accept(e);
        }

        public void onRejection(Exception e) {
            this.run = false;
            this.rejectionConsumer.accept(e);
        }

        public void onAfter() {
            if (this.run) {
                try {
                    this.scheduler.schedule((Runnable)((Object)this), this.interval, this.executor);
                }
                catch (SkyliteRejectedExecutionException e) {
                    this.onRejection((Exception)((Object)e));
                }
            }
        }

        public String toString() {
            return "ReschedulingRunnable{runnable=" + String.valueOf(this.runnable) + ", interval=" + String.valueOf(this.interval) + "}";
        }
    }

    public static interface ScheduledCancellable
    extends Delayed,
    Cancellable {
    }

    public static interface Cancellable {
        public boolean cancel();

        public boolean isCancelled();
    }
}

