/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.threadpool;

import io.skylite.common.ExceptionsHelper;
import io.skylite.common.threadpool.RunnableTaskExecutionListener;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.common.util.concurrent.WrappedRunnable;
import io.skylite.core.common.concurrent.ThreadContext;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskAwareRunnable
extends AbstractRunnable
implements WrappedRunnable {
    private static final Logger logger = LogManager.getLogger(TaskAwareRunnable.class);
    private final Runnable original;
    private final ThreadContext threadContext;
    private final AtomicReference<RunnableTaskExecutionListener> runnableTaskListener;

    public TaskAwareRunnable(ThreadContext threadContext, Runnable original, AtomicReference<RunnableTaskExecutionListener> runnableTaskListener) {
        this.original = original;
        this.threadContext = threadContext;
        this.runnableTaskListener = runnableTaskListener;
    }

    public void onFailure(Exception e) {
        ExceptionsHelper.reThrowIfNotNull((Throwable)e);
    }

    public boolean isForceExecution() {
        return this.original instanceof AbstractRunnable && ((AbstractRunnable)this.original).isForceExecution();
    }

    public void onRejection(Exception e) {
        if (this.original instanceof AbstractRunnable) {
            ((AbstractRunnable)this.original).onRejection(e);
        } else {
            ExceptionsHelper.reThrowIfNotNull((Throwable)e);
        }
    }

    public void doRun() throws Exception {
        assert (this.runnableTaskListener.get() != null) : "Listener should be attached";
        Long taskId = (Long)this.threadContext.getTransient("TASK_ID");
        if (Objects.nonNull(taskId)) {
            this.runnableTaskListener.get().taskExecutionStartedOnThread(taskId.longValue(), Thread.currentThread().getId());
        } else {
            logger.debug("Task Id not available in thread context. Skipping update. Thread Info: {}", (Object)Thread.currentThread());
        }
        try {
            this.original.run();
        }
        finally {
            if (Objects.nonNull(taskId)) {
                this.runnableTaskListener.get().taskExecutionFinishedOnThread(taskId.longValue(), Thread.currentThread().getId());
            }
        }
    }

    public Runnable unwrap() {
        return this.original;
    }
}

