/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.transport.TransportException;
import java.io.IOException;

public class ActionNotFoundTransportException
extends TransportException {
    private final String action;

    public ActionNotFoundTransportException(StreamInput in) throws IOException {
        super(in);
        this.action = in.readOptionalString();
    }

    public ActionNotFoundTransportException(String action) {
        super("No handler for action [" + action + "]");
        this.action = action;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.action);
    }

    public String action() {
        return this.action;
    }

    public static class Registration
    implements SkyliteExceptionProvider<ActionNotFoundTransportException> {
        @Override
        public Class<ActionNotFoundTransportException> getExceptionClass() {
            return ActionNotFoundTransportException.class;
        }

        @Override
        public CheckedFunction<StreamInput, ActionNotFoundTransportException, IOException> getConstructor() {
            return ActionNotFoundTransportException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 101;
        }
    }
}

