/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.common.bytes.ReleasableBytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.transport.Header;
import java.io.Closeable;
import java.io.IOException;

public class InboundMessage
implements Releasable {
    private final Header header;
    private final ReleasableBytesReference content;
    private final Exception exception;
    private final boolean isPing;
    private Releasable breakerRelease;
    private StreamInput streamInput;

    public InboundMessage(Header header, ReleasableBytesReference content, Releasable breakerRelease) {
        this.header = header;
        this.content = content;
        this.breakerRelease = breakerRelease;
        this.exception = null;
        this.isPing = false;
    }

    public InboundMessage(Header header, Exception exception) {
        this.header = header;
        this.content = null;
        this.breakerRelease = null;
        this.exception = exception;
        this.isPing = false;
    }

    public InboundMessage(Header header, boolean isPing) {
        this.header = header;
        this.content = null;
        this.breakerRelease = null;
        this.exception = null;
        this.isPing = isPing;
    }

    public Header getHeader() {
        return this.header;
    }

    public int getContentLength() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length();
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isPing() {
        return this.isPing;
    }

    public boolean isShortCircuit() {
        return this.exception != null;
    }

    public Releasable takeBreakerReleaseControl() {
        Releasable toReturn = this.breakerRelease;
        this.breakerRelease = null;
        if (toReturn != null) {
            return toReturn;
        }
        return () -> {};
    }

    public StreamInput openOrGetStreamInput() throws IOException {
        assert (!this.isPing && this.content != null);
        if (this.streamInput == null) {
            this.streamInput = this.content.streamInput();
            this.streamInput.setVersion(this.header.getVersion());
        }
        return this.streamInput;
    }

    public void close() {
        IOUtils.closeWhileHandlingException((Closeable)this.streamInput);
        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.content, this.breakerRelease});
    }

    public String toString() {
        return "InboundMessage{" + String.valueOf(this.header) + "}";
    }
}

