/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.Version;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.bytes.CompositeBytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.transport.BytesTransportRequest;
import io.skylite.core.transport.CompressibleBytesOutputStream;
import io.skylite.core.transport.NetworkMessage;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.transport.TcpHeader;
import io.skylite.core.transport.TransportStatus;
import java.io.IOException;
import java.util.Set;

abstract class OutboundMessage
extends NetworkMessage {
    private final Writeable message;

    OutboundMessage(ThreadContext threadContext, Version version, byte status, long requestId, Writeable message) {
        super(threadContext, version, status, requestId);
        this.message = message;
    }

    BytesReference serialize(BytesStreamOutput bytesStream) throws IOException {
        BytesReference reference;
        bytesStream.setVersion(this.version);
        bytesStream.skip(TcpHeader.headerSize(this.version));
        int variableHeaderLength = -1;
        long preHeaderPosition = bytesStream.position();
        this.writeVariableHeader(bytesStream);
        variableHeaderLength = Math.toIntExact(bytesStream.position() - preHeaderPosition);
        try (CompressibleBytesOutputStream stream = new CompressibleBytesOutputStream(bytesStream, TransportStatus.isCompress(this.status));){
            stream.setVersion(this.version);
            stream.setFeatures(bytesStream.getFeatures());
            if (variableHeaderLength == -1) {
                this.writeVariableHeader(stream);
            }
            reference = this.writeMessage(stream);
        }
        bytesStream.seek(0L);
        int contentSize = reference.length() - TcpHeader.headerSize(this.version);
        TcpHeader.writeHeader(bytesStream, this.requestId, this.status, this.version, contentSize, variableHeaderLength);
        return reference;
    }

    protected void writeVariableHeader(StreamOutput stream) throws IOException {
        this.threadContext.writeTo(stream);
    }

    protected BytesReference writeMessage(CompressibleBytesOutputStream stream) throws IOException {
        BytesReference zeroCopyBuffer;
        if (this.message instanceof BytesTransportRequest) {
            BytesTransportRequest bRequest = (BytesTransportRequest)this.message;
            bRequest.writeThin(stream);
            zeroCopyBuffer = bRequest.bytes;
        } else if (this.message instanceof RemoteTransportException) {
            stream.writeException((RemoteTransportException)this.message);
            zeroCopyBuffer = BytesArray.EMPTY;
        } else {
            this.message.writeTo(stream);
            zeroCopyBuffer = BytesArray.EMPTY;
        }
        BytesReference message = stream.materializeBytes();
        if (zeroCopyBuffer.length() == 0) {
            return message;
        }
        return CompositeBytesReference.of(message, zeroCopyBuffer);
    }

    private static boolean canCompress(Writeable message) {
        return !(message instanceof BytesTransportRequest);
    }

    static class Response
    extends OutboundMessage {
        private final Set<String> features;

        Response(ThreadContext threadContext, Set<String> features, Writeable message, Version<?> version, long requestId, boolean isHandshake, boolean compress) {
            super(threadContext, version, Response.setStatus(compress, isHandshake, message), requestId, message);
            this.features = features;
        }

        @Override
        protected void writeVariableHeader(StreamOutput stream) throws IOException {
            super.writeVariableHeader(stream);
            stream.setFeatures(this.features);
        }

        private static byte setStatus(boolean compress, boolean isHandshake, Writeable message) {
            byte status = 0;
            status = TransportStatus.setResponse(status);
            if (message instanceof RemoteTransportException) {
                status = TransportStatus.setError(status);
            }
            if (compress) {
                status = TransportStatus.setCompress(status);
            }
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }
    }

    static class Request
    extends OutboundMessage {
        private final String[] features;
        private final String action;

        Request(ThreadContext threadContext, String[] features, Writeable message, Version version, String action, long requestId, boolean isHandshake, boolean compress) {
            super(threadContext, version, Request.setStatus(compress, isHandshake, message), requestId, message);
            this.features = features;
            this.action = action;
        }

        @Override
        protected void writeVariableHeader(StreamOutput stream) throws IOException {
            super.writeVariableHeader(stream);
            stream.writeStringArray(this.features);
            stream.writeString(this.action);
        }

        private static byte setStatus(boolean compress, boolean isHandshake, Writeable message) {
            byte status = 0;
            status = TransportStatus.setRequest(status);
            if (compress && OutboundMessage.canCompress(message)) {
                status = TransportStatus.setCompress(status);
            }
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }
    }
}

