/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.SkyliteException;
import io.skylite.SkyliteTimeoutException;
import io.skylite.core.common.concurrent.BaseFuture;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.transport.ResponseHandlerFailureTransportException;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportFuture;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportResponseHandler;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PlainTransportFuture<V extends TransportResponse>
extends BaseFuture<V>
implements TransportFuture<V>,
TransportResponseHandler<V> {
    private final TransportResponseHandler<V> handler;

    public PlainTransportFuture(TransportResponseHandler<V> handler) {
        this.handler = handler;
    }

    @Override
    public V txGet() {
        try {
            return (V)((TransportResponse)this.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SkyliteException) {
                throw (SkyliteException)e.getCause();
            }
            throw new TransportException("Failed execution", e);
        }
    }

    @Override
    public V txGet(long timeout, TimeUnit unit) {
        try {
            return (V)((TransportResponse)this.get(timeout, unit));
        }
        catch (TimeoutException e) {
            throw new SkyliteTimeoutException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SkyliteException) {
                throw (SkyliteException)e.getCause();
            }
            throw new TransportException("Failed execution", e);
        }
    }

    @Override
    public V read(StreamInput in) throws IOException {
        return (V)((TransportResponse)this.handler.read(in));
    }

    @Override
    public String executor() {
        return this.handler.executor();
    }

    @Override
    public void handleResponse(V response) {
        try {
            this.handler.handleResponse(response);
            this.set(response);
        }
        catch (Exception e) {
            this.handleException(new ResponseHandlerFailureTransportException(e));
        }
    }

    @Override
    public void handleException(TransportException exp) {
        try {
            this.handler.handleException(exp);
        }
        finally {
            this.setException(exp);
        }
    }

    public String toString() {
        return "future(" + this.handler.toString() + ")";
    }
}

