/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.Version;
import io.skylite.common.action.ActionListener;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.transport.ConnectTransportException;
import io.skylite.core.transport.ConnectionManager;
import io.skylite.core.transport.ConnectionProfile;
import io.skylite.core.transport.NoSuchRemoteClusterException;
import io.skylite.core.transport.NodeNotConnectedException;
import io.skylite.core.transport.TransportActionProxy;
import io.skylite.core.transport.TransportConnection;
import io.skylite.core.transport.TransportConnectionListener;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class RemoteConnectionManager
implements ConnectionManager {
    private final String clusterAlias;
    private final ConnectionManager delegate;
    private final AtomicLong counter = new AtomicLong();
    private volatile List<DiscoveryNode> connectedNodes = Collections.emptyList();

    RemoteConnectionManager(String clusterAlias, ConnectionManager delegate) {
        this.clusterAlias = clusterAlias;
        this.delegate = delegate;
        this.delegate.addListener(new TransportConnectionListener(){

            @Override
            public void onNodeConnected(DiscoveryNode node, TransportConnection connection) {
                RemoteConnectionManager.this.addConnectedNode(node);
            }

            @Override
            public void onNodeDisconnected(DiscoveryNode node, TransportConnection connection) {
                RemoteConnectionManager.this.removeConnectedNode(node);
            }
        });
    }

    @Override
    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, ConnectionManager.ConnectionValidator connectionValidator, ActionListener<Void> listener) throws ConnectTransportException {
        this.delegate.connectToNode(node, connectionProfile, connectionValidator, listener);
    }

    @Override
    public void addListener(TransportConnectionListener listener) {
        this.delegate.addListener(listener);
    }

    @Override
    public void removeListener(TransportConnectionListener listener) {
        this.delegate.removeListener(listener);
    }

    @Override
    public void openConnection(DiscoveryNode node, ConnectionProfile profile, ActionListener<TransportConnection> listener) {
        this.delegate.openConnection(node, profile, listener);
    }

    @Override
    public TransportConnection getConnection(DiscoveryNode node) {
        try {
            return this.delegate.getConnection(node);
        }
        catch (NodeNotConnectedException e) {
            return new ProxyConnection(this.getAnyRemoteConnection(), node);
        }
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.delegate.nodeConnected(node);
    }

    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        this.delegate.disconnectFromNode(node);
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.delegate.getConnectionProfile();
    }

    public TransportConnection getAnyRemoteConnection() {
        long curr;
        List<DiscoveryNode> localConnectedNodes = this.connectedNodes;
        while ((curr = this.counter.incrementAndGet()) == Long.MIN_VALUE) {
        }
        if (!localConnectedNodes.isEmpty()) {
            DiscoveryNode nextNode = localConnectedNodes.get(Math.toIntExact(Math.floorMod(curr, (long)localConnectedNodes.size())));
            try {
                return this.delegate.getConnection(nextNode);
            }
            catch (NodeNotConnectedException nodeNotConnectedException) {
                // empty catch block
            }
        }
        Set<DiscoveryNode> allConnectionNodes = this.getAllConnectedNodes();
        for (DiscoveryNode connectedNode : allConnectionNodes) {
            try {
                return this.delegate.getConnection(connectedNode);
            }
            catch (NodeNotConnectedException nodeNotConnectedException) {
            }
        }
        throw new NoSuchRemoteClusterException(this.clusterAlias);
    }

    @Override
    public Set<DiscoveryNode> getAllConnectedNodes() {
        return this.delegate.getAllConnectedNodes();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void close() {
        this.delegate.closeNoBlock();
    }

    @Override
    public void closeNoBlock() {
        this.delegate.closeNoBlock();
    }

    private synchronized void addConnectedNode(DiscoveryNode addedNode) {
        ArrayList<DiscoveryNode> newConnections = new ArrayList<DiscoveryNode>(this.connectedNodes);
        newConnections.add(addedNode);
        this.connectedNodes = Collections.unmodifiableList(newConnections);
    }

    private synchronized void removeConnectedNode(DiscoveryNode removedNode) {
        int newSize = this.connectedNodes.size() - 1;
        ArrayList<DiscoveryNode> newConnectedNodes = new ArrayList<DiscoveryNode>(newSize);
        for (DiscoveryNode connectedNode : this.connectedNodes) {
            if (connectedNode.equals(removedNode)) continue;
            newConnectedNodes.add(connectedNode);
        }
        assert (newConnectedNodes.size() == newSize) : "Expected connection node count: " + newSize + ", Found: " + newConnectedNodes.size();
        this.connectedNodes = Collections.unmodifiableList(newConnectedNodes);
    }

    static final class ProxyConnection
    implements TransportConnection {
        private final TransportConnection connection;
        private final DiscoveryNode targetNode;

        private ProxyConnection(TransportConnection connection, DiscoveryNode targetNode) {
            this.connection = connection;
            this.targetNode = targetNode;
        }

        @Override
        public DiscoveryNode getNode() {
            return this.targetNode;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            this.connection.sendRequest(requestId, TransportActionProxy.getProxyAction(action), TransportActionProxy.wrapRequest(this.targetNode, request), options);
        }

        @Override
        public void close() {
            assert (false) : "proxy connections must not be closed";
        }

        @Override
        public void addCloseListener(ActionListener<Void> listener) {
            this.connection.addCloseListener(listener);
        }

        @Override
        public boolean isClosed() {
            return this.connection.isClosed();
        }

        @Override
        public Version getVersion() {
            return this.connection.getVersion();
        }

        @Override
        public Object getCacheKey() {
            return this.connection.getCacheKey();
        }
    }
}

