/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.tasks.CancellableTask;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskAwareRequest;
import io.skylite.core.tasks.TaskManager;
import io.skylite.core.transport.BaseTcpTransportChannel;
import io.skylite.core.transport.TaskTransportChannel;
import io.skylite.core.transport.TcpChannel;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import java.io.IOException;

public final class RequestHandler<Request extends TransportRequest> {
    private final String action;
    private final TransportRequestHandler<Request> handler;
    private final boolean forceExecution;
    private final boolean canTripCircuitBreaker;
    private final String executor;
    private final TaskManager taskManager;
    private final Writeable.Reader<Request> requestReader;

    public RequestHandler(String action, Writeable.Reader<Request> requestReader, TaskManager taskManager, TransportRequestHandler<Request> handler, String executor, boolean forceExecution, boolean canTripCircuitBreaker) {
        this.action = action;
        this.requestReader = requestReader;
        this.handler = handler;
        this.forceExecution = forceExecution;
        this.canTripCircuitBreaker = canTripCircuitBreaker;
        this.executor = executor;
        this.taskManager = taskManager;
    }

    public String getAction() {
        return this.action;
    }

    public Request newRequest(StreamInput in) throws IOException {
        return (Request)((TransportRequest)this.requestReader.read(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessageReceived(Request request, TransportChannel channel) throws Exception {
        Task task = this.taskManager.register(channel.getChannelType(), this.action, (TaskAwareRequest)request);
        ThreadContext.StoredContext contextToRestore = this.taskManager.taskExecutionStarted(task);
        Releasable unregisterTask = () -> this.taskManager.unregister(task);
        try {
            if (channel instanceof BaseTcpTransportChannel && task instanceof CancellableTask) {
                if (request instanceof ShardSearchRequest) {
                    ((ShardSearchRequest)request).setInboundNetworkTime(Math.max(0L, System.currentTimeMillis() - ((ShardSearchRequest)request).getInboundNetworkTime()));
                }
                TcpChannel tcpChannel = ((BaseTcpTransportChannel)channel).getChannel();
                Releasable stopTracking = this.taskManager.startTrackingCancellableChannelTask(tcpChannel, (CancellableTask)task);
                unregisterTask = Releasables.wrap((Releasable[])new Releasable[]{unregisterTask, stopTracking});
            }
            TaskTransportChannel taskTransportChannel = new TaskTransportChannel(channel, unregisterTask);
            this.handler.messageReceived(request, taskTransportChannel, task);
            unregisterTask = null;
        }
        finally {
            Releasables.close((Releasable)unregisterTask);
            contextToRestore.restore();
        }
    }

    public boolean isForceExecution() {
        return this.forceExecution;
    }

    public boolean canTripCircuitBreaker() {
        return this.canTripCircuitBreaker;
    }

    public String getExecutor() {
        return this.executor;
    }

    public TransportRequestHandler<Request> getTransportRequestHandler() {
        return this.handler;
    }

    public String toString() {
        return this.handler.toString();
    }

    public static <R extends TransportRequest> RequestHandler<R> replaceHandler(RequestHandler<R> registry, TransportRequestHandler<R> handler) {
        return new RequestHandler(registry.action, registry.requestReader, registry.taskManager, handler, registry.executor, registry.forceExecution, registry.canTripCircuitBreaker);
    }
}

