/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.MapBuilder;
import io.skylite.common.lifecycle.LifecycleComponent;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.common.util.concurrent.ConcurrentMapLong;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.transport.BoundTransportAddress;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.transport.ConnectionProfile;
import io.skylite.core.transport.RequestHandler;
import io.skylite.core.transport.TransportConnection;
import io.skylite.core.transport.TransportMessageListener;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportStats;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public interface Transport
extends LifecycleComponent {
    default public <Request extends TransportRequest> void registerRequestHandler(RequestHandler<Request> reg) {
        this.getRequestHandlers().registerHandler(reg);
    }

    public void setMessageListener(TransportMessageListener var1);

    default public void setSlowLogThreshold(TimeValue slowLogThreshold) {
    }

    default public boolean isSecure() {
        return false;
    }

    public BoundTransportAddress boundAddress();

    public Map<String, BoundTransportAddress> profileBoundAddresses();

    public TransportAddress[] addressesFromString(String var1) throws UnknownHostException;

    public List<String> getDefaultSeedAddresses();

    public void openConnection(DiscoveryNode var1, ConnectionProfile var2, ActionListener<TransportConnection> var3);

    public TransportStats getStats();

    public ResponseHandlers getResponseHandlers();

    public RequestHandlers getRequestHandlers();

    public static final class RequestHandlers {
        private volatile Map<String, RequestHandler<? extends TransportRequest>> requestHandlers = Collections.emptyMap();

        synchronized <Request extends TransportRequest> void registerHandler(RequestHandler<Request> reg) {
            if (this.requestHandlers.containsKey(reg.getAction())) {
                throw new IllegalArgumentException("transport handlers for action " + reg.getAction() + " is already registered");
            }
            this.requestHandlers = MapBuilder.newMapBuilder(this.requestHandlers).put((Object)reg.getAction(), reg).immutableMap();
        }

        public synchronized <Request extends TransportRequest> void forceRegister(RequestHandler<Request> reg) {
            this.requestHandlers = MapBuilder.newMapBuilder(this.requestHandlers).put((Object)reg.getAction(), reg).immutableMap();
        }

        public <T extends TransportRequest> RequestHandler<T> getHandler(String action) {
            return this.requestHandlers.get(action);
        }
    }

    public static final class ResponseHandlers {
        private final ConcurrentMapLong<ResponseContext<? extends TransportResponse>> handlers = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
        private final AtomicLong requestIdGenerator = new AtomicLong();

        public boolean contains(long requestId) {
            return this.handlers.containsKey((Object)requestId);
        }

        public ResponseContext<? extends TransportResponse> remove(long requestId) {
            return (ResponseContext)this.handlers.remove(requestId);
        }

        public long add(ResponseContext<? extends TransportResponse> holder) {
            long requestId = this.newRequestId();
            ResponseContext existing = (ResponseContext)this.handlers.put(requestId, holder);
            assert (existing == null) : "request ID already in use: " + requestId;
            return requestId;
        }

        long newRequestId() {
            return this.requestIdGenerator.incrementAndGet();
        }

        public List<ResponseContext<? extends TransportResponse>> prune(Predicate<ResponseContext<? extends TransportResponse>> predicate) {
            ArrayList<ResponseContext<? extends TransportResponse>> holders = new ArrayList<ResponseContext<? extends TransportResponse>>();
            for (Map.Entry entry : this.handlers.entrySet()) {
                ResponseContext remove;
                ResponseContext holder = (ResponseContext)entry.getValue();
                if (!predicate.test(holder) || (remove = (ResponseContext)this.handlers.remove(entry.getKey())) == null) continue;
                holders.add(holder);
            }
            return holders;
        }

        public TransportResponseHandler<? extends TransportResponse> onResponseReceived(long requestId, TransportMessageListener listener) {
            ResponseContext context = (ResponseContext)this.handlers.remove(requestId);
            listener.onResponseReceived(requestId, context);
            if (context == null) {
                return null;
            }
            return context.handler();
        }
    }

    public static final class ResponseContext<T extends TransportResponse> {
        private final TransportResponseHandler<T> handler;
        private final TransportConnection connection;
        private final String action;

        ResponseContext(TransportResponseHandler<T> handler, TransportConnection connection, String action) {
            this.handler = handler;
            this.connection = connection;
            this.action = action;
        }

        public TransportResponseHandler<T> handler() {
            return this.handler;
        }

        public TransportConnection connection() {
            return this.connection;
        }

        public String action() {
            return this.action;
        }
    }
}

