/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.tasks.TaskAwareRequest;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.transport.TransportMessage;
import java.io.IOException;

public abstract class TransportRequest
extends TransportMessage
implements TaskAwareRequest {
    private TaskId parentTaskId = TaskId.EMPTY_TASK_ID;

    public TransportRequest() {
    }

    public TransportRequest(StreamInput in) throws IOException {
        this.parentTaskId = TaskId.readFromStream(in);
    }

    @Override
    public void setParentTask(TaskId taskId) {
        this.parentTaskId = taskId;
    }

    @Override
    public TaskId getParentTask() {
        return this.parentTaskId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.parentTaskId.writeTo(out);
    }

    public static class Empty
    extends TransportRequest {
        public static final Empty INSTANCE = new Empty();

        public Empty() {
        }

        public Empty(StreamInput in) throws IOException {
            super(in);
        }
    }
}

