/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.util;

import java.util.Comparator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.InPlaceMergeSorter;

public class BytesRefUtils {
    public static void sort(BytesRefArray bytes, int[] indices) {
        BytesRefUtils.sort(new BytesRefBuilder(), new BytesRefBuilder(), bytes, indices);
    }

    private static void sort(final BytesRefBuilder scratch, final BytesRefBuilder scratch1, final BytesRefArray bytes, final int[] indices) {
        int numValues = bytes.size();
        assert (indices.length >= numValues);
        if (numValues > 1) {
            new InPlaceMergeSorter(){
                final Comparator<BytesRef> comparator = Comparator.naturalOrder();

                protected int compare(int i, int j) {
                    return this.comparator.compare(bytes.get(scratch, indices[i]), bytes.get(scratch1, indices[j]));
                }

                protected void swap(int i, int j) {
                    int value_i = indices[i];
                    indices[i] = indices[j];
                    indices[j] = value_i;
                }
            }.sort(0, numValues);
        }
    }

    public static int sortAndDedup(BytesRefArray bytes, int[] indices) {
        BytesRefBuilder scratch = new BytesRefBuilder();
        BytesRefBuilder scratch1 = new BytesRefBuilder();
        int numValues = bytes.size();
        assert (indices.length >= numValues);
        if (numValues <= 1) {
            return numValues;
        }
        BytesRefUtils.sort(scratch, scratch1, bytes, indices);
        int uniqueCount = 1;
        BytesRefBuilder previous = scratch;
        BytesRefBuilder current = scratch1;
        bytes.get(previous, indices[0]);
        for (int i = 1; i < numValues; ++i) {
            bytes.get(current, indices[i]);
            if (!previous.get().equals((Object)current.get())) {
                indices[uniqueCount++] = indices[i];
            }
            BytesRefBuilder tmp = previous;
            previous = current;
            current = tmp;
        }
        return uniqueCount;
    }

    public static long bytesToLong(BytesRef bytes) {
        int high = bytes.bytes[bytes.offset + 0] << 24 | (bytes.bytes[bytes.offset + 1] & 0xFF) << 16 | (bytes.bytes[bytes.offset + 2] & 0xFF) << 8 | bytes.bytes[bytes.offset + 3] & 0xFF;
        int low = bytes.bytes[bytes.offset + 4] << 24 | (bytes.bytes[bytes.offset + 5] & 0xFF) << 16 | (bytes.bytes[bytes.offset + 6] & 0xFF) << 8 | bytes.bytes[bytes.offset + 7] & 0xFF;
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }
}

