/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.xcontent;

import io.skylite.common.Nullable;
import io.skylite.common.lease.Releasable;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.bytes.CompositeBytesReference;
import io.skylite.core.http.HttpChunk;
import io.skylite.core.xcontent.XContentBuilder;

public final class XContentHttpChunk
implements HttpChunk {
    private static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private final BytesReference content;

    public static HttpChunk from(@Nullable XContentBuilder builder) {
        return new XContentHttpChunk(builder);
    }

    public static HttpChunk last() {
        return new XContentHttpChunk(null);
    }

    private XContentHttpChunk(@Nullable XContentBuilder builder) {
        this.content = builder == null ? BytesArray.EMPTY : CompositeBytesReference.of(BytesReference.bytes(builder), new BytesArray(CHUNK_SEPARATOR));
    }

    @Override
    public boolean isLast() {
        return this.content == BytesArray.EMPTY;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    public void close() {
        if (this.content instanceof Releasable) {
            ((Releasable)this.content).close();
        }
    }
}

