/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.xcontent.util;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class XContentUtils {
    private XContentUtils() {
    }

    public static XContentParser createJsonParser(StreamInput in) throws IOException {
        return MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, in);
    }

    public static XContentParser contentParserNextToken(RestRequest request) throws IOException {
        XContentParser parser = request.contentParser();
        parser.nextToken();
        return parser;
    }

    public static List<String> stringList(XContentParser parser) throws IOException {
        ArrayList<String> retList = new ArrayList<String>();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            retList.add(parser.text());
        }
        return retList;
    }

    public static XContentBuilder fieldIfNotNull(XContentBuilder builder, String name, Object value) throws IOException {
        if (value != null) {
            builder.field(name, value);
        }
        return builder;
    }

    public static XContentBuilder objectIfNotNull(XContentBuilder builder, String name, ToXContentObject xContentObject) throws IOException {
        if (xContentObject != null) {
            builder.field(name);
            xContentObject.toXContent(builder, ToXContent.EMPTY_PARAMS);
        }
        return builder;
    }

    public static <T extends ToXContent> List<T> objectList(XContentParser parser, XParserFunction<T> block) throws IOException {
        ArrayList<ToXContent> retList = new ArrayList<ToXContent>();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            retList.add((ToXContent)block.apply(parser));
        }
        return retList;
    }

    @FunctionalInterface
    public static interface XParserFunction<T> {
        public T apply(XContentParser var1) throws IOException;
    }
}

