/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.clustering.kmeans;

import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import java.util.logging.Logger;
import org.tribuo.clustering.kmeans.KMeansTrainer;
import org.tribuo.math.distance.DistanceType;

public class KMeansOptions
implements Options {
    private static final Logger logger = Logger.getLogger(KMeansOptions.class.getName());
    @Option(longName="kmeans-interations", usage="Iterations of the k-means algorithm. Defaults to 10.")
    public int iterations = 10;
    @Option(longName="kmeans-num-centroids", usage="Number of centroids in K-Means. Defaults to 10.")
    public int centroids = 10;
    @Option(longName="kmeans-distance-type", usage="The type of distance function to use for various distance calculations.")
    public DistanceType distType = DistanceType.L2;
    @Option(longName="kmeans-initialisation", usage="Initialisation function in K-Means. Defaults to RANDOM.")
    public KMeansTrainer.Initialisation initialisation = KMeansTrainer.Initialisation.RANDOM;
    @Option(longName="kmeans-num-threads", usage="Number of computation threads in K-Means. Defaults to 4.")
    public int numThreads = 4;
    @Option(longName="kmeans-seed", usage="Sets the random seed for K-Means.")
    private long seed = 12345L;

    public KMeansTrainer getTrainer() {
        logger.info("Configuring K-Means Trainer");
        return new KMeansTrainer(this.centroids, this.iterations, this.distType.getDistance(), this.initialisation, this.numThreads, this.seed);
    }
}

