/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.core.ParseField;
import io.skylite.core.analysis.NamedAnalyzer;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.NumberFieldMapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.opensearch.index.mapper.DocValueFetcher;

public class TokenCountFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "token_count";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean index;
    private final boolean hasDocValues;
    private final boolean store;
    private final NamedAnalyzer analyzer;
    private final boolean enablePositionIncrements;
    private final Integer nullValue;

    private static TokenCountFieldMapper toType(FieldMapper in) {
        return (TokenCountFieldMapper)in;
    }

    protected TokenCountFieldMapper(String simpleName, MappedFieldType defaultFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, defaultFieldType, multiFields, copyTo);
        this.analyzer = (NamedAnalyzer)builder.analyzer.getValue();
        this.enablePositionIncrements = (Boolean)builder.enablePositionIncrements.getValue();
        this.nullValue = (Integer)builder.nullValue.getValue();
        this.index = (Boolean)builder.index.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.store = (Boolean)builder.store.getValue();
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null && this.nullValue == null) {
            return;
        }
        int tokenCount = value == null ? this.nullValue : TokenCountFieldMapper.countPositions((Analyzer)this.analyzer, this.name(), value, this.enablePositionIncrements);
        context.doc().addAll(NumberFieldMapper.NumberType.INTEGER.createFields(this.fieldType().name(), (Number)tokenCount, this.index, this.hasDocValues, this.store));
    }

    static int countPositions(Analyzer analyzer, String fieldName, String fieldValue, boolean enablePositionIncrements) throws IOException {
        try (TokenStream tokenStream = analyzer.tokenStream(fieldName, fieldValue);){
            int count = 0;
            PositionIncrementAttribute position = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                if (enablePositionIncrements) {
                    count += position.getPositionIncrement();
                    continue;
                }
                count += Math.min(1, position.getPositionIncrement());
            }
            tokenStream.end();
            if (enablePositionIncrements) {
                count += position.getPositionIncrement();
            }
            int n = count;
            return n;
        }
    }

    public String analyzer() {
        return this.analyzer.name();
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> TokenCountFieldMapper.toType((FieldMapper)m).index, (boolean)true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> TokenCountFieldMapper.toType((FieldMapper)m).hasDocValues, (boolean)true);
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> TokenCountFieldMapper.toType((FieldMapper)m).store, (boolean)false);
        private final FieldMapper.Parameter<NamedAnalyzer> analyzer = FieldMapper.Parameter.analyzerParam((String)"analyzer", (boolean)true, m -> TokenCountFieldMapper.toType((FieldMapper)m).analyzer, () -> null);
        private final FieldMapper.Parameter<Integer> nullValue = new FieldMapper.Parameter(ParseField.CommonFields.NULL_VALUE.getPreferredName(), false, () -> null, (n, c, o) -> o == null ? null : Integer.valueOf(XContentMapValuesUtil.nodeIntegerValue((Object)o)), m -> TokenCountFieldMapper.toType((FieldMapper)m).nullValue).acceptsNull();
        private final FieldMapper.Parameter<Boolean> enablePositionIncrements = FieldMapper.Parameter.boolParam((String)"enable_position_increments", (boolean)false, m -> TokenCountFieldMapper.toType((FieldMapper)m).enablePositionIncrements, (boolean)true);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.index, this.hasDocValues, this.store, this.analyzer, this.nullValue, this.enablePositionIncrements, this.meta);
        }

        public TokenCountFieldMapper build(ContentPath contentPath) {
            if (this.analyzer.getValue() == null) {
                throw new MapperParsingException("Analyzer must be set for field [" + this.name + "] but wasn't.");
            }
            TokenCountFieldType ft = new TokenCountFieldType(this.buildFullName(contentPath), (Boolean)this.index.getValue(), (Boolean)this.store.getValue(), (Boolean)this.hasDocValues.getValue(), (Number)this.nullValue.getValue(), (Map)this.meta.getValue());
            return new TokenCountFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build(), this);
        }
    }

    static class TokenCountFieldType
    extends NumberFieldMapper.NumberFieldType {
        TokenCountFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, Number nullValue, Map<String, String> meta) {
            super(name, NumberFieldMapper.NumberType.INTEGER, isSearchable, isStored, hasDocValues, false, nullValue, meta);
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (!this.hasDocValues()) {
                return lookup -> List.of();
            }
            return new DocValueFetcher(this.docValueFormat(format, null), searchLookup.getForField((BaseMappedFieldType)this));
        }
    }
}

