/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.agents;

import io.lucenia.ml.common.engine.systemindices.MLIndicesHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.PutDataObjectRequest;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.ml.common.agent.MLAgent;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.agent.MLRegisterAgentRequest;
import io.skylite.ml.common.transport.agent.MLRegisterAgentResponse;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportRegisterAgentAction
extends HandledTransportAction<ActionRequest, MLRegisterAgentResponse> {
    private static final Logger log = LogManager.getLogger(TransportRegisterAgentAction.class);
    MLIndicesHandler mlIndicesHandler;
    Client client;
    MetadataClient sdkClient;
    ClusterService clusterService;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportRegisterAgentAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, MLIndicesHandler mlIndicesHandler, ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/agents/register", transportService, actionFilters, MLRegisterAgentRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlIndicesHandler = mlIndicesHandler;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLRegisterAgentResponse> listener) {
        User user = RestActionUtils.getUserContext(this.client);
        MLRegisterAgentRequest registerAgentRequest = MLRegisterAgentRequest.fromActionRequest((ActionRequest)request);
        MLAgent mlAgent = registerAgentRequest.getMlAgent();
        this.registerAgent(mlAgent, listener);
    }

    private void registerAgent(MLAgent agent, ActionListener<MLRegisterAgentResponse> listener) {
        Instant now = Instant.now();
        boolean isHiddenAgent = RestActionUtils.isSuperAdminUser(this.clusterService, this.client);
        MLAgent mlAgent = agent.toBuilder().createdTime(now).lastUpdateTime(now).isHidden(Boolean.valueOf(isHiddenAgent)).build();
        String tenantId = agent.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, listener)) {
            return;
        }
        this.mlIndicesHandler.initMLAgentIndex((ActionListener<Boolean>)ActionListenerHelper.wrap(result -> {
            if (result.booleanValue()) {
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    this.sdkClient.putDataObjectAsync(((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(".plugins-ml-agent")).tenantId(tenantId)).dataObject((ToXContentObject)mlAgent).build()).whenComplete((r, throwable) -> {
                        context.restore();
                        if (throwable != null) {
                            Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                            log.error("Failed to index ML agent", (Throwable)cause);
                            listener.onFailure(cause);
                        } else {
                            try {
                                IndexResponse indexResponse = r.indexResponse();
                                log.info("Agent creation result: {}, Agent id: {}", (Object)indexResponse.getResult(), (Object)indexResponse.getId());
                                MLRegisterAgentResponse response = new MLRegisterAgentResponse(r.id());
                                listener.onResponse((Object)response);
                            }
                            catch (Exception e) {
                                listener.onFailure(e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    log.error("Failed to index ML agent", (Throwable)e);
                    listener.onFailure(e);
                }
            } else {
                log.error("Failed to create ML agent index");
                listener.onFailure((Exception)new SkyliteException("Failed to create ML agent index", new Object[0]));
            }
        }, e -> {
            log.error("Failed to create ML agent index", (Throwable)e);
            listener.onFailure(e);
        }));
    }
}

