/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.config;

import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.client.MLConfig;
import io.skylite.ml.common.cluster.MLNodeUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.config.MLConfigGetRequest;
import io.skylite.ml.common.transport.config.MLConfigGetResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetConfigTransportAction
extends HandledTransportAction<ActionRequest, MLConfigGetResponse> {
    private static final Logger log = LogManager.getLogger(GetConfigTransportAction.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public GetConfigTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/config/get", transportService, actionFilters, MLConfigGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLConfigGetResponse> actionListener) {
        MLConfigGetRequest mlConfigGetRequest = MLConfigGetRequest.fromActionRequest((ActionRequest)request);
        String configId = mlConfigGetRequest.getConfigId();
        String tenantId = mlConfigGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        GetRequest getRequest = new GetRequest(".plugins-ml-config").id(configId);
        if (configId.equals("master_key")) {
            actionListener.onFailure((Exception)new SkyliteStatusException("You are not allowed to access this config doc", RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, ActionListenerHelper.runBefore((ActionListener)ActionListenerHelper.wrap(r -> {
                log.debug("Completed Get Agent Request, id:{}", (Object)configId);
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry((NamedXContentRegistry)this.xContentRegistry, (BytesReference)r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLConfig mlConfig = MLConfig.parse((XContentParser)parser);
                        actionListener.onResponse((Object)MLConfigGetResponse.builder().mlConfig(mlConfig).build());
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml config{}", (Object)r.getId());
                        actionListener.onFailure(e);
                    }
                } else {
                    actionListener.onFailure((Exception)new SkyliteStatusException("Failed to find config with the provided config id: " + configId, RestStatus.NOT_FOUND, new Object[0]));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    log.error("Failed to get agent index", (Throwable)e);
                    actionListener.onFailure((Exception)new SkyliteStatusException("Failed to get config index", RestStatus.NOT_FOUND, new Object[0]));
                } else {
                    log.error("Failed to get ML config {}", (Object)configId);
                    actionListener.onFailure(e);
                }
            }), () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            log.error("Failed to get ML config {}", (Object)configId);
            actionListener.onFailure(e2);
        }
    }
}

