/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.connector;

import io.lucenia.ml.common.engine.encryptors.AWSEncryptorImpl;
import io.lucenia.ml.common.helpers.ConnectorAccessControlHelper;
import io.skylite.ResourceNotFoundException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.script.ScriptService;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.engine.MLEngineClassLoader;
import io.skylite.ml.common.remote.RemoteConnectorExecutor;
import io.skylite.ml.common.transport.MLTaskResponse;
import io.skylite.ml.common.transport.connector.MLConnectorDeleteRequest;
import io.skylite.ml.common.transport.connector.MLExecuteConnectorRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecuteConnectorTransportAction
extends HandledTransportAction<ActionRequest, MLTaskResponse> {
    private static final Logger log = LogManager.getLogger(ExecuteConnectorTransportAction.class);
    Client client;
    ClusterService clusterService;
    ScriptService scriptService;
    NamedXContentRegistry xContentRegistry;
    ConnectorAccessControlHelper connectorAccessControlHelper;
    AWSEncryptorImpl encryptor;

    @Inject
    public ExecuteConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, ConnectorAccessControlHelper connectorAccessControlHelper, AWSEncryptorImpl encryptor) {
        super("cluster:admin/lucenia/ml/connectors/execute", transportService, actionFilters, MLConnectorDeleteRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.encryptor = encryptor;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLTaskResponse> actionListener) {
        MLExecuteConnectorRequest executeConnectorRequest = MLExecuteConnectorRequest.fromActionRequest((ActionRequest)request);
        String connectorId = executeConnectorRequest.getConnectorId();
        String connectorAction = ConnectorAction.ActionType.EXECUTE.name();
        if (this.clusterService.state().metadata().hasIndex(".plugins-ml-connector")) {
            ActionListener listener = ActionListenerHelper.wrap(connector -> {
                if (this.connectorAccessControlHelper.validateConnectorAccess(this.client, (Connector)connector)) {
                    connector.decrypt(connectorAction, (credential, tenantId) -> this.encryptor.decrypt((String)credential, null), null);
                    RemoteConnectorExecutor connectorExecutor = (RemoteConnectorExecutor)MLEngineClassLoader.initInstance((Object)connector.getProtocol(), (Object)connector, Connector.class);
                    connectorExecutor.setScriptService(this.scriptService);
                    connectorExecutor.setClusterService(this.clusterService);
                    connectorExecutor.setClient((ReleasableSkyliteClient)this.client);
                    connectorExecutor.setXContentRegistry(this.xContentRegistry);
                    connectorExecutor.executeAction(connectorAction, executeConnectorRequest.getMlInput(), ActionListenerHelper.wrap(taskResponse -> actionListener.onResponse(taskResponse), e -> actionListener.onFailure(e)));
                }
            }, e -> {
                log.error("Failed to get connector " + connectorId, (Throwable)e);
                actionListener.onFailure(e);
            });
            try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                this.connectorAccessControlHelper.getConnector(this.client, connectorId, (ActionListener<Connector>)ActionListenerHelper.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)threadContext).restore()));
            }
        } else {
            actionListener.onFailure((Exception)new ResourceNotFoundException("Can't find connector " + connectorId, new Object[0]));
        }
    }
}

