/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.connector;

import io.lucenia.ml.common.helpers.ConnectorAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.connector.MLConnectorGetRequest;
import io.skylite.ml.common.transport.connector.MLConnectorGetResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetConnectorTransportAction
extends HandledTransportAction<ActionRequest, MLConnectorGetResponse> {
    private static final Logger log = LogManager.getLogger(GetConnectorTransportAction.class);
    private final Client client;
    private final MetadataClient sdkClient;
    ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public GetConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, ConnectorAccessControlHelper connectorAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/connectors/get", transportService, actionFilters, MLConnectorGetRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLConnectorGetResponse> actionListener) {
        MLConnectorGetRequest mlConnectorGetRequest = MLConnectorGetRequest.fromActionRequest((ActionRequest)request);
        String connectorId = mlConnectorGetRequest.getConnectorId();
        String tenantId = mlConnectorGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(mlConnectorGetRequest.isReturnContent());
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-connector")).id(connectorId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.connectorAccessControlHelper.getConnector(this.sdkClient, this.client, context, getDataObjectRequest, connectorId, (ActionListener<Connector>)ActionListenerHelper.wrap(connector -> this.handleConnectorAccessValidation(user, tenantId, (Connector)connector, actionListener), e -> this.handleConnectorAccessValidationFailure(connectorId, (Exception)e, actionListener)));
        }
        catch (Exception e2) {
            log.error("Failed to get ML connector {}", (Object)connectorId);
            actionListener.onFailure(e2);
        }
    }

    private void handleConnectorAccessValidation(User user, String tenantId, Connector mlConnector, ActionListener<MLConnectorGetResponse> actionListener) {
        if (TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)mlConnector.getTenantId(), actionListener)) {
            if (this.connectorAccessControlHelper.hasPermission(user, mlConnector)) {
                actionListener.onResponse((Object)MLConnectorGetResponse.builder().mlConnector(mlConnector).build());
            } else {
                actionListener.onFailure((Exception)new SkyliteStatusException("You don't have permission to access this connector", RestStatus.FORBIDDEN, new Object[0]));
            }
        }
    }

    private void handleConnectorAccessValidationFailure(String connectorId, Exception e, ActionListener<MLConnectorGetResponse> actionListener) {
        log.error("Failed to get ML connector: {}", (Object)connectorId);
        actionListener.onFailure(e);
    }
}

