/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.connector;

import io.lucenia.ml.common.action.handler.MLSearchHandler;
import io.lucenia.ml.common.helpers.ConnectorAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.lucenia.ml.common.transport.search.MLSearchActionRequest;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchResponseSections;
import io.skylite.core.action.search.ShardSearchFailure;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.search.internal.InternalSearchResponse;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class SearchConnectorTransportAction
extends HandledTransportAction<MLSearchActionRequest, SearchResponse> {
    private static final Logger log = LogManager.getLogger(SearchConnectorTransportAction.class);
    private final Client client;
    private final MetadataClient sdkClient;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public SearchConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, ConnectorAccessControlHelper connectorAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/connectors/search", transportService, actionFilters, MLSearchActionRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, MLSearchActionRequest request, ActionListener<SearchResponse> actionListener) {
        request.indices(new String[]{".plugins-ml-connector"});
        String tenantId = request.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        this.search(request, tenantId, actionListener);
    }

    private void search(SearchRequest request, String tenantId, ActionListener<SearchResponse> actionListener) {
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            List excludes = Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::excludes).map(x -> Arrays.stream(x).collect(Collectors.toList())).orElse(new ArrayList());
            excludes.add("credential");
            FetchSourceContext rebuiltFetchSourceContext = new FetchSourceContext(Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::fetchSource).orElse(true).booleanValue(), (String[])Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::includes).orElse(null), excludes.toArray(new String[0]));
            request.source().fetchSource(rebuiltFetchSourceContext);
            ActionListener doubleWrappedListener = ActionListenerHelper.wrap(arg_0 -> ((ActionListener)wrappedListener).onResponse(arg_0), e -> MLSearchHandler.wrapListenerToHandleSearchIndexNotFound(e, (ActionListener<SearchResponse>)wrappedListener));
            if (tenantId != null) {
                BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
                if (request.source().query() != null) {
                    queryBuilder.must(request.source().query());
                }
                queryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"tenant_id", (String)tenantId));
                request.source().query((QueryBuilder)queryBuilder);
            }
            if (this.connectorAccessControlHelper.skipConnectorAccessControl(user)) {
                this.client.search(request, doubleWrappedListener);
            } else {
                SearchSourceBuilder sourceBuilder = this.connectorAccessControlHelper.addUserBackendRolesFilter(user, request.source());
                request.source(sourceBuilder);
                this.client.search(request, doubleWrappedListener);
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    public static void wrapListenerToHandleConnectorIndexNotFound(Exception e, ActionListener<SearchResponse> listener) {
        if (SkyliteExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
            log.debug("Connectors index not created yet, therefore we will swallow the exception and return an empty search result");
            InternalSearchResponse internalSearchResponse = InternalSearchResponse.empty();
            SearchResponse emptySearchResponse = new SearchResponse((SearchResponseSections)internalSearchResponse, null, 0, 0, 0, 0L, new ShardSearchFailure[0], SearchResponse.Clusters.EMPTY, null);
            listener.onResponse((Object)emptySearchResponse);
        } else {
            listener.onFailure(e);
        }
    }
}

