/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.connector;

import io.lucenia.ml.common.engine.systemindices.MLIndicesHandler;
import io.lucenia.ml.common.helpers.ConnectorAccessControlHelper;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.PutDataObjectRequest;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.engine.MLEngine;
import io.skylite.ml.common.exception.MLMetadataException;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.connector.MLCreateConnectorInput;
import io.skylite.ml.common.transport.connector.MLCreateConnectorRequest;
import io.skylite.ml.common.transport.connector.MLCreateConnectorResponse;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportCreateConnectorAction
extends HandledTransportAction<ActionRequest, MLCreateConnectorResponse> {
    private static final Logger log = LogManager.getLogger(TransportCreateConnectorAction.class);
    private final MLIndicesHandler mlIndicesHandler;
    private final Client client;
    private final MetadataClient sdkClient;
    private final MLEngine mlEngine;
    private final MLModelManager mlModelManager;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private volatile List<String> trustedConnectorEndpointsRegex;

    @Inject
    public TransportCreateConnectorAction(TransportService transportService, ActionFilters actionFilters, MLIndicesHandler mlIndicesHandler, Client client, MetadataClient sdkClient, MLEngine mlEngine, ConnectorAccessControlHelper connectorAccessControlHelper, Settings settings, ClusterService clusterService, MLModelManager mlModelManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/create_connector", transportService, actionFilters, MLCreateConnectorRequest::new);
        this.mlIndicesHandler = mlIndicesHandler;
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlEngine = mlEngine;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlModelManager = mlModelManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.trustedConnectorEndpointsRegex = (List)MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX, it -> {
            this.trustedConnectorEndpointsRegex = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLCreateConnectorResponse> listener) {
        MLCreateConnectorRequest mlCreateConnectorRequest = MLCreateConnectorRequest.fromActionRequest((ActionRequest)request);
        MLCreateConnectorInput mlCreateConnectorInput = mlCreateConnectorRequest.getMlCreateConnectorInput();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)mlCreateConnectorInput.getTenantId(), listener)) {
            return;
        }
        if (mlCreateConnectorInput.isDryRun()) {
            MLCreateConnectorResponse response = new MLCreateConnectorResponse("dryRunConnector");
            listener.onResponse((Object)response);
            return;
        }
        String connectorName = mlCreateConnectorInput.getName();
        try {
            XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder();
            mlCreateConnectorInput.toXContent(builder, ToXContent.EMPTY_PARAMS);
            Connector connector = Connector.createConnector((XContentBuilder)builder, (String)mlCreateConnectorInput.getProtocol());
            connector.validateConnectorURL(this.trustedConnectorEndpointsRegex);
            User user = RestActionUtils.getUserContext(this.client);
            if (this.connectorAccessControlHelper.accessControlNotEnabled(user)) {
                this.validateSecurityDisabledOrConnectorAccessControlDisabled(mlCreateConnectorInput);
                this.indexConnector(connector, listener);
            } else {
                this.validateRequest4AccessControl(mlCreateConnectorInput, user);
                if (Boolean.TRUE.equals(mlCreateConnectorInput.getAddAllBackendRoles())) {
                    mlCreateConnectorInput.setBackendRoles(user.getBackendRoles());
                }
                connector.setBackendRoles(mlCreateConnectorInput.getBackendRoles());
                connector.setOwner(user);
                connector.setAccess(mlCreateConnectorInput.getAccess());
                this.indexConnector(connector, listener);
            }
        }
        catch (MLMetadataException e) {
            log.error("The masterKey for credential encryption is missing in connector creation");
            listener.onFailure((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error("Failed to create connector " + connectorName, (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void indexConnector(Connector connector, ActionListener<MLCreateConnectorResponse> listener) {
        connector.encrypt((arg_0, arg_1) -> ((MLEngine)this.mlEngine).encrypt(arg_0, arg_1), connector.getTenantId());
        log.info("connector created, indexing into the connector system index");
        this.mlIndicesHandler.initMLConnectorIndex((ActionListener<Boolean>)ActionListenerHelper.wrap(indexCreated -> {
            if (!indexCreated.booleanValue()) {
                listener.onFailure((Exception)new RuntimeException("No response to create ML Connector index"));
                return;
            }
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                Instant currentTime = Instant.now();
                connector.setCreatedTime(currentTime);
                connector.setLastUpdateTime(currentTime);
                this.sdkClient.putDataObjectAsync(((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().tenantId(connector.getTenantId())).index(".plugins-ml-connector")).dataObject((ToXContentObject)connector).build()).whenComplete((r, throwable) -> {
                    context.restore();
                    if (throwable != null) {
                        Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        log.error("Failed to create ML connector", (Throwable)cause);
                        listener.onFailure(cause);
                    } else {
                        try {
                            IndexResponse indexResponse = r.indexResponse();
                            log.info("Connector creation result: {}, connector id: {}", (Object)indexResponse.getResult(), (Object)indexResponse.getId());
                            listener.onResponse((Object)new MLCreateConnectorResponse(indexResponse.getId()));
                        }
                        catch (Exception e) {
                            listener.onFailure(e);
                        }
                    }
                });
            }
            catch (Exception e) {
                log.error("Failed to save ML connector", (Throwable)e);
                listener.onFailure(e);
            }
        }, e -> {
            log.error("Failed to init ML connector index", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void validateRequest4AccessControl(MLCreateConnectorInput input, User user) {
        Boolean isAddAllBackendRoles = input.getAddAllBackendRoles();
        if (this.connectorAccessControlHelper.isAdmin(user) && Boolean.TRUE.equals(isAddAllBackendRoles)) {
            throw new IllegalArgumentException("Admin can't add all backend roles");
        }
        AccessMode accessMode = input.getAccess();
        if (accessMode == null) {
            if (!CollectionUtils.isEmpty((Collection)input.getBackendRoles()) || Boolean.TRUE.equals(isAddAllBackendRoles)) {
                input.setAccess(AccessMode.RESTRICTED);
                accessMode = AccessMode.RESTRICTED;
            } else {
                input.setAccess(AccessMode.PRIVATE);
                accessMode = AccessMode.PRIVATE;
            }
        }
        if (!(AccessMode.PUBLIC != accessMode && AccessMode.PRIVATE != accessMode || CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && !Boolean.TRUE.equals(isAddAllBackendRoles))) {
            throw new IllegalArgumentException("You can specify backend roles only for a connector with the restricted access mode.");
        }
        if (AccessMode.RESTRICTED == accessMode) {
            if (Boolean.TRUE.equals(isAddAllBackendRoles)) {
                if (!CollectionUtils.isEmpty((Collection)input.getBackendRoles())) {
                    throw new IllegalArgumentException("You can't specify backend roles and add all backend roles to true at same time.");
                }
                if (CollectionUtils.isEmpty((Collection)user.getBackendRoles())) {
                    throw new IllegalArgumentException("You must have at least one backend role to create a connector.");
                }
            } else {
                if (CollectionUtils.isEmpty((Collection)input.getBackendRoles())) {
                    throw new IllegalArgumentException("You must specify at least one backend role or make the connector public/private for registering it.");
                }
                if (!this.connectorAccessControlHelper.isAdmin(user) && !new HashSet(user.getBackendRoles()).containsAll(input.getBackendRoles())) {
                    throw new IllegalArgumentException("You don't have the backend roles specified.");
                }
            }
        }
    }

    private void validateSecurityDisabledOrConnectorAccessControlDisabled(MLCreateConnectorInput input) {
        if (input.getAccess() != null || input.getAddAllBackendRoles() != null || !CollectionUtils.isEmpty((Collection)input.getBackendRoles())) {
            throw new IllegalArgumentException("You cannot specify connector access control parameters because the Security plugin or connector access control is disabled on your cluster.");
        }
    }
}

