/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.connector;

import io.lucenia.ml.common.helpers.ConnectorAccessControlHelper;
import io.lucenia.ml.common.model.MLModelManager;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.SearchDataObjectRequest;
import io.skylite.core.client.metadata.UpdateDataObjectRequest;
import io.skylite.core.client.metadata.UpdateDataObjectResponse;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.engine.MLEngine;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.connector.MLCreateConnectorInput;
import io.skylite.ml.common.transport.connector.MLUpdateConnectorRequest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class UpdateConnectorTransportAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    private static final Logger log = LogManager.getLogger(UpdateConnectorTransportAction.class);
    private final Client client;
    private final MetadataClient sdkClient;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MLModelManager mlModelManager;
    private final MLEngine mlEngine;
    private volatile List<String> trustedConnectorEndpointsRegex;

    @Inject
    public UpdateConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, ConnectorAccessControlHelper connectorAccessControlHelper, MLModelManager mlModelManager, Settings settings, ClusterService clusterService, MLEngine mlEngine, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/connectors/update", transportService, actionFilters, MLUpdateConnectorRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlModelManager = mlModelManager;
        this.mlEngine = mlEngine;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.trustedConnectorEndpointsRegex = (List)MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX, it -> {
            this.trustedConnectorEndpointsRegex = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> listener) {
        MLUpdateConnectorRequest mlUpdateConnectorAction = MLUpdateConnectorRequest.fromActionRequest((ActionRequest)request);
        MLCreateConnectorInput mlCreateConnectorInput = mlUpdateConnectorAction.getUpdateContent();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)mlCreateConnectorInput.getTenantId(), listener)) {
            return;
        }
        String connectorId = mlUpdateConnectorAction.getConnectorId();
        String tenantId = mlCreateConnectorInput.getTenantId();
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-connector")).id(connectorId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.connectorAccessControlHelper.getConnector(this.sdkClient, this.client, context, getDataObjectRequest, connectorId, (ActionListener<Connector>)ActionListenerHelper.wrap(connector -> {
                if (TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)connector.getTenantId(), (ActionListener)listener)) {
                    boolean hasPermission = this.connectorAccessControlHelper.validateConnectorAccess(this.client, (Connector)connector);
                    if (hasPermission) {
                        connector.update(mlUpdateConnectorAction.getUpdateContent(), (arg_0, arg_1) -> ((MLEngine)this.mlEngine).encrypt(arg_0, arg_1));
                        connector.validateConnectorURL(this.trustedConnectorEndpointsRegex);
                        connector.setLastUpdateTime(Instant.now());
                        UpdateDataObjectRequest updateDataObjectRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(".plugins-ml-connector")).id(connectorId)).tenantId(tenantId)).dataObject((ToXContentObject)connector).build();
                        try (ThreadContext.StoredContext innerContext = this.client.threadPool().getThreadContext().stashContext();){
                            this.updateUndeployedConnector(connectorId, updateDataObjectRequest, (ActionListener<UpdateResponse>)ActionListenerHelper.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)innerContext).restore()));
                        }
                    } else {
                        listener.onFailure((Exception)new IllegalArgumentException("You don't have permission to update the connector, connector id: " + connectorId));
                    }
                }
            }, exception -> {
                log.error("Permission denied: Unable to update the connector with ID {}. Details: {}", (Object)connectorId, exception);
                listener.onFailure(exception);
            }));
        }
        catch (Exception e) {
            log.error("Failed to update ML connector for connector id {}. Details {}:", (Object)connectorId, (Object)e);
            listener.onFailure(e);
        }
    }

    private void updateUndeployedConnector(String connectorId, UpdateDataObjectRequest updateDataObjectRequest, ActionListener<UpdateResponse> listener) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"connector_id", (Object)connectorId));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.idsQuery().addIds(this.mlModelManager.getAllModelIds()));
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        SearchDataObjectRequest searchDataObjectRequest = SearchDataObjectRequest.builder().indices(new String[]{".plugins-ml-model"}).tenantId(updateDataObjectRequest.tenantId()).searchSourceBuilder(sourceBuilder).build();
        this.sdkClient.searchDataObjectAsync(searchDataObjectRequest).whenComplete((sr, st) -> {
            block8: {
                if (sr != null) {
                    try {
                        SearchResponse searchResponse = sr.searchResponse();
                        SearchHit[] searchHits = searchResponse.getHits().getHits();
                        if (searchHits.length == 0) {
                            this.sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((r, throwable) -> this.handleUpdateDataObjectCompletionStage((UpdateDataObjectResponse)r, (Throwable)throwable, this.getUpdateResponseListener(connectorId, listener)));
                            break block8;
                        }
                        log.error("{} models are still using this connector, please undeploy the models first!", (Object)searchHits.length);
                        ArrayList<String> modelIds = new ArrayList<String>();
                        for (SearchHit hit : searchHits) {
                            modelIds.add(hit.getId());
                        }
                        listener.onFailure((Exception)new SkyliteStatusException(searchHits.length + " models are still using this connector, please undeploy the models first: " + Arrays.toString(modelIds.toArray(new String[0])), RestStatus.BAD_REQUEST, new Object[0]));
                    }
                    catch (Exception e) {
                        log.error("Failed to parse search response", (Throwable)e);
                        listener.onFailure((Exception)new SkyliteStatusException("Failed to parse search response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                    }
                } else {
                    Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)st, (Class[])new Class[0]);
                    if (SkyliteExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                        this.sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((r, throwable) -> this.handleUpdateDataObjectCompletionStage((UpdateDataObjectResponse)r, (Throwable)throwable, this.getUpdateResponseListener(connectorId, listener)));
                    } else {
                        log.error("Failed to update ML connector: {}", (Object)connectorId);
                        listener.onFailure(cause);
                    }
                }
            }
        });
    }

    private void handleUpdateDataObjectCompletionStage(UpdateDataObjectResponse r, Throwable throwable, ActionListener<UpdateResponse> updateListener) {
        if (throwable != null) {
            Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            updateListener.onFailure(cause);
        } else {
            try {
                updateListener.onResponse((Object)r.updateResponse());
            }
            catch (Exception e) {
                updateListener.onFailure(e);
            }
        }
    }

    private ActionListener<UpdateResponse> getUpdateResponseListener(String connectorId, ActionListener<UpdateResponse> actionListener) {
        return ActionListenerHelper.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
                log.error("Failed to update the connector with ID: {}", (Object)connectorId);
                actionListener.onResponse(updateResponse);
                return;
            }
            log.info("Successfully updated the connector with ID: {}", (Object)connectorId);
            actionListener.onResponse(updateResponse);
        }, exception -> {
            log.error("Failed to update ML connector with ID {}. Details: {}", (Object)connectorId, exception);
            actionListener.onFailure(exception);
        });
    }
}

