/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.controller;

import io.lucenia.ml.common.engine.systemindices.MLIndicesHandler;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.controller.MLController;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelCacheHelper;
import io.skylite.ml.common.model.MLModelState;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.controller.MLCreateControllerRequest;
import io.skylite.ml.common.transport.controller.MLCreateControllerResponse;
import io.skylite.ml.common.transport.controller.MLDeployControllerAction;
import io.skylite.ml.common.transport.controller.MLDeployControllerNodesRequest;
import io.skylite.ml.common.transport.controller.MLDeployControllerNodesResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateControllerTransportAction
extends HandledTransportAction<ActionRequest, MLCreateControllerResponse> {
    private static final Logger log = LogManager.getLogger(CreateControllerTransportAction.class);
    private final MLIndicesHandler mlIndicesHandler;
    private final Client client;
    private final MLModelManager mlModelManager;
    private final ClusterService clusterService;
    private final MLModelCacheHelper mlModelCacheHelper;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public CreateControllerTransportAction(TransportService transportService, ActionFilters actionFilters, MLIndicesHandler mlIndicesHandler, Client client, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLModelCacheHelper mlModelCacheHelper, MLModelManager mlModelManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/controllers/create", transportService, actionFilters, MLCreateControllerRequest::new);
        this.mlIndicesHandler = mlIndicesHandler;
        this.client = client;
        this.mlModelManager = mlModelManager;
        this.clusterService = clusterService;
        this.mlModelCacheHelper = mlModelCacheHelper;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLCreateControllerResponse> actionListener) {
        MLCreateControllerRequest createControllerRequest = MLCreateControllerRequest.fromActionRequest((ActionRequest)request);
        MLController controller = createControllerRequest.getControllerInput();
        String modelId = controller.getModelId();
        User user = RestActionUtils.getUserContext(this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (!this.mlFeatureEnabledSetting.isControllerEnabled().booleanValue()) {
                throw new IllegalStateException("Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.");
            }
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.mlModelManager.getModel(modelId, null, excludes, (ActionListener<MLModel>)ActionListenerHelper.wrap(mlModel -> {
                FunctionName functionName = mlModel.getAlgorithm();
                Boolean isHidden = mlModel.getIsHidden();
                if (functionName == FunctionName.TEXT_EMBEDDING || functionName == FunctionName.REMOTE) {
                    this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(hasPermission -> {
                        if (hasPermission.booleanValue()) {
                            if (mlModel.getModelState() != MLModelState.DEPLOYING) {
                                this.indexAndCreateController((MLModel)mlModel, controller, (ActionListener<MLCreateControllerResponse>)wrappedListener);
                            } else {
                                String errorMessage = "Creating a model controller during its corresponding model in DEPLOYING state is not allowed, please either create the model controller after it is deployed or before deploying it.";
                                errorMessage = Strings.getErrorMessage((String)errorMessage, (String)modelId, (boolean)isHidden);
                                log.error(errorMessage);
                                wrappedListener.onFailure((Exception)new SkyliteStatusException(errorMessage, RestStatus.CONFLICT, new Object[0]));
                            }
                        } else {
                            String errorMessage = "User doesn't have privilege to perform this operation on this model controller.";
                            errorMessage = Strings.getErrorMessage((String)errorMessage, (String)modelId, (boolean)isHidden);
                            log.error(errorMessage);
                            wrappedListener.onFailure((Exception)new SkyliteStatusException(errorMessage, RestStatus.FORBIDDEN, new Object[0]));
                        }
                    }, exception -> {
                        log.error(Strings.getErrorMessage((String)"Permission denied: Unable to create the model controller. Details: {}", (String)modelId, (boolean)isHidden), (Throwable)exception);
                        wrappedListener.onFailure(exception);
                    }));
                } else {
                    wrappedListener.onFailure((Exception)new SkyliteStatusException("Creating model controller on this operation on the function category " + functionName.toString() + " is not supported.", RestStatus.FORBIDDEN, new Object[0]));
                }
            }, e -> wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model to create the corresponding model controller with the provided model ID", RestStatus.NOT_FOUND, new Object[0]))));
        }
        catch (Exception e2) {
            log.error("Failed to create model controller", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    private void indexAndCreateController(MLModel mlModel, MLController controller, ActionListener<MLCreateControllerResponse> actionListener) {
        Boolean isHidden = mlModel.getIsHidden();
        this.mlIndicesHandler.initMLControllerIndex((ActionListener<Boolean>)ActionListenerHelper.wrap(indexCreated -> {
            if (!indexCreated.booleanValue()) {
                actionListener.onFailure((Exception)new RuntimeException("Failed to create model controller index."));
                return;
            }
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                ActionListener indexResponseListener = ActionListenerHelper.wrap(indexResponse -> {
                    String[] workerNodes;
                    String modelId = indexResponse.getId();
                    MLCreateControllerResponse response = new MLCreateControllerResponse(modelId, indexResponse.getResult().name());
                    log.info("Model controller saved into index, result:{} {}", (Object)modelId, (Object)indexResponse.getResult());
                    if (indexResponse.getResult() == DocWriteResponse.Result.CREATED) {
                        this.mlModelManager.updateModel(modelId, isHidden, Map.of("is_controller_enabled", true));
                    }
                    if ((workerNodes = this.mlModelCacheHelper.getWorkerNodes(modelId)) != null && workerNodes.length != 0) {
                        log.info(Strings.getErrorMessage((String)"The model is deployed. Start to deploy the model controller into cache.", (String)modelId, (boolean)isHidden));
                        String[] targetNodeIds = this.mlModelManager.getWorkerNodes(modelId, mlModel.getAlgorithm());
                        MLDeployControllerNodesRequest deployControllerNodesRequest = new MLDeployControllerNodesRequest(targetNodeIds, controller.getModelId());
                        this.client.execute((ActionType)MLDeployControllerAction.INSTANCE, (ActionRequest)deployControllerNodesRequest, ActionListenerHelper.wrap(nodesResponse -> {
                            if (nodesResponse != null && this.isDeployControllerSuccessOnAllNodes((MLDeployControllerNodesResponse)nodesResponse)) {
                                log.info(Strings.getErrorMessage((String)"Successfully created model controller and deployed it into cache", (String)modelId, (boolean)isHidden));
                                actionListener.onResponse((Object)response);
                            } else {
                                Object[] nodeIds = this.getDeployControllerFailedNodesList((MLDeployControllerNodesResponse)nodesResponse);
                                Object msg = "Successfully created the model controller index, but deployment of the model controller to the cache failed on the following nodes " + Arrays.toString(nodeIds) + ". Please retry.";
                                msg = Strings.getErrorMessage((String)msg, (String)modelId, (boolean)isHidden);
                                actionListener.onFailure((Exception)new RuntimeException((String)msg));
                                log.error((String)msg);
                            }
                        }, e -> {
                            log.error("Failed to deploy model controller for the given model", (Throwable)e);
                            actionListener.onFailure(e);
                        }));
                    } else {
                        actionListener.onResponse((Object)response);
                    }
                }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0));
                IndexRequest indexRequest = new IndexRequest(".plugins-ml-controller").id(controller.getModelId());
                indexRequest.source(controller.toXContent(XContentBuilder.builder((XContent)MediaTypeRegistry.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.index(indexRequest, ActionListenerHelper.runBefore((ActionListener)indexResponseListener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
            catch (Exception e) {
                log.error("Failed to save model controller", (Throwable)e);
                actionListener.onFailure(e);
            }
        }, e -> {
            log.error("Failed to init model controller index", (Throwable)e);
            actionListener.onFailure(e);
        }));
    }

    private boolean isDeployControllerSuccessOnAllNodes(MLDeployControllerNodesResponse deployControllerNodesResponse) {
        return deployControllerNodesResponse.failures() == null || deployControllerNodesResponse.failures().isEmpty();
    }

    private String[] getDeployControllerFailedNodesList(MLDeployControllerNodesResponse deployControllerNodesResponse) {
        if (deployControllerNodesResponse == null) {
            return this.getAllNodes();
        }
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (FailedNodeException failedNodeException : deployControllerNodesResponse.failures()) {
            nodeIds.add(failedNodeException.nodeId());
        }
        return nodeIds.toArray(new String[0]);
    }

    private String[] getAllNodes() {
        Iterator iterator = this.clusterService.state().nodes().iterator();
        ArrayList<String> nodeIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            nodeIds.add(((DiscoveryNode)iterator.next()).getId());
        }
        return nodeIds.toArray(new String[0]);
    }
}

