/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.controller;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.stats.MLStats;
import io.skylite.ml.common.transport.controller.MLDeployControllerNodeRequest;
import io.skylite.ml.common.transport.controller.MLDeployControllerNodeResponse;
import io.skylite.ml.common.transport.controller.MLDeployControllerNodesRequest;
import io.skylite.ml.common.transport.controller.MLDeployControllerNodesResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeployControllerTransportAction
extends TransportNodesAction<MLDeployControllerNodesRequest, MLDeployControllerNodesResponse, MLDeployControllerNodeRequest, MLDeployControllerNodeResponse> {
    private static final Logger log = LogManager.getLogger(DeployControllerTransportAction.class);
    private final MLModelManager mlModelManager;
    private final ClusterService clusterService;
    private final Client client;
    private DiscoveryNodeHelper nodeFilter;
    private final MLStats mlStats;
    private NamedXContentRegistry xContentRegistry;
    private ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public DeployControllerTransportAction(TransportService transportService, ActionFilters actionFilters, MLModelManager mlModelManager, ClusterService clusterService, ThreadPool threadPool, Client client, DiscoveryNodeHelper nodeFilter, MLStats mlStats, NamedXContentRegistry xContentRegistry, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/lucenia/ml/controllers/deploy", threadPool, clusterService, transportService, actionFilters, MLDeployControllerNodesRequest::new, MLDeployControllerNodeRequest::new, "management", MLDeployControllerNodeResponse.class);
        this.mlModelManager = mlModelManager;
        this.clusterService = clusterService;
        this.client = client;
        this.nodeFilter = nodeFilter;
        this.mlStats = mlStats;
        this.xContentRegistry = xContentRegistry;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected MLDeployControllerNodesResponse newResponse(MLDeployControllerNodesRequest request, List<MLDeployControllerNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLDeployControllerNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLDeployControllerNodeRequest newNodeRequest(MLDeployControllerNodesRequest request) {
        return new MLDeployControllerNodeRequest(request);
    }

    protected MLDeployControllerNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLDeployControllerNodeResponse(in);
    }

    protected MLDeployControllerNodeResponse nodeOperation(MLDeployControllerNodeRequest request) {
        return this.createDeployControllerNodeResponse(request.getDeployControllerNodesRequest());
    }

    private MLDeployControllerNodeResponse createDeployControllerNodeResponse(MLDeployControllerNodesRequest deployControllerNodesRequest) {
        String modelId = deployControllerNodesRequest.getModelId();
        HashMap<String, String> controllerDeployStatus = new HashMap<String, String>();
        controllerDeployStatus.put(modelId, "received");
        String localNodeId = this.clusterService.localNode().getId();
        this.mlModelManager.deployControllerWithDeployedModel(modelId, (ActionListener<String>)ActionListenerHelper.wrap(r -> log.info("Successfully deployed model controller on node {}", (Object)localNodeId), e -> log.error("Failed to deploy model controller on node {}", (Object)localNodeId)));
        return new MLDeployControllerNodeResponse(this.clusterService.localNode(), controllerDeployStatus);
    }
}

