/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.controller;

import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.MLNodeUtils;
import io.skylite.ml.common.controller.MLController;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.controller.MLControllerGetRequest;
import io.skylite.ml.common.transport.controller.MLControllerGetResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetControllerTransportAction
extends HandledTransportAction<ActionRequest, MLControllerGetResponse> {
    private static final Logger log = LogManager.getLogger(GetControllerTransportAction.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final MLModelManager mlModelManager;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public GetControllerTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, MLModelManager mlModelManager, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/controllers/get", transportService, actionFilters, MLControllerGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.mlModelManager = mlModelManager;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLControllerGetResponse> actionListener) {
        MLControllerGetRequest controllerGetRequest = MLControllerGetRequest.fromActionRequest((ActionRequest)request);
        String modelId = controllerGetRequest.getModelId();
        FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(controllerGetRequest.isReturnContent());
        GetRequest getRequest = new GetRequest(".plugins-ml-controller").id(modelId).fetchSourceContext(fetchSourceContext);
        User user = RestActionUtils.getUserContext(this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (!this.mlFeatureEnabledSetting.isControllerEnabled().booleanValue()) {
                throw new IllegalStateException("Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.");
            }
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.client.get(getRequest, ActionListenerHelper.wrap(r -> {
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry((NamedXContentRegistry)this.xContentRegistry, (BytesReference)r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLController controller = MLController.parse((XContentParser)parser);
                        this.mlModelManager.getModel(modelId, null, excludes, (ActionListener<MLModel>)ActionListenerHelper.wrap(mlModel -> {
                            Boolean isHidden = mlModel.getIsHidden();
                            this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(hasPermission -> {
                                if (hasPermission.booleanValue()) {
                                    wrappedListener.onResponse((Object)MLControllerGetResponse.builder().controller(controller).build());
                                } else {
                                    wrappedListener.onFailure((Exception)new SkyliteStatusException(Strings.getErrorMessage((String)"User doesn't have privilege to perform this operation on this model controller.", (String)modelId, (boolean)isHidden), RestStatus.FORBIDDEN, new Object[0]));
                                }
                            }, exception -> {
                                log.error(Strings.getErrorMessage((String)"Permission denied: Unable to create the model controller for the given model.", (String)modelId, (boolean)isHidden), (Throwable)exception);
                                wrappedListener.onFailure(exception);
                            }));
                        }, e -> wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model to get the corresponding model controller with the provided model ID", RestStatus.NOT_FOUND, new Object[0]))));
                    }
                    catch (Exception e2) {
                        log.error("Failed to find model controller with the provided model ID", (Throwable)e2);
                        wrappedListener.onFailure(e2);
                    }
                } else {
                    wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model controller with the provided model ID", RestStatus.NOT_FOUND, new Object[0]));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    log.error("Failed to get model controller index", (Throwable)e);
                    wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model controller", RestStatus.NOT_FOUND, new Object[0]));
                } else {
                    log.error("Failed to get model controller for the provided model ID", (Throwable)e);
                    wrappedListener.onFailure(e);
                }
            }));
        }
        catch (Exception e2) {
            log.error("Failed to get model controller ", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

