/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.controller;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.stats.MLStats;
import io.skylite.ml.common.transport.controller.MLUndeployControllerNodeRequest;
import io.skylite.ml.common.transport.controller.MLUndeployControllerNodeResponse;
import io.skylite.ml.common.transport.controller.MLUndeployControllerNodesRequest;
import io.skylite.ml.common.transport.controller.MLUndeployControllerNodesResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UndeployControllerTransportAction
extends TransportNodesAction<MLUndeployControllerNodesRequest, MLUndeployControllerNodesResponse, MLUndeployControllerNodeRequest, MLUndeployControllerNodeResponse> {
    private static final Logger log = LogManager.getLogger(UndeployControllerTransportAction.class);
    private final MLModelManager mlModelManager;
    private final ClusterService clusterService;
    private final Client client;
    private DiscoveryNodeHelper nodeFilter;
    private final MLStats mlStats;
    private NamedXContentRegistry xContentRegistry;
    private ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public UndeployControllerTransportAction(TransportService transportService, ActionFilters actionFilters, MLModelManager mlModelManager, ClusterService clusterService, ThreadPool threadPool, Client client, DiscoveryNodeHelper nodeFilter, MLStats mlStats, NamedXContentRegistry xContentRegistry, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/lucenia/ml/controllers/undeploy", threadPool, clusterService, transportService, actionFilters, MLUndeployControllerNodesRequest::new, MLUndeployControllerNodeRequest::new, "management", MLUndeployControllerNodeResponse.class);
        this.mlModelManager = mlModelManager;
        this.clusterService = clusterService;
        this.client = client;
        this.nodeFilter = nodeFilter;
        this.mlStats = mlStats;
        this.xContentRegistry = xContentRegistry;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected MLUndeployControllerNodesResponse newResponse(MLUndeployControllerNodesRequest request, List<MLUndeployControllerNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLUndeployControllerNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLUndeployControllerNodeRequest newNodeRequest(MLUndeployControllerNodesRequest request) {
        return new MLUndeployControllerNodeRequest(request);
    }

    protected MLUndeployControllerNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLUndeployControllerNodeResponse(in);
    }

    protected MLUndeployControllerNodeResponse nodeOperation(MLUndeployControllerNodeRequest request) {
        return this.createUndeployControllerNodeResponse(request.getUndeployControllerNodesRequest());
    }

    private MLUndeployControllerNodeResponse createUndeployControllerNodeResponse(MLUndeployControllerNodesRequest undeployControllerNodesRequest) {
        String modelId = undeployControllerNodesRequest.getModelId();
        HashMap<String, String> controllerUndeployStatus = new HashMap<String, String>();
        controllerUndeployStatus.put(modelId, "received");
        String localNodeId = this.clusterService.localNode().getId();
        this.mlModelManager.undeployController(modelId, (ActionListener<String>)ActionListenerHelper.wrap(r -> log.info("Successfully undeployed model controller for the given model on node {}", (Object)localNodeId), e -> log.error("Failed to undeploy model controller for the given model on node {}", (Object)localNodeId)));
        return new MLUndeployControllerNodeResponse(this.clusterService.localNode(), controllerUndeployStatus);
    }
}

