/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.controller;

import io.lucenia.ml.common.action.connector.UpdateConnectorTransportAction;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.controller.MLController;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelCacheHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.controller.MLDeployControllerAction;
import io.skylite.ml.common.transport.controller.MLDeployControllerNodesRequest;
import io.skylite.ml.common.transport.controller.MLDeployControllerNodesResponse;
import io.skylite.ml.common.transport.controller.MLUpdateControllerRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateControllerTransportAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    private static final Logger log = LogManager.getLogger(UpdateConnectorTransportAction.class);
    private final Client client;
    private final MLModelManager mlModelManager;
    private final MLModelCacheHelper mlModelCacheHelper;
    private final ClusterService clusterService;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public UpdateControllerTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLModelCacheHelper mlModelCacheHelper, MLModelManager mlModelManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/controllers/update", transportService, actionFilters, MLUpdateControllerRequest::new);
        this.client = client;
        this.mlModelManager = mlModelManager;
        this.clusterService = clusterService;
        this.mlModelCacheHelper = mlModelCacheHelper;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> actionListener) {
        MLUpdateControllerRequest updateControllerRequest = MLUpdateControllerRequest.fromActionRequest((ActionRequest)request);
        MLController updateControllerInput = updateControllerRequest.getUpdateControllerInput();
        String modelId = updateControllerInput.getModelId();
        User user = RestActionUtils.getUserContext(this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (!this.mlFeatureEnabledSetting.isControllerEnabled().booleanValue()) {
                throw new IllegalStateException("Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.");
            }
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.mlModelManager.getModel(modelId, null, excludes, (ActionListener<MLModel>)ActionListenerHelper.wrap(mlModel -> {
                FunctionName functionName = mlModel.getAlgorithm();
                Boolean isHidden = mlModel.getIsHidden();
                if (functionName == FunctionName.TEXT_EMBEDDING || functionName == FunctionName.REMOTE) {
                    this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(hasPermission -> {
                        if (hasPermission.booleanValue()) {
                            this.mlModelManager.getController(modelId, (ActionListener<MLController>)ActionListenerHelper.wrap(controller -> {
                                boolean isDeployRequiredAfterUpdate = controller.isDeployRequiredAfterUpdate(updateControllerInput);
                                controller.update(updateControllerInput);
                                this.updateController((MLModel)mlModel, (MLController)controller, isDeployRequiredAfterUpdate, (ActionListener<UpdateResponse>)wrappedListener);
                            }, e -> {
                                if (mlModel.getIsControllerEnabled() == null || !mlModel.getIsControllerEnabled().booleanValue()) {
                                    String errorMsg = Strings.getErrorMessage((String)"Model controller haven't been created for the model. Consider calling create model controller api instead.", (String)modelId, (boolean)isHidden);
                                    wrappedListener.onFailure((Exception)new SkyliteStatusException(errorMsg, RestStatus.CONFLICT, new Object[0]));
                                    log.error(errorMsg, (Throwable)e);
                                } else {
                                    log.error("exception: ", (Throwable)e);
                                    wrappedListener.onFailure(e);
                                }
                            }));
                        } else {
                            wrappedListener.onFailure((Exception)new SkyliteStatusException(Strings.getErrorMessage((String)"User doesn't have privilege to perform this operation on this model controller.", (String)modelId, (boolean)isHidden), RestStatus.FORBIDDEN, new Object[0]));
                        }
                    }, exception -> {
                        log.error(Strings.getErrorMessage((String)"Permission denied: Unable to create the model controller for the model. Details: ", (String)modelId, (boolean)isHidden), (Throwable)exception);
                        wrappedListener.onFailure(exception);
                    }));
                } else {
                    wrappedListener.onFailure((Exception)new SkyliteStatusException("Creating model controller on this operation on the function category " + functionName.toString() + " is not supported.", RestStatus.FORBIDDEN, new Object[0]));
                }
            }, e -> wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model to create the corresponding model controller with the provided model ID", RestStatus.NOT_FOUND, new Object[0]))));
        }
        catch (Exception e2) {
            log.error("Failed to create model controller for the provided model", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    private void updateController(MLModel mlModel, MLController controller, boolean isDeployRequiredAfterUpdate, ActionListener<UpdateResponse> actionListener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            String modelId = mlModel.getModelId();
            Boolean isHidden = mlModel.getIsHidden();
            ActionListener updateResponseListener = ActionListenerHelper.wrap(updateResponse -> {
                if (updateResponse != null && updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                    log.info("Model controller successfully updated to index, result: {} {}", (Object)modelId, (Object)updateResponse.getResult());
                    if (this.mlModelCacheHelper.getWorkerNodes(modelId).length != 0 && isDeployRequiredAfterUpdate) {
                        log.info(Strings.getErrorMessage((String)"The model is deployed and the user rate limiter config is constructable. Start to deploy the model controller into cache.", (String)modelId, (boolean)isHidden));
                        String[] targetNodeIds = this.mlModelManager.getWorkerNodes(modelId, mlModel.getAlgorithm());
                        MLDeployControllerNodesRequest deployControllerNodesRequest = new MLDeployControllerNodesRequest(targetNodeIds, modelId);
                        this.client.execute((ActionType)MLDeployControllerAction.INSTANCE, (ActionRequest)deployControllerNodesRequest, ActionListenerHelper.wrap(nodesResponse -> {
                            if (nodesResponse != null && this.isDeployControllerSuccessOnAllNodes((MLDeployControllerNodesResponse)nodesResponse)) {
                                log.info(Strings.getErrorMessage((String)"Successfully update model controller and deploy it into cache", (String)modelId, (boolean)isHidden));
                                actionListener.onResponse(updateResponse);
                            } else {
                                Object[] nodeIds = this.getDeployControllerFailedNodesList((MLDeployControllerNodesResponse)nodesResponse);
                                String errorMessage = Strings.getErrorMessage((String)("Successfully update model controller index but deploy model controller to cache was failed on following nodes " + Arrays.toString(nodeIds) + ", please retry."), (String)modelId, (boolean)isHidden);
                                log.error(errorMessage);
                                actionListener.onFailure((Exception)new RuntimeException(errorMessage));
                            }
                        }, e -> {
                            log.error(Strings.getErrorMessage((String)"Failed to deploy model controller for model", (String)modelId, (boolean)isHidden));
                            actionListener.onFailure(e);
                        }));
                    } else {
                        actionListener.onResponse(updateResponse);
                    }
                } else if (updateResponse != null && updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
                    log.warn("Update model controller got a result status other than update, result status: {} {}", (Object)modelId, (Object)updateResponse.getResult());
                    actionListener.onResponse(updateResponse);
                } else {
                    String msg = Strings.getErrorMessage((String)"Failed to update model controller.", (String)modelId, (boolean)isHidden);
                    log.error(msg);
                    actionListener.onFailure((Exception)new RuntimeException(msg));
                }
            }, arg_0 -> actionListener.onFailure(arg_0));
            UpdateRequest updateRequest = new UpdateRequest(".plugins-ml-controller", modelId);
            updateRequest.doc(controller.toXContent(MediaTypeRegistry.JSON.contentBuilder(), ToXContent.EMPTY_PARAMS));
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.update(updateRequest, ActionListenerHelper.runBefore((ActionListener)updateResponseListener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e) {
            log.error("Failed to update model controller.", (Throwable)e);
            actionListener.onFailure(e);
        }
    }

    private boolean isDeployControllerSuccessOnAllNodes(MLDeployControllerNodesResponse deployControllerNodesResponse) {
        return deployControllerNodesResponse.failures() == null || deployControllerNodesResponse.failures().isEmpty();
    }

    private String[] getDeployControllerFailedNodesList(MLDeployControllerNodesResponse deployControllerNodesResponse) {
        if (deployControllerNodesResponse == null) {
            return this.getAllNodes();
        }
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (FailedNodeException failedNodeException : deployControllerNodesResponse.failures()) {
            nodeIds.add(failedNodeException.nodeId());
        }
        return nodeIds.toArray(new String[0]);
    }

    private String[] getAllNodes() {
        Iterator iterator = this.clusterService.state().nodes().iterator();
        ArrayList<String> nodeIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            nodeIds.add(((DiscoveryNode)iterator.next()).getId());
        }
        return nodeIds.toArray(new String[0]);
    }
}

