/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.mcpserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.server.McpStatelessServerHandler;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import io.modelcontextprotocol.util.Assert;
import java.security.AccessController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Mono;

public class LuceniaMcpStatelessServerTransportProvider
implements McpStatelessServerTransport {
    private static final Logger log = LogManager.getLogger(LuceniaMcpStatelessServerTransportProvider.class);
    private final ObjectMapper objectMapper;
    private McpStatelessServerHandler mcpHandler;

    public LuceniaMcpStatelessServerTransportProvider(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    public void setMcpHandler(McpStatelessServerHandler mcpHandler) {
        this.mcpHandler = mcpHandler;
        log.info("MCP handler set for stateless transport provider: {}", (Object)(mcpHandler != null ? "SUCCESS" : "FAILED"));
    }

    public Mono<Void> closeGracefully() {
        log.debug("Closing stateless MCP transport provider gracefully");
        return Mono.empty();
    }

    public Mono<McpSchema.JSONRPCMessage> handleRequest(McpSchema.JSONRPCMessage message) {
        try {
            if (this.mcpHandler == null) {
                log.error("MCP handler is null - server may not be properly initialized");
                return Mono.error((Throwable)new RuntimeException("MCP handler not initialized"));
            }
            if (message instanceof McpSchema.JSONRPCRequest) {
                McpSchema.JSONRPCRequest request = (McpSchema.JSONRPCRequest)message;
                log.debug("Handling JSON-RPC request: {}", (Object)request.method());
                return Mono.fromCallable(() -> AccessController.doPrivileged(() -> {
                    try {
                        return (McpSchema.JSONRPCMessage)this.mcpHandler.handleRequest(McpTransportContext.EMPTY, request).block();
                    }
                    catch (Exception e) {
                        log.error("Error in privileged MCP handler execution", (Throwable)e);
                        return this.createErrorResponse(request, e);
                    }
                })).onErrorResume(error -> {
                    log.error("Failed to execute privileged MCP operation", error);
                    return Mono.just((Object)this.createErrorResponse(request, (Throwable)error));
                });
            }
            log.error("Unknown message type: {}", (Object)message.getClass().getSimpleName());
            return Mono.error((Throwable)new RuntimeException("Unknown message type: " + message.getClass().getSimpleName()));
        }
        catch (Exception e) {
            log.error(() -> "Failed to handle MCP request: " + e.getMessage(), (Throwable)e);
            return Mono.error((Throwable)e);
        }
    }

    private McpSchema.JSONRPCMessage createErrorResponse(McpSchema.JSONRPCRequest request, Throwable error) {
        try {
            int errorCode;
            String errorMessage;
            String string = errorMessage = error.getMessage() != null ? error.getMessage() : "Internal server error";
            if (errorMessage.contains("Missing handler for request type")) {
                errorCode = -32601;
                errorMessage = "Method not found";
            } else {
                errorCode = -32603;
            }
            McpSchema.JSONRPCResponse.JSONRPCError jsonError = new McpSchema.JSONRPCResponse.JSONRPCError(errorCode, errorMessage, null);
            return new McpSchema.JSONRPCResponse("2.0", request.id(), null, jsonError);
        }
        catch (Exception e) {
            log.error("Failed to create error response", (Throwable)e);
            throw new RuntimeException("Critical error in MCP handler", e);
        }
    }
}

